/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2736;
import net.minecraft.class_274;
import net.minecraft.class_2751;
import net.minecraft.class_2757;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5900;
import net.minecraft.class_9011;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.accessor.world.scores.PlayerTeamAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.scoreboard.SpongeScore;

@Mixin(value={class_2995.class})
public abstract class ServerScoreboardMixin
extends class_269
implements ServerScoreboardBridge {
    @Shadow
    @Final
    private Set<class_266> field_13427;
    private final List<class_3222> impl$players = new ArrayList<class_3222>();
    private boolean impl$apiCall;

    @Override
    public void bridge$addAPIObjective(Objective objective) {
        if (objective instanceof SpongeObjective) {
            SpongeObjective so = (SpongeObjective)objective;
            this.impl$apiCall = true;
            class_266 mcObjective = this.method_1168(objective.name(), (class_274)objective.criterion(), SpongeAdventure.asVanilla(objective.displayName()), (class_274.class_275)objective.displayMode(), so.displayAutoUpdate(), so.numberFormat());
            this.impl$apiCall = false;
            ((ObjectiveBridge)mcObjective).bridge$setSpongeObjective(so);
            so.register(this);
            for (Score score : objective.scores().values()) {
                SpongeScore spongeScore = (SpongeScore)score;
                class_9014 accessor = this.method_1180(spongeScore.holder, mcObjective);
                spongeScore.registerAndUpdate(mcObjective, accessor);
            }
        }
    }

    @Override
    public void bridge$addMCObjective(class_266 mcObjective) {
        if (!this.impl$apiCall) {
            SpongeObjective objective = SpongeObjective.fromVanilla(mcObjective);
            objective.register(this);
        }
    }

    @Override
    public Optional<Objective> bridge$getObjective(String name) {
        class_266 objective = this.method_1170(name);
        return Optional.ofNullable(objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    @Override
    public Optional<Objective> bridge$getObjective(DisplaySlot slot) {
        class_266 objective = ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives().get(slot);
        if (objective != null) {
            return Optional.of(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    @Override
    public Set<Objective> bridge$getObjectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().containsKey((Object)criterion)) {
            return ((List)((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get((Object)criterion)).stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<Objective>();
    }

    @Override
    public void bridge$removeAPIObjective(Objective objective) {
        if (objective instanceof SpongeObjective) {
            SpongeObjective so = (SpongeObjective)objective;
            this.impl$apiCall = true;
            class_266 mcObjective = this.method_1170(objective.name());
            this.method_1194(mcObjective);
            this.impl$apiCall = false;
            so.unregister(this);
        }
        for (Score score : objective.scores().values()) {
            objective.removeScore(score);
        }
    }

    @Override
    public void bridge$removeMCObjective(class_266 mcObjective) {
        if (!this.impl$apiCall) {
            this.bridge$removeAPIObjective(((ObjectiveBridge)mcObjective).bridge$getSpongeObjective());
        }
    }

    @Override
    public void bridge$removeMCScore(class_9015 holder, class_266 mcObjective) {
        if (!this.impl$apiCall) {
            SpongeObjective objective = ((ObjectiveBridge)mcObjective).bridge$getSpongeObjective();
            objective.removeScore(holder.method_5820());
        }
    }

    @Override
    public void bridge$registerTeam(Team spongeTeam) {
        class_268 team = (class_268)spongeTeam;
        if (this.method_1153(spongeTeam.name()) != null) {
            throw new IllegalArgumentException(String.format("A team with the name '%s' already exists!", spongeTeam.name()));
        }
        if (((PlayerTeamAccessor)team).accessor$scoreboard() != null) {
            throw new IllegalArgumentException("The passed in team is already registered to a scoreboard!");
        }
        ((PlayerTeamAccessor)team).accessor$scoreboard(this);
        ((ScoreboardAccessor)((Object)this)).accessor$teamsByName().put((Object)team.method_1197(), (Object)team);
        for (String entry : team.method_1204()) {
            this.method_1172(entry, team);
        }
        this.method_1160(team);
    }

    @Override
    public void bridge$sendToPlayers(class_2596<?> packet) {
        for (class_3222 player : this.impl$players) {
            player.field_13987.method_14364(packet);
        }
    }

    @Override
    public void bridge$addPlayer(class_3222 player, boolean sendPackets) {
        this.impl$players.add(player);
        if (sendPackets) {
            for (class_268 team : this.method_1159()) {
                player.field_13987.method_14364((class_2596)class_5900.method_34172((class_268)team, (boolean)true));
            }
            for (class_266 objective : this.field_13427) {
                player.field_13987.method_14364((class_2596)new class_2751(objective, 0));
                ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives().forEach((displaySlot, objective1) -> {
                    if (objective1 == objective) {
                        player.field_13987.method_14364((class_2596)new class_2736(displaySlot, objective));
                    }
                });
                for (class_9011 score : this.method_1184(objective)) {
                    class_2757 packetIn = new class_2757(score.comp_2127(), objective.method_1113(), score.comp_2128(), Optional.ofNullable(score.comp_2129()), Optional.ofNullable(score.comp_2130()));
                    player.field_13987.method_14364((class_2596)packetIn);
                }
            }
        }
    }

    @Override
    public void bridge$removePlayer(class_3222 player, boolean sendPackets) {
        this.impl$players.remove(player);
        if (sendPackets) {
            this.impl$removeScoreboard(player);
        }
    }

    public void method_1191(class_268 team) {
        super.method_1191(team);
        ((PlayerTeamAccessor)team).accessor$scoreboard(null);
    }

    @Redirect(method={"method_1176(Lnet/minecraft/class_9015;Lnet/minecraft/class_266;Lnet/minecraft/class_267;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void onUpdateScoreValue(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1152(Lnet/minecraft/class_9015;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updatePlayersOnRemoval(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1190(Lnet/minecraft/class_9015;Lnet/minecraft/class_266;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updatePlayersOnRemovalOfObjective(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1158(Lnet/minecraft/class_8646;Lnet/minecraft/class_266;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updatePlayersOnSetDisplayObjective(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1172(Ljava/lang/String;Lnet/minecraft/class_268;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updatePlayersOnPlayerAdd(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1157(Ljava/lang/String;Lnet/minecraft/class_268;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updatePlayersOnPlayerRemoval(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1175(Lnet/minecraft/class_266;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updatePlayersOnObjectiveDisplay(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1160(Lnet/minecraft/class_268;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updateAllPlayersOnTeamCreation(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1154(Lnet/minecraft/class_268;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updateAllPlayersOnTeamInfo(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_1193(Lnet/minecraft/class_268;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$updateAllPlayersOnTeamRemoval(class_3324 manager, class_2596<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"method_12939(Lnet/minecraft/class_266;)V"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayers(List list) {
        return this.impl$players.iterator();
    }

    @Redirect(method={"method_12938(Lnet/minecraft/class_266;)V"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayersOnRemoval(List list) {
        return this.impl$players.iterator();
    }

    private void impl$removeScoreboard(class_3222 player) {
        this.impl$removeTeams(player);
        this.impl$removeObjectives(player);
    }

    private void impl$removeTeams(class_3222 player) {
        for (class_268 team : this.method_1159()) {
            player.field_13987.method_14364((class_2596)class_5900.method_34170((class_268)team));
        }
    }

    private void impl$removeObjectives(class_3222 player) {
        for (class_266 objective : this.method_1151()) {
            player.field_13987.method_14364((class_2596)new class_2751(objective, 1));
        }
    }

    @Override
    public void bridge$removeAPIScore(Objective spongeObjective, Score spongeScore) {
        this.impl$apiCall = true;
        class_9015 holder = ((SpongeScore)spongeScore).holder;
        class_266 mcObjective = this.method_1170(spongeObjective.name());
        this.method_1155(holder, mcObjective);
        ((SpongeScore)spongeScore).unregister(mcObjective);
        this.impl$apiCall = false;
    }
}

