/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_4706;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.Ticket;
import org.spongepowered.api.world.server.TicketType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.server.level.TicketAccessor;
import org.spongepowered.common.bridge.world.DistanceManagerBridge;
import org.spongepowered.common.bridge.world.server.TicketBridge;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_3204.class})
public abstract class DistanceManagerMixin
implements DistanceManagerBridge {
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<class_4706<class_3228<?>>> field_13895;
    @Shadow
    private long field_13894;

    @Shadow
    private void shadow$method_14042(long chunkpos, class_3228<?> ticket) {
    }

    @Shadow
    protected abstract void shadow$method_17645(long var1, class_3228<?> var3);

    @Override
    public boolean bridge$checkTicketValid(Ticket<?> ticket) {
        class_3228 nativeTicket = (class_3228)ticket;
        class_4706 ticketsForChunk = (class_4706)this.field_13895.get(((TicketBridge)ticket).bridge$chunkPosition());
        if (ticketsForChunk != null && ticketsForChunk.contains((Object)nativeTicket)) {
            return !((TicketAccessor)ticket).invoker$timedOut(this.field_13894);
        }
        return false;
    }

    @Override
    public Ticks bridge$timeLeft(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            long ticksElapsed = this.field_13894 - ((TicketAccessor)ticket).accessor$createdTick();
            return new SpongeTicks(Math.max(0L, ((class_3228)ticket).method_14281().method_20629() - ticksElapsed));
        }
        return Ticks.zero();
    }

    @Override
    public boolean bridge$renewTicket(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            class_3228 nativeTicket = (class_3228)ticket;
            ((TicketAccessor)ticket).invoker$setCreatedTick(this.field_13894 + nativeTicket.method_14281().method_20629());
            return true;
        }
        return false;
    }

    @Override
    public <S, T> Optional<Ticket<T>> bridge$registerTicket(ServerWorld world, TicketType<T> ticketType, Vector3i pos, T value, int distanceLimit) {
        int distance = class_3532.method_15340((int)(Constants.ChunkTicket.MAX_FULL_CHUNK_DISTANCE - distanceLimit), (int)0, (int)Constants.ChunkTicket.MAX_FULL_CHUNK_TICKET_LEVEL);
        class_3230 type = (class_3230)ticketType;
        class_3228<T> ticketToRequest = TicketAccessor.accessor$createInstance(type, distance, value);
        this.shadow$method_14042(VecHelper.toChunkPos(pos).method_8324(), ticketToRequest);
        return Optional.of(((TicketBridge)ticketToRequest).bridge$retrieveAppropriateTicket());
    }

    @Override
    public boolean bridge$releaseTicket(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            this.shadow$method_17645(((TicketBridge)ticket).bridge$chunkPosition(), (class_3228)ticket);
            return true;
        }
        return false;
    }

    @Override
    public <T> Collection<Ticket<T>> bridge$tickets(TicketType<T> ticketType) {
        return this.field_13895.values().stream().flatMap(x -> x.stream().filter(ticket -> ticket.method_14281() == ticketType)).map(x -> (Ticket)x).collect(Collectors.toList());
    }

    @Inject(method={"method_14042(JLnet/minecraft/class_3228;)V"}, at={@At(value="HEAD")})
    private void impl$addChunkPosToTicket(long chunkPos, class_3228<?> ticket, CallbackInfo ci) {
        ((TicketBridge)ticket).bridge$setChunkPosition(chunkPos);
    }

    @Redirect(method={"method_14042(JLnet/minecraft/class_3228;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3228;method_23956(J)V"))
    private void impl$setParentTicketIfApplicable(class_3228<?> storedTicket, long ticketTickCounter, long chunkPosAsLong, class_3228<?> originalTicket) {
        if (storedTicket != originalTicket) {
            ((TicketBridge)originalTicket).bridge$setParentTicket(storedTicket);
        }
        ((TicketAccessor)storedTicket).invoker$setCreatedTick(ticketTickCounter);
    }
}

