/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2619;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_2881;
import net.minecraft.class_3004;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3949;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_5217;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5562;
import net.minecraft.class_5579;
import net.minecraft.class_5712;
import net.minecraft.class_6757;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8565;
import net.minecraft.class_9892;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.event.world.ChangeWeatherEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.api.world.weather.WeatherUniverse;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.dimension.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.level.storage.ServerLevelDataBridge;
import org.spongepowered.common.bridge.world.ticks.LevelTicksBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.level.LevelMixin;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.server.SpongeServerLevelData;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_3218.class})
public abstract class ServerLevelMixin
extends LevelMixin
implements ServerLevelBridge {
    @Shadow
    @Final
    private class_5268 field_24456;
    @Shadow
    @Final
    private class_5579<class_1297> field_26935;
    @Shadow
    @Final
    private class_6757<class_2248> field_13949;
    @Shadow
    @Final
    private class_6757<class_3611> field_13951;
    @Shadow
    private int field_13948;
    @Shadow
    @Final
    private MinecraftServer field_13959;
    @Shadow
    private @Nullable class_2881 field_25142;
    @Shadow
    @Final
    private List<class_3222> field_18261;
    private final long[] impl$recentTickTimes = new long[100];
    private class_32.class_5143 impl$levelSave;
    private class_3004 impl$bossBarManager;
    private class_3949 impl$chunkProgressListener;
    private Weather impl$prevWeather;
    private boolean impl$isManualSave = false;
    private long impl$preTickTime = 0L;

    @Shadow
    public abstract @NonNull MinecraftServer shadow$method_8503();

    @Shadow
    public abstract void method_8444(@Nullable class_1657 var1, int var2, class_2338 var3, int var4);

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/class_32$class_5143;Lnet/minecraft/class_5268;Lnet/minecraft/class_5321;Lnet/minecraft/class_5363;Lnet/minecraft/class_3949;ZJLjava/util/List;ZLnet/minecraft/class_8565;)V"}, at={@At(value="TAIL")})
    private void impl$onInit(MinecraftServer server, Executor executor, class_32.class_5143 storage, class_5268 levelData, class_5321<class_1937> key, class_5363 levelStem, class_3949 listener, boolean debug, long biomeSeed, List<class_5304> spawners, boolean tick, class_8565 randomSequences, CallbackInfo ci) {
        SpongeServerLevelData spongeData = ((ServerLevelDataBridge)levelData).bridge$spongeData();
        ResourceKey worldKey = ((ServerWorld)this).key();
        if (spongeData.key() == null) {
            SpongeCommon.logger().warn("Level data ({}) has no key associated but is used by world {} ({}).", (Object)levelData.getClass().getSimpleName(), (Object)worldKey, (Object)this.getClass().getSimpleName());
            spongeData.setKey(worldKey);
        } else if (!spongeData.key().equals((Object)worldKey)) {
            SpongeCommon.logger().warn("Level data ({}) has key {} but is used by world {} ({}).", (Object)levelData.getClass().getSimpleName(), (Object)spongeData.key(), (Object)worldKey, (Object)this.getClass().getSimpleName());
        }
        if (spongeData.configAdapter() == null) {
            class_2874 dimensionType = (class_2874)levelStem.comp_1012().comp_349();
            spongeData.setConfigAdapter(SpongeGameConfigs.load(dimensionType, spongeData.key()));
        }
        this.impl$levelSave = storage;
        this.impl$chunkProgressListener = listener;
        this.impl$prevWeather = ((ServerWorld)this).weather();
        ((LevelTicksBridge)this.field_13949).bridge$level((class_3218)this);
        ((LevelTicksBridge)this.field_13951).bridge$level((class_3218)this);
        Boolean createDragonFight = ((DimensionTypeBridge)this.shadow$method_8597()).bridge$createDragonFight();
        if (createDragonFight != null) {
            if (createDragonFight.booleanValue()) {
                long seed = server.method_27728().method_28057().method_28028();
                this.field_25142 = new class_2881((class_3218)this, seed, server.method_27728().method_29036());
            } else {
                this.field_25142 = null;
            }
        }
        this.bridge$adjustDimensionLogic((class_2874)levelStem.comp_1012().comp_349());
    }

    @Override
    public class_32.class_5143 bridge$getLevelSave() {
        return this.impl$levelSave;
    }

    @Override
    public class_3949 bridge$getChunkProgressListener() {
        return this.impl$chunkProgressListener;
    }

    @Override
    public boolean bridge$isLoaded() {
        if (this.bridge$isFake()) {
            return false;
        }
        class_3218 world = this.shadow$method_8503().method_3847(this.shadow$method_27983());
        if (world == null) {
            return false;
        }
        return world == this;
    }

    @Override
    public void bridge$adjustDimensionLogic(class_2874 dimensionType) {
        if (this.bridge$isFake()) {
            return;
        }
        super.bridge$adjustDimensionLogic(dimensionType);
        this.impl$setWorldOnBorder();
    }

    @Override
    public class_3004 bridge$getBossBarManager() {
        if (this.impl$bossBarManager == null) {
            this.impl$bossBarManager = class_1937.field_25179.equals(this.shadow$method_27983()) || this.bridge$isFake() ? this.shadow$method_8503().method_3837() : new class_3004();
        }
        return this.impl$bossBarManager;
    }

    @Override
    public void bridge$triggerExplosion(Explosion explosion) {
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)this);
        if (ShouldFire.EXPLOSION_EVENT_PRE) {
            Cause cause = phaseTracker.currentCause();
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre((Cause)cause, (Explosion)explosion, (ServerWorld)((ServerWorld)this));
            if (SpongeCommon.post((Event)event)) {
                return;
            }
            explosion = event.explosion();
        }
        class_9892 mcExplosion = (class_9892)explosion;
        try (Object ignored = GeneralPhase.State.EXPLOSION.createPhaseContext(phaseTracker).explosion(mcExplosion).source(explosion.sourceExplosive().isPresent() ? explosion.sourceExplosive() : this);){
            ((PhaseContext)ignored).buildAndSwitch();
            mcExplosion.method_61737();
            class_2400 particle = mcExplosion.method_61739() ? class_2398.field_11236 : class_2398.field_11221;
            class_6880.class_6883 sound = class_3417.field_15152;
            for (class_3222 player : this.field_18261) {
                if (!(player.method_5707(mcExplosion.method_55109()) < 4096.0)) continue;
                Optional<class_243> kb = Optional.ofNullable((class_243)mcExplosion.method_61738().get(player));
                class_2664 packet = new class_2664(mcExplosion.method_55109(), kb, (class_2394)particle, (class_6880)sound);
                this.bridge$handleExplosionPacket(player.field_13987, explosion, packet);
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    @Override
    public void bridge$handleExplosionPacket(class_3244 instance, Explosion apiExplosion, class_2664 packet) {
        if (apiExplosion.shouldPlaySmoke()) {
            class_2664 newPacket = new class_2664(packet.comp_2883(), packet.comp_2884(), packet.comp_2885(), packet.comp_2886());
            instance.method_14364((class_2596)newPacket);
        } else {
            packet.comp_2884().ifPresent(kb -> instance.method_14364((class_2596)new class_2743(instance.field_14140.method_5628(), kb)));
        }
    }

    @Override
    public void bridge$setManualSave(boolean state) {
        this.impl$isManualSave = state;
    }

    @Override
    public BlockSnapshot bridge$createSnapshot(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        if (!((class_3218)this).method_24794(pos)) {
            return BlockSnapshot.empty();
        }
        if (!this.method_8393(x >> 4, z >> 4)) {
            return BlockSnapshot.empty();
        }
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.world((class_3218)this).position(new Vector3i(x, y, z));
        class_2818 chunk = this.shadow$method_8500(pos);
        class_2680 state = chunk.method_8320(pos);
        builder.blockState(state);
        class_2586 blockEntity = chunk.method_12201(pos, class_2818.class_2819.field_12859);
        if (blockEntity != null) {
            TrackingUtil.addTileEntityToBuilder(blockEntity, builder);
        }
        ((LevelChunkBridge)chunk).bridge$getBlockCreatorUUID(pos).ifPresent(builder::creator);
        ((LevelChunkBridge)chunk).bridge$getBlockNotifierUUID(pos).ifPresent(builder::notifier);
        builder.flag(BlockChangeFlags.NONE);
        return builder.build();
    }

    @Override
    public long[] bridge$recentTickTimes() {
        return this.impl$recentTickTimes;
    }

    @Redirect(method={"method_14188(Z)V", "method_8487(Lnet/minecraft/class_6862;Lnet/minecraft/class_2338;IZ)Lnet/minecraft/class_2338;", "method_28125()Z", "method_8412()J", "method_45162()Lnet/minecraft/class_7699;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_27728()Lnet/minecraft/class_5219;"))
    private class_5219 impl$usePerWorldLevelData(MinecraftServer server) {
        class_5217 levelData = this.shadow$method_8401();
        if (levelData instanceof class_5219) {
            class_5219 worldData = (class_5219)levelData;
            return worldData;
        }
        return server.method_27728();
    }

    @Redirect(method={"method_8554(Lnet/minecraft/class_2338;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1928;method_8356(Lnet/minecraft/class_1928$class_4313;)I"))
    private int impl$respectKeepSpawnLoaded(class_1928 gameRules, class_1928.class_4313<class_1928.class_4312> key) {
        if (((ServerLevelDataBridge)this.shadow$method_8401()).bridge$performsSpawnLogic()) {
            return gameRules.method_8356(key);
        }
        return 0;
    }

    @Inject(method={"method_14176(Lnet/minecraft/class_3536;ZZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void impl$postSaveWorldEventPre(CallbackInfo ci, @Share(value="manualSave") LocalBooleanRef manualSave) {
        manualSave.set(this.impl$isManualSave);
        this.impl$isManualSave = false;
        Cause currentCause = PhaseTracker.getInstance().currentCause();
        if (Sponge.eventManager().post((Event)SpongeEventFactory.createSaveWorldEventPre((Cause)currentCause, (ServerWorld)((ServerWorld)this)))) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"method_14176(Lnet/minecraft/class_3536;ZZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_14188(Z)V")})
    public void impl$wrapSaveLevelData(class_3218 self, boolean flush, Operation<Void> original) {
        class_5268 levelData = (class_5268)this.shadow$method_8401();
        SerializationBehavior behavior = ((ServerLevelDataBridge)levelData).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        if (behavior != SerializationBehavior.NONE) {
            original.call(new Object[]{self, flush});
            levelData.method_27415(this.method_8621().method_27355());
            if (levelData instanceof class_5219) {
                class_5219 worldData = (class_5219)levelData;
                worldData.method_221(this.bridge$getBossBarManager().method_12974((class_7225.class_7874)SpongeCommon.server().method_30611()));
                this.bridge$getLevelSave().method_27426((class_5455)SpongeCommon.server().method_30611(), worldData, this.shadow$method_27983() == class_1937.field_25179 ? SpongeCommon.server().method_3760().method_14567() : null);
            }
        }
    }

    @WrapWithCondition(method={"method_14176(Lnet/minecraft/class_3536;ZZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3215;method_17298(Z)V")})
    public boolean impl$wrapChunkCacheSave(class_3215 chunkCache, boolean flush, @Share(value="manualSave") LocalBooleanRef manualSave) {
        class_5268 levelData = (class_5268)this.shadow$method_8401();
        SerializationBehavior behavior = ((ServerLevelDataBridge)levelData).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        return behavior == SerializationBehavior.AUTOMATIC || manualSave.get() && behavior == SerializationBehavior.MANUAL;
    }

    @Inject(method={"method_14176(Lnet/minecraft/class_3536;ZZ)V"}, at={@At(value="TAIL")})
    public void impl$postSaveWorldEventPost(CallbackInfo ci) {
        Cause currentCause = PhaseTracker.getInstance().currentCause();
        Sponge.eventManager().post((Event)SpongeEventFactory.createSaveWorldEventPost((Cause)currentCause, (ServerWorld)((ServerWorld)this)));
    }

    @Inject(method={"method_39501()V"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="FIELD", target="Lnet/minecraft/class_3218;field_9253:F", shift=At.Shift.BEFORE, ordinal=1)})
    public void impl$onSetWeatherParameters(CallbackInfo ci, boolean $$0) {
        boolean isRaining = this.shadow$method_8419();
        if (this.field_9253 != this.field_9235 || this.field_9251 != this.field_9234 || $$0 != isRaining) {
            Weather newWeather = ((ServerWorld)this).properties().weather();
            Cause currentCause = PhaseTracker.getInstance().currentCause();
            Transaction weatherTransaction = new Transaction((DataSerializable)this.impl$prevWeather, (DataSerializable)newWeather);
            ChangeWeatherEvent event = SpongeEventFactory.createChangeWeatherEvent((Cause)currentCause, (WeatherUniverse)((ServerWorld)this), (Transaction)weatherTransaction);
            newWeather = Sponge.eventManager().post((Event)event) ? (Weather)event.weather().original() : (Weather)event.weather().finalReplacement();
            this.impl$prevWeather = newWeather;
            if (newWeather.type() == WeatherTypes.CLEAR.get()) {
                this.field_24456.method_173(0);
                this.field_24456.method_164(0);
                this.field_24456.method_167(SpongeTicks.toSaturatedIntOrInfinite(newWeather.remainingDuration()));
                this.field_24456.method_147(false);
                this.field_24456.method_157(false);
            } else {
                int newTime = SpongeTicks.toSaturatedIntOrInfinite(newWeather.remainingDuration());
                this.field_24456.method_157(true);
                this.field_24456.method_167(0);
                this.field_24456.method_164(newTime);
                if (newWeather.type() == WeatherTypes.THUNDER.get()) {
                    this.field_24456.method_173(newTime);
                    this.field_24456.method_147(true);
                } else {
                    this.field_24456.method_173(0);
                    this.field_24456.method_147(false);
                }
            }
        }
    }

    @Redirect(method={"method_18203(Lnet/minecraft/class_2818;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_8520(Lnet/minecraft/class_2338;)Z"))
    private boolean impl$onBeforeThunder(class_3218 serverLevel, class_2338 param0) {
        boolean rainingAt = serverLevel.method_8520(param0);
        if (rainingAt) {
            LightningEvent.Pre strike = SpongeEventFactory.createLightningEventPre((Cause)PhaseTracker.getInstance().currentCause());
            if (Sponge.eventManager().post((Event)strike)) {
                return false;
            }
        }
        return rainingAt;
    }

    @Inject(method={"method_18765(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="HEAD")})
    private void impl$capturePreTickTime(BooleanSupplier param0, CallbackInfo ci) {
        this.impl$preTickTime = class_156.method_648();
    }

    @Inject(method={"method_18765(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="RETURN")})
    private void impl$capturePostTickTime(BooleanSupplier param0, CallbackInfo ci) {
        long postTickTime = class_156.method_648();
        this.impl$recentTickTimes[this.shadow$method_8503().method_3780() % 100] = postTickTime - this.impl$preTickTime;
    }

    private void impl$setWorldOnBorder() {
        ((WorldBorderBridge)this.shadow$method_8621()).bridge$setAssociatedWorld(((ServerWorld)this).key());
    }

    @Inject(method={"method_8474(ILnet/minecraft/class_2338;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwBroadcastGlobalEvent(int effectID, class_2338 pos, int pitch, CallbackInfo ci) {
        if (!this.bridge$isFake() && ShouldFire.PLAY_SOUND_EVENT_BROADCAST) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getWorldInstance((class_3218)this).pushCauseFrame();){
                PlaySoundEvent.Broadcast event = SpongeCommonEventFactory.callPlaySoundBroadcastEvent(frame, this, pos, effectID);
                if (event != null && event.isCancelled()) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"method_8444(Lnet/minecraft/class_1657;ILnet/minecraft/class_2338;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwBroadcastEvent(class_1657 player, int eventID, class_2338 pos, int dataID, CallbackInfo ci) {
        if (eventID == 1010 && ShouldFire.PLAY_SOUND_EVENT_FROM_JUKEBOX) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
                class_2586 tileEntity = this.shadow$method_8321(pos);
                if (tileEntity instanceof class_2619) {
                    class_2619 jukebox = (class_2619)tileEntity;
                    class_1799 record = jukebox.method_5438(0);
                    frame.pushCause((Object)jukebox);
                    frame.addContext(EventContextKeys.USED_ITEM, (Object)ItemStackUtil.snapshotOf(record));
                    if (!record.method_7960()) {
                        Optional recordProperty = ((ItemStack)record).get(Keys.MUSIC_DISC);
                        if (!recordProperty.isPresent()) {
                            return;
                        }
                        MusicDisc recordType = (MusicDisc)recordProperty.get();
                        PlaySoundEvent.FromJukebox event = SpongeCommonEventFactory.callPlaySoundFromJukeboxEvent(frame.currentCause(), jukebox, recordType, dataID);
                        if (event.isCancelled()) {
                            ci.cancel();
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"method_32888(Lnet/minecraft/class_6880;Lnet/minecraft/class_243;Lnet/minecraft/class_5712$class_7397;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$ignoreGameEventsForVanishedEntities(class_6880<class_5712> $$0, class_243 $$1, class_5712.class_7397 $$2, CallbackInfo ci) {
        VanishableBridge bridge;
        class_1297 class_12972 = $$2.comp_713();
        if (class_12972 instanceof VanishableBridge && !(bridge = (VanishableBridge)class_12972).bridge$vanishState().triggerVibrations()) {
            ci.cancel();
        }
    }

    @Redirect(method={"method_19499(Lnet/minecraft/class_2338;Lnet/minecraft/class_6880;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_4153;method_19115(Lnet/minecraft/class_2338;Lnet/minecraft/class_6880;)V"))
    private void impl$avoidAddingPoiUpdatesOnUnloadedWorld(class_4153 manager, class_2338 pos, class_6880<class_4158> type) {
        if (!SpongeCommon.server().method_29435().contains(this.shadow$method_27983())) {
            return;
        }
        manager.method_19115(pos, type);
    }

    @Inject(method={"method_18765(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/class_3218;field_13948:I", opcode=181, shift=At.Shift.AFTER)})
    private void impl$unloadBlockEntities(BooleanSupplier param0, CallbackInfo ci) {
        if (this.field_13948 >= 300 && !this.field_27082.isEmpty()) {
            this.field_27082.removeIf(class_5562::method_31704);
        }
    }

    public String toString() {
        Optional<ResourceKey> worldTypeKey = Optional.ofNullable(this.field_13959.method_30611().method_30530(class_7924.field_41241).method_10221((Object)this.shadow$method_8597())).map(ResourceKey.class::cast);
        return new StringJoiner(",", class_3218.class.getSimpleName() + "[", "]").add("key=" + String.valueOf(this.shadow$method_27983())).add("worldType=" + worldTypeKey.map(ResourceKey::toString).orElse("inline")).toString();
    }

    @Redirect(method={"method_39501()V", "method_8474(ILnet/minecraft/class_2338;I)V", "method_8554(Lnet/minecraft/class_2338;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$broadcastAllCurrentDimensionOnly(class_3324 instance, class_2596<?> $$0) {
        instance.method_14589($$0, this.shadow$method_27983());
    }
}

