/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.minecraft.class_140;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2913;
import net.minecraft.class_2917;
import net.minecraft.class_3248;
import net.minecraft.class_3324;
import net.minecraft.class_3515;
import net.minecraft.class_4844;
import net.minecraft.class_5525;
import net.minecraft.class_8594;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ServerLoginPacketListenerImplBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.SpongeChannelAnswerPayload;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={class_3248.class})
public abstract class ServerLoginPacketListenerImplMixin
implements ServerLoginPacketListenerImplBridge {
    @Shadow
    @Final
    static Logger field_14166;
    @Shadow
    @Final
    class_2535 field_14158;
    @Shadow
    private GameProfile field_45029;
    @Shadow
    @Final
    MinecraftServer field_14162;
    @Shadow
    private class_3248.class_3249 field_14163;
    @Shadow
    @Final
    private byte[] field_14167;
    @Shadow
    @Nullable String field_45028;
    private static final ExecutorService impl$EXECUTOR;
    private static final int NEGOTIATION_NOT_STARTED = 0;
    private static final int NEGOTIATION_INTENT = 1;
    private static final int NEGOTIATION_HANDSHAKE = 2;
    private static final int INTENT_SYNC_PLUGIN_DATA = 0;
    private static final int INTENT_DONE = 1;
    private static final int HANDSHAKE_NOT_STARTED = 0;
    private static final int HANDSHAKE_CLIENT_TYPE = 1;
    private static final int HANDSHAKE_SYNC_CHANNEL_REGISTRATIONS = 2;
    private static final int HANDSHAKE_CHANNEL_REGISTRATION = 3;
    private static final int HANDSHAKE_SYNC_PLUGIN_DATA = 4;
    private static final int HANDSHAKE_DONE = 5;
    private volatile long impl$negotiationValue = ServerLoginPacketListenerImplMixin.impl$packNegotiationValue(0, 0);

    @Shadow
    public abstract void shadow$method_14380(class_2561 var1);

    @Shadow
    abstract void shadow$method_52417(GameProfile var1);

    @Override
    public class_2535 bridge$getConnection() {
        return this.field_14158;
    }

    @Redirect(method={"method_52419(Lcom/mojang/authlib/GameProfile;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14586(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/class_2561;"))
    private class_2561 impl$onCanPlayerLogin(class_3324 instance, SocketAddress $$0, GameProfile $$1) {
        return null;
    }

    private void impl$disconnectClient(Component disconnectMessage) {
        class_2561 reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.shadow$method_14380(reason);
    }

    @Inject(method={"method_52417(Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/class_3248;field_14163:Lnet/minecraft/class_3248$class_3249;")}, cancellable=true)
    private void impl$handleAuthEventCancellation(CallbackInfo ci) {
        ci.cancel();
        ServerSideConnection connection = (ServerSideConnection)((ConnectionBridge)this.field_14158).bridge$getEngineConnection();
        TransactionStore store = ConnectionUtil.getTransactionStore((EngineConnection)connection);
        if (store.isEmpty()) {
            this.impl$processVerification();
        } else {
            this.impl$changeNegotiationPhase(1, 0);
            this.field_14163 = class_3248.class_3249.field_14173;
        }
    }

    private void impl$processVerification() {
        ((CompletableFuture)((CompletableFuture)((PlayerListBridge)this.field_14162.method_3760()).bridge$canPlayerLogin(this.field_14158.method_10755(), this.field_45029).handle((componentOpt, throwable) -> {
            if (throwable != null) {
                ((ConnectionBridge)this.field_14158).bridge$setKickReason((class_2561)class_2561.method_43470((String)"An error occurred checking ban/whitelist status."));
                SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.field_45029.getId().toString());
                SpongeCommon.logger().error(throwable);
            } else if (componentOpt != null) {
                ((ConnectionBridge)this.field_14158).bridge$setKickReason((class_2561)componentOpt);
            }
            return null;
        })).handleAsync((ignored, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throw (CompletionException)throwable;
                }
                throw new CompletionException((Throwable)throwable);
            }
            this.impl$fireAuthEvent();
            return null;
        }, (Executor)impl$EXECUTOR)).exceptionally(throwable -> {
            SpongeCommon.logger().error("Forcibly disconnecting user {}({}) due to an error during login.", (Object)this.field_45029.getName(), (Object)this.field_45029.getId(), throwable);
            this.shadow$method_14380((class_2561)class_2561.method_43470((String)"Internal Server Error: unable to complete login."));
            return null;
        });
    }

    private void impl$fireAuthEvent() {
        @Nullable class_2561 kickReason = ((ConnectionBridge)this.field_14158).bridge$getKickReason();
        Object disconnectMessage = kickReason != null ? SpongeAdventure.asAdventure(kickReason) : Component.text((String)"You are not allowed to log in to this server.");
        SpongeEngineConnection connection = ((ConnectionBridge)this.field_14158).bridge$getEngineConnection();
        connection.setGameProfile(this.field_45029);
        Cause cause = Cause.of((EventContext)EventContext.empty(), (Object)this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth((Cause)cause, (Component)disconnectMessage, (Component)disconnectMessage, (ServerSideConnection)((ServerSideConnection)connection), (org.spongepowered.api.profile.GameProfile)SpongeGameProfile.of(this.field_45029));
        if (kickReason != null) {
            event.setCancelled(true);
        }
        if (connection.postGuardedEvent((ServerSideConnectionEvent)event)) {
            this.impl$disconnectClient(event.message());
            return;
        }
        this.impl$changeNegotiationPhase(2, 0);
        this.field_14163 = class_3248.class_3249.field_14173;
    }

    @Overwrite
    public void method_12642(class_2917 packet) {
        String $$5;
        Validate.validState((this.field_14163 == class_3248.class_3249.field_14175 ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey $$1 = this.field_14162.method_3716().getPrivate();
            if (!packet.method_43643(this.field_14167, $$1)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey $$2 = packet.method_12654($$1);
            Cipher $$3 = class_3515.method_15235((int)2, (Key)$$2);
            Cipher $$4 = class_3515.method_15235((int)1, (Key)$$2);
            $$5 = new BigInteger(class_3515.method_15240((String)"", (PublicKey)this.field_14162.method_3716().getPublic(), (SecretKey)$$2)).toString(16);
            this.field_14163 = class_3248.class_3249.field_14169;
            this.field_14158.method_10746($$3, $$4);
        }
        catch (class_5525 var7) {
            throw new IllegalStateException("Protocol error", var7);
        }
        impl$EXECUTOR.submit(() -> {
            String username = Objects.requireNonNull(this.field_45028, "Player name not initialized");
            try {
                ProfileResult $$1 = this.field_14162.method_3844().hasJoinedServer(username, $$5, this.impl$getAddress());
                if ($$1 != null) {
                    GameProfile $$2 = $$1.profile();
                    field_14166.info("UUID of player {} is {}", (Object)$$2.getName(), (Object)$$2.getId());
                    this.shadow$method_52417($$2);
                } else if (this.field_14162.method_3724()) {
                    field_14166.warn("Failed to verify username but will let them in anyway!");
                    this.shadow$method_52417(class_4844.method_54140((String)username));
                } else {
                    this.shadow$method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
                    field_14166.error("Username '{}' tried to join with an invalid session", (Object)username);
                }
            }
            catch (AuthenticationUnavailableException var4) {
                if (this.field_14162.method_3724()) {
                    field_14166.warn("Authentication servers are down but will let them in anyway!");
                    this.shadow$method_52417(class_4844.method_54140((String)username));
                }
                this.shadow$method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.authservers_down"));
                field_14166.error("Couldn't verify username because servers are unavailable");
            }
        });
    }

    private @Nullable InetAddress impl$getAddress() {
        SocketAddress $$0 = this.field_14158.method_10755();
        return this.field_14162.method_3775() && $$0 instanceof InetSocketAddress ? ((InetSocketAddress)$$0).getAddress() : null;
    }

    @Inject(method={"method_12640(Lnet/minecraft/class_2913;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onHandleCustomQueryPacket(class_2913 packet, CallbackInfo ci) {
        class_8594 payload = packet.comp_1570();
        int transactionId = packet.comp_1569();
        if (!(payload instanceof SpongeChannelAnswerPayload || payload == null && ((ConnectionBridge)this.field_14158).bridge$getTransactionStore().contains(transactionId))) {
            return;
        }
        ci.cancel();
        this.field_14162.execute(() -> {
            SpongeChannelManager channelRegistry = (SpongeChannelManager)Sponge.channelManager();
            SpongeEngineConnection connection = ((ConnectionBridge)this.field_14158).bridge$getEngineConnection();
            channelRegistry.handleLoginResponsePayload((EngineConnection)connection, (EngineConnectionState)this, transactionId, payload == null ? null : ((SpongeChannelAnswerPayload)payload).consumer());
        });
    }

    @Inject(method={"method_18784()V"}, at={@At(value="HEAD")})
    private void impl$onTick(CallbackInfo ci) {
        if (this.field_14163 == class_3248.class_3249.field_14173) {
            long value = this.impl$negotiationValue;
            int phase = ServerLoginPacketListenerImplMixin.impl$readNegotiationPhase(value);
            int state = ServerLoginPacketListenerImplMixin.impl$readNegotiationState(value);
            if (phase == 1) {
                this.impl$handleIntentNegotiation(state);
            } else if (phase == 2) {
                this.impl$handleHandshakeNegotiation(state);
            }
        }
    }

    private void impl$handleIntentNegotiation(int state) {
        ServerSideConnection connection;
        TransactionStore store;
        if (state == 0 && (store = ConnectionUtil.getTransactionStore((EngineConnection)(connection = (ServerSideConnection)((ConnectionBridge)this.field_14158).bridge$getEngineConnection()))).isEmpty()) {
            this.impl$changeNegotiationState(1);
            this.impl$processVerification();
        }
    }

    private void impl$handleHandshakeNegotiation(int state) {
        TransactionStore store;
        ServerSideConnection connection = (ServerSideConnection)((ConnectionBridge)this.field_14158).bridge$getEngineConnection();
        if (state == 0) {
            this.impl$changeNegotiationState(1);
            ((SpongeChannelManager)Sponge.channelManager()).requestClientType((EngineConnection)connection).thenAccept(result -> this.impl$changeNegotiationState(2));
        } else if (state == 2) {
            this.impl$changeNegotiationState(3);
            ((SpongeChannelManager)Sponge.channelManager()).sendLoginChannelRegistry((EngineConnection)connection).thenAccept(result -> {
                Cause cause = Cause.of((EventContext)EventContext.empty(), (Object)this);
                ServerSideConnectionEvent.Handshake event = SpongeEventFactory.createServerSideConnectionEventHandshake((Cause)cause, (ServerSideConnection)connection, (org.spongepowered.api.profile.GameProfile)SpongeGameProfile.of(this.field_45029));
                SpongeCommon.post((Event)event);
                this.impl$changeNegotiationState(4);
            });
        } else if (state == 4 && (store = ConnectionUtil.getTransactionStore((EngineConnection)connection)).isEmpty()) {
            this.impl$changeNegotiationState(5);
            this.field_14163 = class_3248.class_3249.field_45030;
        }
    }

    @Override
    public boolean bridge$isIntentDone() {
        int phase = ServerLoginPacketListenerImplMixin.impl$readNegotiationPhase(this.impl$negotiationValue);
        return phase > 1;
    }

    private void impl$changeNegotiationPhase(int phase, int state) {
        this.impl$negotiationValue = ServerLoginPacketListenerImplMixin.impl$packNegotiationValue(phase, state);
    }

    private void impl$changeNegotiationState(int state) {
        this.impl$changeNegotiationPhase(ServerLoginPacketListenerImplMixin.impl$readNegotiationPhase(this.impl$negotiationValue), state);
    }

    private static long impl$packNegotiationValue(int phase, int state) {
        return Integer.toUnsignedLong(phase) << 32 | Integer.toUnsignedLong(state);
    }

    private static int impl$readNegotiationPhase(long value) {
        return (int)(value >>> 32);
    }

    private static int impl$readNegotiationState(long value) {
        return (int)value;
    }

    static {
        impl$EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Sponge-LoginThread-%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(field_14166)).build());
    }
}

