/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.players;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import io.netty.channel.local.LocalAddress;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import net.minecraft.class_2703;
import net.minecraft.class_2780;
import net.minecraft.class_2784;
import net.minecraft.class_29;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3004;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3317;
import net.minecraft.class_3324;
import net.minecraft.class_3335;
import net.minecraft.class_3337;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5455;
import net.minecraft.class_7471;
import net.minecraft.class_7924;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.event.message.SystemMessageEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.client.server.IntegratedPlayerListBridge;
import org.spongepowered.common.bridge.data.TransientBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.bridge.world.level.storage.ServerLevelDataBridge;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.effect.BroadcastInventoryChangesEffect;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.server.PerWorldBorderListener;
import org.spongepowered.common.service.server.ban.SpongeIPBanList;
import org.spongepowered.common.service.server.ban.SpongeUserBanList;
import org.spongepowered.common.service.server.whitelist.SpongeUserWhiteList;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={class_3324.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    private static Logger field_14349;
    @Shadow
    @Final
    private static SimpleDateFormat field_14356;
    @Shadow
    @Final
    private MinecraftServer field_14360;
    @Shadow
    @Final
    @Mutable
    private class_3335 field_14344;
    @Shadow
    @Final
    @Mutable
    private class_3317 field_14345;
    @Shadow
    @Final
    @Mutable
    private class_3337 field_14361;
    @Shadow
    @Final
    private List<class_3222> field_14351;
    @Shadow
    @Final
    protected int field_14347;
    @Shadow
    @Final
    private Map<UUID, class_3222> field_14354;
    @Shadow
    @Final
    private class_29 field_14358;
    private boolean impl$isRespawnWithPosition = false;
    private boolean impl$isDuringSystemMessageEvent = false;

    @Shadow
    public abstract MinecraftServer shadow$method_14561();

    @Shadow
    public abstract Optional<class_2487> shadow$method_14600(class_3222 var1);

    @Shadow
    public abstract boolean shadow$method_14609(GameProfile var1);

    @Shadow
    protected abstract boolean shadow$method_44793(class_7471 var1);

    @Shadow
    protected abstract void shadow$method_44791(class_7471 var1, Predicate<class_3222> var2, @Nullable class_3222 var3, class_2556.class_7602 var4);

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_7780;Lnet/minecraft/class_29;I)V"}, at={@At(value="RETURN")})
    private void impl$setSpongeLists(CallbackInfo callbackInfo) {
        this.field_14344 = new SpongeUserBanList(class_3324.field_14355);
        this.field_14345 = new SpongeIPBanList(class_3324.field_14364);
        this.field_14361 = new SpongeUserWhiteList(class_3324.field_14343);
    }

    @Override
    public CompletableFuture<class_2561> bridge$canPlayerLogin(SocketAddress param0, GameProfile param1) {
        if (this instanceof IntegratedPlayerListBridge) {
            return ((IntegratedPlayerListBridge)((Object)this)).bridge$canPlayerLoginClient(param0, param1);
        }
        return this.impl$canPlayerLoginServer(param0, param1);
    }

    protected final CompletableFuture<class_2561> impl$canPlayerLoginServer(SocketAddress param0, GameProfile param1) {
        SpongeGameProfile profile = SpongeGameProfile.basicOf(param1);
        return ((CompletableFuture)Sponge.server().serviceProvider().banService().find((org.spongepowered.api.profile.GameProfile)profile).thenCompose(profileBanOpt -> {
            InetAddress address;
            if (profileBanOpt.isPresent()) {
                Ban.Profile var0 = (Ban.Profile)profileBanOpt.get();
                class_5250 var1 = class_2561.method_43469((String)"multiplayer.disconnect.banned.reason", (Object[])new Object[]{var0.reason().orElse(Component.empty())});
                if (var0.expirationDate().isPresent()) {
                    Date date = Date.from((Instant)var0.expirationDate().get());
                    var1.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.disconnect.banned.expiration", (Object[])new Object[]{field_14356.format(date)}));
                }
                return CompletableFuture.completedFuture(var1);
            }
            if (param0 instanceof LocalAddress) {
                return CompletableFuture.completedFuture(null);
            }
            try {
                address = InetAddress.getByName(NetworkUtil.getHostString(param0));
            }
            catch (UnknownHostException ex) {
                return CompletableFuture.completedFuture(class_2561.method_43470((String)ex.getMessage()));
            }
            return Sponge.server().serviceProvider().banService().find(address).thenCompose(ipBanOpt -> {
                if (ipBanOpt.isPresent()) {
                    Ban.IP var2 = (Ban.IP)ipBanOpt.get();
                    class_5250 var3 = class_2561.method_43469((String)"multiplayer.disconnect.banned_ip.reason", (Object[])new Object[]{var2.reason().orElse(Component.empty())});
                    if (var2.expirationDate().isPresent()) {
                        Date date = Date.from((Instant)var2.expirationDate().get());
                        var3.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.disconnect.banned_ip.expiration", (Object[])new Object[]{field_14356.format(date)}));
                    }
                    return CompletableFuture.completedFuture(var3);
                }
                return CompletableFuture.supplyAsync(() -> Sponge.server().isWhitelistEnabled(), (Executor)SpongeCommon.server()).thenCompose(whitelistEnabled -> {
                    if (!whitelistEnabled.booleanValue()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    PermissionService permissionService = Sponge.server().serviceProvider().permissionService();
                    return ((CompletableFuture)permissionService.userSubjects().loadSubject(param1.getId().toString()).handle((subject, ex) -> {
                        if (ex == null) {
                            return subject.hasPermission("minecraft.login.bypass-whitelist");
                        }
                        return permissionService.defaults().hasPermission("minecraft.login.bypass-whitelist");
                    })).thenCompose(whitelistBypass -> {
                        if (whitelistBypass.booleanValue()) {
                            return CompletableFuture.completedFuture(null);
                        }
                        return Sponge.server().serviceProvider().whitelistService().isWhitelisted((org.spongepowered.api.profile.GameProfile)profile).thenApply(whitelisted -> {
                            if (!whitelisted.booleanValue()) {
                                return class_2561.method_43471((String)"multiplayer.disconnect.not_whitelisted");
                            }
                            return null;
                        });
                    });
                });
            });
        })).thenApplyAsync(component -> {
            if (component != null) {
                return component;
            }
            if (this.field_14351.size() >= this.field_14347 && !this.shadow$method_14609(param1)) {
                return class_2561.method_43471((String)"multiplayer.disconnect.server_full");
            }
            return null;
        }, (Executor)SpongeCommon.server());
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14600(Lnet/minecraft/class_3222;)Ljava/util/Optional;"))
    private Optional<class_2487> impl$setPlayerDataForNewPlayers(class_3324 playerList, class_3222 playerIn) {
        Optional<class_2487> compound = this.shadow$method_14600(playerIn);
        if (compound.isEmpty()) {
            Instant now = Instant.now();
            ((ServerPlayer)playerIn).offer(Keys.FIRST_DATE_JOINED, (Object)now);
            ((ServerPlayer)playerIn).offer(Keys.LAST_DATE_JOINED, (Object)now);
        }
        return compound;
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3847(Lnet/minecraft/class_5321;)Lnet/minecraft/class_3218;"))
    private class_3218 impl$onInitPlayer_getWorld(MinecraftServer minecraftServer, class_5321<class_1937> dimension, class_2535 networkManager, class_3222 mcPlayer) {
        @Nullable class_2561 kickReason = ((ConnectionBridge)networkManager).bridge$getKickReason();
        Object disconnectMessage = kickReason != null ? SpongeAdventure.asAdventure(kickReason) : Component.text((String)"You are not allowed to log in to this server.");
        class_3218 mcWorld = minecraftServer.method_3847(dimension);
        if (mcWorld == null) {
            SpongeCommon.logger().warn("The player '{}' was located in a world that isn't loaded or doesn't exist. This is not safe so the player will be moved to the spawn of the default world.", (Object)mcPlayer.method_7334().getName());
            mcWorld = minecraftServer.method_30002();
            class_2338 spawnPoint = mcWorld.method_43126();
            mcPlayer.method_5814((double)spawnPoint.method_10263() + 0.5, (double)spawnPoint.method_10264() + 0.5, (double)spawnPoint.method_10260() + 0.5);
        }
        mcPlayer.method_51468(mcWorld);
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerLocation location = player.serverLocation();
        Vector3d rotation = player.rotation();
        ServerSideConnection connection = (ServerSideConnection)((ConnectionBridge)networkManager).bridge$getEngineConnection();
        User user = SpongeUserView.createLoginEventUser(player);
        Cause cause = Cause.of((EventContext)EventContext.empty(), (Object)connection, (Object[])new Object[]{user});
        ServerSideConnectionEvent.Login event = SpongeEventFactory.createServerSideConnectionEventLogin((Cause)cause, (Component)disconnectMessage, (Component)disconnectMessage, (ServerLocation)location, (ServerLocation)location, (Vector3d)rotation, (Vector3d)rotation, (ServerSideConnection)connection, (org.spongepowered.api.profile.GameProfile)SpongeGameProfile.of(mcPlayer.method_7334()), (User)user);
        if (kickReason != null) {
            event.setCancelled(true);
        }
        if (SpongeCommon.post((Event)event)) {
            this.impl$disconnectClient(networkManager, event.message(), player.profile());
            return null;
        }
        ServerLocation toLocation = event.toLocation();
        Vector3d toRotation = event.toRotation();
        mcPlayer.method_5641(toLocation.x(), toLocation.y(), toLocation.z(), (float)toRotation.y(), (float)toRotation.x());
        return (class_3218)toLocation.world();
    }

    @Inject(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3847(Lnet/minecraft/class_5321;)Lnet/minecraft/class_3218;", shift=At.Shift.AFTER)})
    private void impl$onInitPlayer_BeforeSetWorld(class_2535 $$0, class_3222 $$1, class_8792 $$2, CallbackInfo ci) {
        if (!$$0.method_10758()) {
            ci.cancel();
        }
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;info(Ljava/lang/String;[Ljava/lang/Object;)V", remap=false))
    private void impl$onInitPlayer_printPlayerWorldInJoinFeedback(Logger logger, String s, Object[] objects, class_2535 conn, class_3222 player) {
        logger.info("{}[{}] logged in to world '{}' with entity id {} at ({}, {}, {})", new Object[]{player.method_5477().getString(), player, ((ServerWorld)player.method_51469()).key(), player.method_5628(), player.method_23317(), player.method_23318(), player.method_23321()});
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3856()V"), to=@At(value="FIELD", opcode=178, target="Lnet/minecraft/class_124;field_1054:Lnet/minecraft/class_124;")), at=@At(value="INVOKE", remap=false, target="Ljava/lang/String;equalsIgnoreCase(Ljava/lang/String;)Z"))
    private boolean impl$onInitPlayer_dontClassSpongeNameAsModified(String currentName, String originalName) {
        if (originalName.equals("[sponge]")) {
            return true;
        }
        return currentName.equalsIgnoreCase(originalName);
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_43514(Lnet/minecraft/class_2561;Z)V"))
    private void impl$onInitPlayer_delaySendMessage(class_3324 instance, class_2561 message, boolean $$1, class_2535 manager, class_3222 playerIn) {
        ((ServerPlayerBridge)playerIn).bridge$setConnectionMessageToSend(message);
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/class_3324;field_14359:I"))
    private int impl$usePerWorldViewDistance(class_3324 self, class_2535 co, class_3222 player, class_8792 cookie) {
        return ((ServerLevelDataBridge)player.method_51469().method_8401()).bridge$viewDistance().orElse(self.method_14568());
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3837()Lnet/minecraft/class_3004;"))
    private class_3004 impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, class_2535 netManager, class_3222 playerIn) {
        return ((ServerLevelBridge)playerIn.method_51469()).bridge$getBossBarManager();
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14588(Lnet/minecraft/class_2995;Lnet/minecraft/class_3222;)V"))
    private void impl$sendScoreboard(class_3324 playerList, class_2995 scoreboardIn, class_3222 playerIn) {
        ((ServerPlayerBridge)playerIn).bridge$initScoreboard();
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_14581(Lnet/minecraft/class_2596;)V"))
    private void impl$onlySendSelfAddPlayerOnVanished(class_3324 playerList, class_2596<?> addPlayer, class_2535 playerConnection, class_3222 serverPlayer) {
        if (((VanishableBridge)serverPlayer).bridge$vanishState().invisible()) {
            serverPlayer.field_13987.method_14364(addPlayer);
            return;
        }
        playerList.method_14581(addPlayer);
    }

    @Redirect(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2703;method_43886(Ljava/util/Collection;)Lnet/minecraft/class_2703;", ordinal=0))
    private class_2703 impl$onlySendAddPlayerForUnvanishedPlayers(Collection<class_3222> $$0) {
        List<class_3222> vanishFiltered = $$0.stream().filter(p -> !((VanishableBridge)p).bridge$vanishState().invisible()).toList();
        return class_2703.method_43886(vanishFiltered);
    }

    @Inject(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at={@At(value="RETURN")})
    private void impl$onInitPlayer_join(class_2535 networkManager, class_3222 mcPlayer, class_8792 $$2, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerSideConnection connection = player.connection();
        Cause cause = Cause.of((EventContext)EventContext.empty(), (Object)connection, (Object[])new Object[]{player});
        Audience audience = Audiences.onlinePlayers();
        Component joinComponent = SpongeAdventure.asAdventure(((ServerPlayerBridge)mcPlayer).bridge$getConnectionMessageToSend());
        ServerSideConnectionEvent.Join event = SpongeEventFactory.createServerSideConnectionEventJoin((Cause)cause, (Audience)audience, Optional.of(audience), (Component)joinComponent, (Component)joinComponent, (ServerSideConnection)connection, (ServerPlayer)player, (org.spongepowered.api.profile.GameProfile)SpongeGameProfile.of(mcPlayer.method_7334()), (boolean)false);
        SpongeCommon.post((Event)event);
        if (!event.isMessageCancelled()) {
            event.audience().ifPresent(audience1 -> audience1.sendMessage(Identity.nil(), event.message()));
        }
        ((ServerPlayerBridge)mcPlayer).bridge$setConnectionMessageToSend(null);
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance(mcPlayer.method_51469());
        PhaseContext<?> context = phaseTracker.getPhaseContext();
        phaseTracker.pushCause(event);
        TransactionalCaptureSupplier transactor = context.getTransactor();
        transactor.logPlayerInventoryChange((class_1657)mcPlayer, PlayerInventoryTransaction.EventCreator.STANDARD);
        try (EffectTransactor ignored = BroadcastInventoryChangesEffect.transact(transactor);){
            mcPlayer.field_7498.method_7623();
        }
    }

    @Redirect(method={"method_14611(Lnet/minecraft/class_3222;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3837()Lnet/minecraft/class_3004;"))
    private class_3004 impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, class_3222 playerIn) {
        return ((ServerLevelBridge)playerIn.method_51469()).bridge$getBossBarManager();
    }

    @Inject(method={"method_14611(Lnet/minecraft/class_3222;)V"}, at={@At(value="HEAD")})
    private void impl$RemovePlayerReferenceFromScoreboard(class_3222 player, CallbackInfo ci) {
        ((ServerScoreboardBridge)((ServerPlayer)player).scoreboard()).bridge$removePlayer(player, false);
        SpongeAdventure.forEachBossBar(bar -> bar.method_14089(player));
        ((ServerPlayer)player).offer(Keys.LAST_DATE_PLAYED, (Object)Instant.now());
    }

    @Redirect(method={"method_14591(Lnet/minecraft/class_3218;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2784;method_11983(Lnet/minecraft/class_2780;)V"))
    private void impl$usePerWorldBorderListener(class_2784 worldBorder, class_2780 listener, class_3218 serverWorld) {
        worldBorder.method_11983((class_2780)new PerWorldBorderListener(serverWorld));
    }

    @Redirect(method={"method_14600(Lnet/minecraft/class_3222;)Ljava/util/Optional;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3222;method_5651(Lnet/minecraft/class_2487;)V"))
    private void impl$setSpongePlayerDataForSinglePlayer(class_3222 entity, class_2487 compound) {
        entity.method_5651(compound);
        if (((ServerPlayer)entity).get(Keys.FIRST_DATE_JOINED).isEmpty()) {
            ((SpongeServer)this.shadow$method_14561()).getPlayerDataManager().readLegacyPlayerData((ServerPlayer)entity, compound, null);
        }
        ((ServerPlayer)entity).offer(Keys.LAST_DATE_JOINED, (Object)Instant.now());
    }

    @Inject(method={"method_14556(Lnet/minecraft/class_3222;ZLnet/minecraft/class_1297$class_5529;)Lnet/minecraft/class_3222;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3222;method_60590(ZLnet/minecraft/class_5454$class_9823;)Lnet/minecraft/class_5454;")})
    private void impl$flagIfRespawnPositionIsGameMechanic(class_3222 $$0, boolean $$1, class_1297.class_5529 $$2, CallbackInfoReturnable<class_3222> cir) {
        this.impl$isRespawnWithPosition = $$0.method_26280() != null;
    }

    @Redirect(method={"method_14556(Lnet/minecraft/class_3222;ZLnet/minecraft/class_1297$class_5529;)Lnet/minecraft/class_3222;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3222;method_23317()D"), slice=@Slice(from=@At(value="NEW", target="(Lnet/minecraft/class_8589;B)Lnet/minecraft/class_2724;"), to=@At(value="NEW", target="(Lnet/minecraft/class_2338;F)Lnet/minecraft/class_2759;")))
    private double impl$callRespawnPlayerRecreateEvent(class_3222 newPlayer, class_3222 player, boolean keepAllPlayerData, @Local class_5454 dimensionTransition) {
        ServerPlayer originalPlayer = (ServerPlayer)player;
        ServerPlayer recreatedPlayer = (ServerPlayer)newPlayer;
        Vector3d originalPosition = originalPlayer.position();
        Vector3d destinationPosition = recreatedPlayer.position();
        ServerWorld originalWorld = originalPlayer.world();
        ServerWorld destinationWorld = recreatedPlayer.world();
        RespawnPlayerEvent.Recreate event = SpongeEventFactory.createRespawnPlayerEventRecreate((Cause)PhaseTracker.getInstance().currentCause(), (Vector3d)destinationPosition, (ServerWorld)originalWorld, (Vector3d)originalPosition, (ServerWorld)destinationWorld, (ServerWorld)((ServerWorld)dimensionTransition.comp_2820()), (Vector3d)destinationPosition, (ServerPlayer)originalPlayer, (ServerPlayer)recreatedPlayer, (boolean)this.impl$isRespawnWithPosition, (!keepAllPlayerData ? 1 : 0) != 0);
        SpongeCommon.post((Event)event);
        this.impl$isRespawnWithPosition = false;
        newPlayer.method_5814(event.destinationPosition().x(), event.destinationPosition().y(), event.destinationPosition().z());
        if (ShouldFire.ROTATE_ENTITY_EVENT) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
                frame.pushCause((Object)event);
                RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent((Cause)frame.currentCause(), (Entity)recreatedPlayer, (Vector3d)originalPlayer.rotation(), (Vector3d)recreatedPlayer.rotation());
                if (SpongeCommon.post((Event)rotateEvent)) {
                    newPlayer.method_36457(player.method_36455());
                    newPlayer.method_36456(player.method_36454());
                } else {
                    newPlayer.method_36457((float)rotateEvent.toRotation().x());
                    newPlayer.method_36456((float)rotateEvent.toRotation().y());
                }
            }
        }
        return newPlayer.method_23317();
    }

    @Inject(method={"method_14556(Lnet/minecraft/class_3222;ZLnet/minecraft/class_1297$class_5529;)Lnet/minecraft/class_3222;"}, at={@At(value="RETURN")})
    private void impl$callRespawnPlayerPostEvent(class_3222 player, boolean $$1, class_1297.class_5529 $$2, CallbackInfoReturnable<class_3222> cir, @Local class_5454 dimensionTransition) {
        ServerPlayer recreatedPlayer = (ServerPlayer)cir.getReturnValue();
        ServerWorld originalWorld = (ServerWorld)player.method_51469();
        RespawnPlayerEvent.Post event = SpongeEventFactory.createRespawnPlayerEventPost((Cause)PhaseTracker.getInstance().currentCause(), (ServerWorld)recreatedPlayer.world(), (ServerWorld)originalWorld, (ServerWorld)((ServerWorld)dimensionTransition.comp_2820()), (ServerPlayer)recreatedPlayer);
        SpongeCommon.post((Event)event);
    }

    @Redirect(method={"method_14606(Lnet/minecraft/class_3222;Lnet/minecraft/class_3218;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_30002()Lnet/minecraft/class_3218;"))
    private class_3218 impl$usePerWorldWorldBorder(MinecraftServer minecraftServer, class_3222 playerIn, class_3218 worldIn) {
        return worldIn;
    }

    private void impl$disconnectClient(class_2535 netManager, Component disconnectMessage, @Nullable org.spongepowered.api.profile.GameProfile profile) {
        class_2561 reason = SpongeAdventure.asVanilla(disconnectMessage);
        try {
            field_14349.info("Disconnecting " + (profile != null ? profile.toString() + " (" + netManager.method_10755().toString() + ")" : String.valueOf(netManager.method_10755()) + ": " + reason.getString()));
            netManager.method_10743((class_2596)new class_2661(reason));
            netManager.method_10747(reason);
        }
        catch (Exception exception) {
            field_14349.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    @Inject(method={"method_14617()V"}, at={@At(value="RETURN")})
    private void impl$saveDirtyUsersOnSaveAll(CallbackInfo ci) {
        ((SpongeServer)SpongeCommon.server()).userManager().saveDirtyUsers();
    }

    @Inject(method={"method_43512(Lnet/minecraft/class_2561;Ljava/util/function/Function;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onBroadcastSystemMessage(class_2561 $$0, Function<class_3222, class_2561> $$1, boolean $$2, CallbackInfo ci) {
        if (this.impl$isDuringSystemMessageEvent) {
            return;
        }
        ci.cancel();
        Audience originalAudience = (Audience)this.field_14360;
        Component originalMessage = SpongeAdventure.asAdventure($$0);
        SystemMessageEvent event = SpongeEventFactory.createSystemMessageEvent((Cause)PhaseTracker.getInstance().currentCause(), (Audience)originalAudience, Optional.of(originalAudience), (Component)originalMessage, (Component)originalMessage);
        if (SpongeCommon.post((Event)event)) {
            ci.cancel();
            return;
        }
        this.impl$isDuringSystemMessageEvent = true;
        event.audience().ifPresent(audience -> audience.sendMessage(event.message()));
        this.impl$isDuringSystemMessageEvent = false;
    }

    @Redirect(method={"method_43673(Lnet/minecraft/class_7471;Lnet/minecraft/class_3222;Lnet/minecraft/class_2556$class_7602;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_44791(Lnet/minecraft/class_7471;Ljava/util/function/Predicate;Lnet/minecraft/class_3222;Lnet/minecraft/class_2556$class_7602;)V"))
    private void impl$onBroadcastChatMessage1(class_3324 instance, class_7471 $$0, Predicate<class_3222> $$1, class_3222 $$2, class_2556.class_7602 $$4) {
        this.impl$onBroadcastChatMessage($$0, $$1, $$2, $$4);
    }

    @Redirect(method={"method_44166(Lnet/minecraft/class_7471;Lnet/minecraft/class_2168;Lnet/minecraft/class_2556$class_7602;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_44791(Lnet/minecraft/class_7471;Ljava/util/function/Predicate;Lnet/minecraft/class_3222;Lnet/minecraft/class_2556$class_7602;)V"))
    private void impl$onBroadcastChatMessage2(class_3324 instance, class_7471 $$0, Predicate<class_3222> $$1, class_3222 $$2, class_2556.class_7602 $$4) {
        this.impl$onBroadcastChatMessage($$0, $$1, $$2, $$4);
    }

    private void impl$onBroadcastChatMessage(class_7471 $$0, Predicate<class_3222> $$1, class_3222 $$2, class_2556.class_7602 $$4) {
        Predicate<class_3222> filter;
        class_2556.class_7602 boundChatType;
        boolean isTrusted = this.shadow$method_44793($$0);
        Component content = SpongeAdventure.asAdventure($$0.method_46291());
        Component sender = SpongeAdventure.asAdventure($$4.comp_920());
        Component target = $$4.comp_921() == null ? null : SpongeAdventure.asAdventure($$4.comp_921());
        class_2378 chatTypeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41237);
        DefaultedRegistryReference chatType = RegistryTypes.CHAT_TYPE.defaultReferenced((ResourceKey)chatTypeRegistry.method_10221((Object)((class_2556)$$4.comp_919().comp_349())));
        try (CauseStackManager.StackFrame frame = PhaseTracker.getServerInstanceExplicitly().pushCauseFrame();){
            PlayerChatEvent.Submit event;
            if ($$2 != null) {
                frame.pushCause((Object)$$2);
            }
            if (SpongeCommon.post((Event)(event = SpongeEventFactory.createPlayerChatEventSubmit((Cause)frame.currentCause(), (Component)content, (Component)content, (RegistryReference)chatType, Optional.empty(), Optional.ofNullable((ServerPlayer)$$2), (Component)sender, Optional.ofNullable(target), (boolean)isTrusted)))) {
                return;
            }
            boundChatType = class_2556.method_44834((class_5321)class_5321.method_29179((class_5321)class_7924.field_41237, (class_2960)((class_2960)event.chatType().location())), (class_5455)this.field_14360.method_30611(), (class_2561)SpongeAdventure.asVanilla(event.sender()));
            boundChatType = event.target().map(SpongeAdventure::asVanilla).map(arg_0 -> ((class_2556.class_7602)boundChatType).method_44839(arg_0)).orElse(boundChatType);
            filter = event.filter().map(f -> $$1.and((Predicate<class_3222>)f)).orElse($$1);
            if (event.message() != event.originalMessage()) {
                class_2561 customMessage = SpongeAdventure.asVanilla(event.message());
                class_7471 modifiedMessage = new class_7471($$0.comp_1083(), $$0.comp_1084(), $$0.comp_928(), customMessage, $$0.comp_981());
                this.shadow$method_44791(modifiedMessage, filter, $$2, boundChatType);
                return;
            }
        }
        this.shadow$method_44791($$0, filter, $$2, boundChatType);
    }

    @Inject(method={"method_14577(Lnet/minecraft/class_3222;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSave(class_3222 player, CallbackInfo ci) {
        if (((TransientBridge)player).bridge$isTransient()) {
            ci.cancel();
        }
    }

    @Redirect(method={"method_14611(Lnet/minecraft/class_3222;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1297;method_5817()Z"))
    private boolean impl$skipUnserializableRootVehicle(class_1297 instance) {
        return instance.method_5817() && instance.method_5864().method_5893();
    }
}

