/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1671;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.explosive.DetonateExplosiveEvent;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.ProjectileMixin;

@Mixin(value={class_1671.class})
public abstract class FireworkRocketEntityMixin
extends ProjectileMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int field_7613;
    @Shadow
    private int field_7612;
    private float impl$explosionRadius = 0.0f;

    @Override
    public boolean bridge$isPrimed() {
        return true;
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.field_7612;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.field_7612 = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.field_7612 - this.field_7613;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.field_7613 = 0;
        this.field_7612 = fuseTicks;
    }

    @Override
    public Optional<Float> bridge$getExplosionRadius() {
        return Optional.of(Float.valueOf(this.impl$explosionRadius));
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Float radius) {
        this.impl$explosionRadius = radius == null ? 0.0f : radius.floatValue();
    }

    @Redirect(method={"method_16830(Lnet/minecraft/class_3218;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_8421(Lnet/minecraft/class_1297;B)V"))
    private void impl$useSpongeExplosion(class_3218 world, class_1297 self, byte state) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)this);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (Object)this.impl$getProjectileSource());
            Explosion.Builder explosionBuilder = Explosion.builder().sourceExplosive((Explosive)((FireworkRocket)this)).location(((FireworkRocket)this).serverLocation()).radius(this.impl$explosionRadius);
            DetonateExplosiveEvent detonateEvent = SpongeEventFactory.createDetonateExplosiveEvent((Cause)PhaseTracker.getInstance().currentCause(), (Explosion.Builder)explosionBuilder, (Explosive)((FireworkRocket)this), (Explosion)explosionBuilder.build());
            if (Sponge.eventManager().post((Event)detonateEvent)) {
                return;
            }
            world.method_8421(self, state);
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="RETURN")})
    private void impl$postPrimeEvent(CallbackInfo ci) {
        if (this.field_7613 == 1 && !this.shadow$method_37908().field_9236) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
                frame.pushCause((Object)this);
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (Object)this.impl$getProjectileSource());
                this.bridge$postPrime();
            }
        }
    }
}

