/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.vehicle;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1701;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.vehicle.AbstractMinecartMixin;
import org.spongepowered.common.util.DamageEventUtil;

@Mixin(value={class_1701.class})
public abstract class MinecartTNTMixin
extends AbstractMinecartMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int field_7751;
    private @Nullable Float impl$explosionRadius = null;
    private int impl$fuseDuration = 80;
    private boolean impl$detonationCancelled;
    private @Nullable Object impl$primeCause;

    @Shadow
    public abstract boolean shadow$method_7578();

    @Shadow
    public abstract void shadow$method_7575();

    @Override
    public Optional<Float> bridge$getExplosionRadius() {
        return Optional.ofNullable(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Float radius) {
        this.impl$explosionRadius = radius;
    }

    @Override
    public boolean bridge$isPrimed() {
        return this.shadow$method_7578();
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.impl$fuseDuration;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        if (this.shadow$method_7578()) {
            this.field_7751 = Math.max(this.field_7751 + fuseTicks - this.impl$fuseDuration, 0);
        }
        this.impl$fuseDuration = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.field_7751;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.field_7751 = fuseTicks;
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="HEAD")})
    private void impl$onAttackSetPrimeCause(class_3218 level, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> ci) {
        this.impl$primeCause = damageSource;
    }

    @Inject(method={"method_7506(IIIZ)V"}, at={@At(value="HEAD")})
    private void impl$onActivateSetPrimeCauseNotifier(int x, int y, int z, boolean receivingPower, CallbackInfo ci) {
        if (((LevelBridge)this.shadow$method_37908()).bridge$isFake()) {
            return;
        }
        if (receivingPower) {
            ((ServerWorld)this.shadow$method_37908()).get(x, y, z, Keys.NOTIFIER).ifPresent(notifier -> {
                this.impl$primeCause = notifier;
            });
        }
    }

    @Inject(method={"method_7575()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$preIgnite(CallbackInfo ci) {
        if (!this.bridge$shouldPrime()) {
            this.bridge$setFuseTicksRemaining(-1);
            ci.cancel();
        }
    }

    @Inject(method={"method_7575()V"}, at={@At(value="RETURN")})
    private void impl$postIgnite(CallbackInfo ci) {
        this.bridge$setFuseTicksRemaining(this.impl$fuseDuration);
        if (this.impl$primeCause != null) {
            PhaseTracker.getInstance().pushCause(this.impl$primeCause);
        }
        this.bridge$postPrime();
        if (this.impl$primeCause != null) {
            PhaseTracker.getInstance().popCause();
        }
    }

    @Override
    public void bridge$cancelExplosion() {
        this.impl$detonationCancelled = true;
    }

    @Inject(method={"method_7576(Lnet/minecraft/class_1282;D)V"}, at={@At(value="RETURN")})
    private void impL$postExplode(CallbackInfo ci) {
        if (this.impl$detonationCancelled) {
            this.impl$detonationCancelled = false;
            this.shadow$method_31482();
        }
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/class_1701;method_7576(Lnet/minecraft/class_1282;D)V")})
    private void attackImpl$postOnAttackEntityFrom(class_3218 level, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (DamageEventUtil.callOtherAttackEvent((class_1297)this, source, amount).isCancelled()) {
            cir.setReturnValue((Object)true);
        }
    }
}

