/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1208;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1531;
import net.minecraft.class_1534;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1684;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2784;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3551;
import net.minecraft.class_3730;
import net.minecraft.class_5217;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5562;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.entity.MobAccessor;
import org.spongepowered.common.accessor.world.entity.item.FallingBlockEntityAccessor;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={class_1937.class})
public abstract class LevelMixin
implements LevelBridge,
class_1936 {
    @Mutable
    @Shadow
    @Final
    private class_6880<class_2874> field_36402;
    @Shadow
    protected float field_9253;
    @Shadow
    protected float field_9235;
    @Shadow
    protected float field_9251;
    @Shadow
    protected float field_9234;
    @Shadow
    @Final
    public class_5819 field_9229;
    @Shadow
    @Final
    protected class_5269 field_9232;
    @Shadow
    @Final
    protected List<class_5562> field_27082;

    @Shadow
    public abstract class_5217 shadow$method_8401();

    @Shadow
    public abstract void shadow$method_8533();

    @Shadow
    public abstract class_5321<class_1937> shadow$method_27983();

    @Shadow
    public abstract class_2874 shadow$method_8597();

    @Shadow
    public abstract class_2818 shadow$method_8500(class_2338 var1);

    @Shadow
    public abstract class_1266 shadow$method_8404(class_2338 var1);

    @Shadow
    public abstract boolean shadow$method_8419();

    @Shadow
    public abstract @Nullable class_2586 shadow$method_8321(class_2338 var1);

    @Shadow
    public abstract class_2784 shadow$method_8621();

    @Override
    public boolean bridge$isFake() {
        return this.method_8608();
    }

    @Override
    public void bridge$adjustDimensionLogic(class_2874 dimensionType) {
        this.field_36402 = class_6880.method_40223((Object)dimensionType);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public <E extends Entity> E bridge$createEntity(DataContainer dataContainer, @Nullable Vector3d position, @Nullable Predicate<Vector3d> positionCheck) throws IllegalArgumentException, IllegalStateException {
        @NonNull EntityType type = (EntityType)dataContainer.getRegistryValue(Constants.Entity.TYPE, (RegistryType)RegistryTypes.ENTITY_TYPE).orElseThrow(() -> new IllegalArgumentException("DataContainer does not contain a valid entity type."));
        Vector3d proposedPosition = position == null ? DataUtil.getPosition3d((DataView)dataContainer, Constants.Sponge.SNAPSHOT_WORLD_POSITION) : position;
        if (positionCheck != null && !positionCheck.test(proposedPosition)) {
            throw new IllegalArgumentException(String.format("Position (%.2f, %.2f, %.2f) is not a valid position in this context.", proposedPosition.x(), proposedPosition.y(), proposedPosition.z()));
        }
        Vector3d rotation = dataContainer.contains(Constants.Entity.ROTATION) ? DataUtil.getPosition3d((DataView)dataContainer, Constants.Entity.ROTATION) : null;
        Vector3d scale = dataContainer.contains(Constants.Entity.SCALE) ? DataUtil.getPosition3d((DataView)dataContainer, Constants.Entity.SCALE) : null;
        Object createdEntity = this.bridge$createEntity(type, position, false);
        dataContainer.getView(Constants.Sponge.UNSAFE_NBT).map(NBTTranslator.INSTANCE::translate).ifPresent(x -> {
            Dynamic dataFixed = class_3551.method_15450().update(class_1208.field_5729, new Dynamic((DynamicOps)class_2509.field_11560, x), 3692, 3833);
            @NonNull class_1297 e = (class_1297)createdEntity;
            dataFixed.remove("Dimension");
            e.method_5651((class_2487)dataFixed.getValue());
            e.method_24203(proposedPosition.x(), proposedPosition.y(), proposedPosition.z());
        });
        if (rotation != null) {
            createdEntity.setRotation(rotation);
        }
        if (scale != null) {
            createdEntity.setScale(scale);
        }
        return createdEntity;
    }

    @Override
    public <E extends Entity> E bridge$createEntity(EntityType<E> type, Vector3d position, boolean naturally) throws IllegalArgumentException, IllegalStateException {
        if (type == class_1299.field_6097) {
            throw new IllegalArgumentException("A Player cannot be created by the API!");
        }
        class_1297 entity = null;
        double x = position.x();
        double y = position.y();
        double z = position.z();
        class_1937 thisWorld = (class_1937)this;
        if (type == class_1299.field_6112) {
            entity = class_1299.field_6112.method_5883(thisWorld, class_3730.field_16467);
            entity.method_24203(x, y, z);
            ((class_1538)entity).method_29498(false);
        }
        if (type == class_1299.field_6082) {
            class_1531 tempEntity = new class_1531(thisWorld, x, y, z);
            tempEntity.method_5814(tempEntity.method_23317(), tempEntity.method_23318() - (double)tempEntity.method_5751(), tempEntity.method_23321());
            entity = new class_1684(thisWorld, (class_1309)tempEntity, class_1802.field_8634.method_7854());
            ((EnderPearl)entity).offer(Keys.SHOOTER, (Object)UnknownProjectileSource.UNKNOWN);
        }
        if (type == class_1299.field_6089) {
            entity = FallingBlockEntityAccessor.invoker$new(thisWorld, x, y, z, class_2246.field_10102.method_9564());
        }
        if (type == class_1299.field_6052) {
            entity = new class_1542(thisWorld, x, y, z, new class_1799((class_1935)class_2246.field_10340));
        }
        if (entity == null) {
            ResourceKey key = (ResourceKey)SpongeCommon.vanillaRegistry(class_7924.field_41266).method_10221((Object)((class_1299)type));
            try {
                entity = ((class_1299)type).method_5883(thisWorld, class_3730.field_16467);
                entity.method_24203(x, y, z);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an issue attempting to construct " + String.valueOf(key), e);
            }
        }
        if (entity instanceof class_1530 && !((class_1530)entity).method_6888()) {
            throw new IllegalArgumentException("Hanging entity does not survive at the given position: " + String.valueOf(position));
        }
        if (naturally && entity instanceof class_1308) {
            class_1266 difficulty = this.shadow$method_8404(new class_2338((int)x, (int)y, (int)z));
            ((MobAccessor)entity).invoker$populateDefaultEquipmentSlots(this.field_9229, difficulty);
        }
        if (entity instanceof class_1534) {
            // empty if block
        }
        return (E)((Entity)entity);
    }

    @Inject(method={"method_8333(Lnet/minecraft/class_1297;Lnet/minecraft/class_238;Ljava/util/function/Predicate;)Ljava/util/List;", "method_18023(Lnet/minecraft/class_5575;Lnet/minecraft/class_238;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="RETURN")})
    private void impl$IgnoreTargetingOfVanishedEntities(@Coerce Object entityIn, class_238 aabb, Predicate<?> filter, CallbackInfoReturnable<List<class_1297>> cir) {
        if (this.bridge$isFake()) {
            return;
        }
        List entities = (List)cir.getReturnValue();
        if (entities == null || entities.isEmpty()) {
            return;
        }
        entities.removeIf(entity -> {
            if (entity instanceof VanishableBridge) {
                VanishableBridge vb = (VanishableBridge)entity;
                VanishState state = vb.bridge$vanishState();
                return state.invisible() && state.untargetable();
            }
            return false;
        });
    }
}

