/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block;

import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2423;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5459;
import net.minecraft.class_7477;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.portal.PortalLogic;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.level.block.PortalBlockBridge;
import org.spongepowered.common.util.AxisUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.SpongePortal;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_2423.class})
public abstract class NetherPortalBlockMixin
implements PortalBlockBridge {
    @Override
    public Optional<ServerLocation> bridge$calculatePortalExit(ServerWorld from, Vector3i fromPos, Entity entity) {
        class_3218 fromLevel = (class_3218)from.world();
        class_5321 toLevelKey = fromLevel.method_27983() == class_1937.field_25180 ? class_1937.field_25179 : class_1937.field_25180;
        class_3218 toLevel = fromLevel.method_8503().method_3847(toLevelKey);
        if (toLevel == null) {
            return Optional.empty();
        }
        double scale = class_2874.method_31109((class_2874)fromLevel.method_8597(), (class_2874)toLevel.method_8597());
        class_2338 exitPosition = toLevel.method_8621().method_39538((double)fromPos.x() * scale, (double)fromPos.y(), (double)fromPos.z() * scale);
        return Optional.of(ServerLocation.of((ServerWorld)((ServerWorld)toLevel), (Vector3i)VecHelper.toVector3i(exitPosition)));
    }

    @Override
    public Optional<Portal> bridge$findPortal(ServerLocation at, int searchRange) {
        class_3218 level = (class_3218)at.world();
        class_2784 worldBorder = level.method_8621();
        class_2338 blockPos = VecHelper.toBlockPos(at.position());
        class_4153 poiManager = level.method_19494();
        int range = Math.clamp((long)searchRange, 1, 128);
        poiManager.method_22439((class_4538)level, blockPos, range);
        Optional<class_2338> foundPortalPos = poiManager.method_22383(poi -> poi.method_40225(class_7477.field_39295), blockPos, range, class_4153.class_4155.field_18489).map(class_4156::method_19141).filter(arg_0 -> ((class_2784)worldBorder).method_11952(arg_0)).filter(pos -> level.method_8320(pos).method_28498((class_2769)class_2741.field_12529)).min(Comparator.comparingDouble($$1x -> $$1x.method_10262((class_2382)blockPos)).thenComparingInt(class_2382::method_10264));
        return foundPortalPos.map(pos -> {
            class_2680 portalBlockState = level.method_8320(pos);
            class_2350.class_2351 axis = (class_2350.class_2351)portalBlockState.method_11654((class_2769)class_2741.field_12529);
            class_5459.class_5460 foundRectangle = class_5459.method_30574((class_2338)pos, (class_2350.class_2351)axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, pos2 -> level.method_8320(pos2) == portalBlockState);
            return new SpongePortal((ServerLocation)((ServerWorld)at.world()).location(VecHelper.toVector3i(pos)), (PortalLogic)this, NetherPortalBlockMixin.impl$portalAABB(foundRectangle, axis));
        });
    }

    private static AABB impl$portalAABB(class_5459.class_5460 portal, class_2350.class_2351 axis) {
        Vector3i minCorner = VecHelper.toVector3i(portal.field_25936);
        if (axis == class_2350.class_2351.field_11048) {
            return AABB.of((Vector3i)minCorner, (Vector3i)minCorner.add(portal.field_25937, portal.field_25938, 1));
        }
        return AABB.of((Vector3i)minCorner, (Vector3i)minCorner.add(1, portal.field_25938, portal.field_25937));
    }

    @Override
    public Optional<Portal> bridge$generatePortal(ServerLocation at, Axis axis) {
        class_3218 level = (class_3218)at.world();
        class_2338 blockPos = VecHelper.toBlockPos(at.position());
        Optional portal = level.method_14173().method_30482(blockPos, AxisUtil.getFor(axis));
        return portal.map(p -> new SpongePortal(at, (PortalLogic)this, NetherPortalBlockMixin.impl$portalAABB(p, AxisUtil.getFor(axis))));
    }

    @Override
    public boolean bridge$teleport(Entity entity, ServerLocation destination, boolean generateDestinationPortal) {
        class_3218 toLevel = (class_3218)destination.world();
        boolean toSmallerScaleLevel = toLevel.method_27983() == class_1937.field_25180;
        Optional<Portal> found = this.bridge$findPortal(destination, toSmallerScaleLevel ? 16 : 128);
        Optional<ServerLocation> portalDestination = found.map(Portal::position);
        if (portalDestination.isPresent()) {
            entity.setLocation(portalDestination.get());
            return true;
        }
        if (!generateDestinationPortal) {
            return false;
        }
        Axis axis = AxisUtil.getFor(class_2350.class_2351.field_11048);
        Optional<Portal> generated = this.bridge$generatePortal(destination, axis);
        portalDestination = generated.map(Portal::position);
        if (portalDestination.isPresent()) {
            entity.setLocation(portalDestination.get());
            return true;
        }
        return false;
    }
}

