/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.border;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2784;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.ChangeWorldBorderEvent;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.world.border.SpongeWorldBorderBuilder;

@Mixin(value={class_2784.class})
public abstract class WorldBorderMixin
implements WorldBorderBridge {
    private ResourceKey impl$associatedWorld;
    private boolean impl$fireEvent = true;

    @Override
    public void bridge$setAssociatedWorld(ResourceKey associatedWorld) {
        this.impl$associatedWorld = associatedWorld;
    }

    @Inject(method={"method_11978(DD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetCenter(double x, double z, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).center(x, z).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"method_11969(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetSize(double size, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).initialDiameter(size).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"method_11957(DDJ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onLerping(double initial, double target, long milliseconds, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).initialDiameter(initial).targetDiameter(target).timeToTargetDiameter(Duration.ofMillis(milliseconds)).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"method_11967(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetWarningBlocks(int distance, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).warningDistance((double)distance).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"method_11981(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetDamageSafeZone(double size, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).safeZone(size).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"method_11955(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetDamagePerBlock(double damagePerBlock, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).damagePerBlock(damagePerBlock).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"method_11975(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetWarningTime(int warningTime, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).warningTime(Duration.ofSeconds(warningTime)).build())) {
            ci.cancel();
        }
    }

    private boolean impl$suppressOriginalAction(Supplier<WorldBorder> proposed) {
        ChangeWorldBorderEvent.World result = this.impl$fireWorldBorderEvent(proposed);
        return result != null && (result.isCancelled() || result.originalNewBorder().orElse(null) != result.newBorder().orElse(null));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ChangeWorldBorderEvent.World impl$fireWorldBorderEvent(Supplier<WorldBorder> supplier) {
        Optional world;
        if (this.impl$associatedWorld != null && SpongeCommon.game().isServerAvailable() && (world = Sponge.server().worldManager().world(this.impl$associatedWorld)).isPresent()) {
            WorldBorder toSet;
            WorldBorder originalNewBorder = supplier.get();
            ChangeWorldBorderEvent.World event = SpongeEventFactory.createChangeWorldBorderEventWorld((Cause)PhaseTracker.getInstance().currentCause(), Optional.of(originalNewBorder), Optional.of(originalNewBorder), Optional.of(this.bridge$asImmutable()), (ServerWorld)((ServerWorld)world.get()));
            boolean isCancelled = Sponge.eventManager().post((Event)event);
            if (!isCancelled && originalNewBorder != (toSet = event.newBorder().orElse((WorldBorder)class_2784.field_24122))) {
                this.impl$fireEvent = false;
                this.bridge$applyFrom(toSet);
                this.impl$fireEvent = true;
            }
            return event;
        }
        return null;
    }

    @Override
    public WorldBorder bridge$asImmutable() {
        return (WorldBorder)((class_2784)this).method_27355();
    }

    @Override
    public @Nullable WorldBorder bridge$applyFrom(WorldBorder worldBorder) {
        WorldBorder toSet;
        if (!this.impl$fireEvent) {
            ((class_2784)this).method_17905((class_2784.class_5200)worldBorder);
            return worldBorder;
        }
        ChangeWorldBorderEvent.World event = this.impl$fireWorldBorderEvent(() -> worldBorder);
        if (event != null) {
            if (event.isCancelled()) {
                return this.bridge$asImmutable();
            }
            WorldBorder defaultSettings = (WorldBorder)class_2784.field_24122;
            toSet = event.newBorder().orElse(defaultSettings);
        } else {
            toSet = worldBorder;
        }
        this.impl$fireEvent = false;
        ((class_2784)this).method_17905((class_2784.class_5200)toSet);
        this.impl$fireEvent = true;
        return toSet;
    }
}

