/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_3215;
import net.minecraft.class_5217;
import net.minecraft.class_5539;
import net.minecraft.class_6749;
import net.minecraft.class_6755;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.chunk.BlockChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.DataHolderProcessor;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.CacheKeyBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DirectionUtil;

@Mixin(value={class_2818.class})
public abstract class LevelChunkMixin
extends class_2791
implements LevelChunkBridge,
CacheKeyBridge,
SpongeMutableDataHolder,
SpongeDataHolderBridge,
DataCompoundHolder,
BlockChunk {
    @Shadow
    @Final
    private class_1937 field_12858;
    @Shadow
    private boolean field_12855;
    private long impl$scheduledForUnload = -1L;
    private boolean impl$persistedChunk = false;
    private boolean impl$isSpawning = false;
    private final class_2818[] impl$neighbors = new class_2818[4];
    private long impl$cacheKey;
    private Map<Integer, PlayerTracker> impl$trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> impl$trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();
    private @Nullable class_2487 impl$compound;

    @Shadow
    public abstract @Nullable class_2586 shadow$method_12201(class_2338 var1, class_2818.class_2819 var2);

    @Shadow
    public abstract class_2680 shadow$method_8320(class_2338 var1);

    @Shadow
    public abstract void shadow$method_12002(class_1297 var1);

    @Shadow
    public abstract void shadow$method_65063();

    public LevelChunkMixin(class_1923 $$0, class_2843 $$1, class_5539 $$2, class_2378<class_1959> $$3, long $$4, class_2826[] $$5, class_6749 $$6) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6);
    }

    @Inject(method={"<init>(Lnet/minecraft/class_1937;Lnet/minecraft/class_1923;Lnet/minecraft/class_2843;Lnet/minecraft/class_6755;Lnet/minecraft/class_6755;J[Lnet/minecraft/class_2826;Lnet/minecraft/class_2818$class_6829;Lnet/minecraft/class_6749;)V"}, at={@At(value="RETURN")})
    private void impl$onConstruct(class_1937 $$0, class_1923 $$1, class_2843 $$2, class_6755 $$3, class_6755 $$4, long $$5, class_2826[] $$6, class_2818.class_6829 $$7, class_6749 $$8, CallbackInfo ci) {
        this.impl$cacheKey = class_1923.method_8331((int)$$1.field_9181, (int)$$1.field_9180);
    }

    @Override
    public class_2818[] bridge$getNeighborArray() {
        return Arrays.copyOf(this.impl$neighbors, this.impl$neighbors.length);
    }

    @Override
    public void bridge$markChunkDirty() {
        this.shadow$method_65063();
    }

    @Override
    public boolean bridge$isQueuedForUnload() {
        return ((ChunkMapAccessor)((class_3215)this.field_12858.method_8398()).field_17254).accessor$pendingUnloads().containsKey(this.field_34538.method_8324());
    }

    @Override
    public boolean bridge$isPersistedChunk() {
        return this.impl$persistedChunk;
    }

    @Override
    public boolean bridge$isSpawning() {
        return this.impl$isSpawning;
    }

    @Override
    public void bridge$setIsSpawning(boolean spawning) {
        this.impl$isSpawning = spawning;
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return this.impl$trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return this.impl$trackedShortBlockPositions;
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.impl$trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.impl$trackedShortBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$addTrackedBlockPosition(class_2248 block, class_2338 pos, UUID uuid, PlayerTracker.Type trackerType) {
        if (((LevelBridge)this.field_12858).bridge$isFake()) {
            return;
        }
        if (!PhaseTracker.getInstance().getPhaseContext().tracksCreatorsAndNotifiers()) {
            return;
        }
        class_2586 blockEntity = (class_2586)this.field_34543.get(pos);
        if (blockEntity != null && blockEntity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge trackedBlockEntity = (CreatorTrackedBridge)blockEntity;
            if (trackerType == PlayerTracker.Type.NOTIFIER) {
                if (Objects.equals(trackedBlockEntity.tracker$getNotifierUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.NOTIFIER, uuid);
            } else {
                if (Objects.equals(trackedBlockEntity.tracker$getCreatorUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, uuid);
            }
        }
        if (trackerType == PlayerTracker.Type.CREATOR) {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.creatorindex = idx;
                pt.notifierIndex = idx;
            });
        } else {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.notifierIndex = idx;
            });
        }
    }

    public Optional<UUID> bridge$trackedUUID(class_2338 pos, Function<PlayerTracker, Integer> func) {
        if (((LevelBridge)this.field_12858).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.impl$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            int ownerIndex = func.apply(intTracker);
            return this.impl$getValidatedUUID(key, ownerIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.impl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int ownerIndex = func.apply(shortTracker);
            return this.impl$getValidatedUUID(shortKey, ownerIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockCreatorUUID(class_2338 pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.creatorindex);
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(class_2338 pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.notifierIndex);
    }

    private <T> void impl$computePlayerTracker(Map<T, PlayerTracker> map, T blockPos, int index, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        PlayerTracker tracker = map.get(blockPos);
        if (tracker != null) {
            consumer.accept(tracker, index);
        } else {
            map.put(blockPos, new PlayerTracker(index, type));
        }
    }

    private void impl$setTrackedUUID(class_2338 pos, UUID uuid, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        int index;
        if (((LevelBridge)this.field_12858).bridge$isFake()) {
            return;
        }
        class_5217 class_52172 = this.field_12858.method_8401();
        if (!(class_52172 instanceof PrimaryLevelDataBridge)) {
            return;
        }
        PrimaryLevelDataBridge levelData = (PrimaryLevelDataBridge)class_52172;
        int n = index = uuid == null ? -1 : levelData.bridge$getIndexForUniqueId(uuid);
        if (pos.method_10264() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            this.impl$computePlayerTracker(this.impl$trackedShortBlockPositions, blockPos, index, type, consumer);
            return;
        }
        int blockPos = Constants.Sponge.blockPosToInt(pos);
        this.impl$computePlayerTracker(this.impl$trackedIntBlockPositions, blockPos, index, type, consumer);
    }

    @Override
    public void bridge$setBlockNotifier(class_2338 pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.NOTIFIER, (pt, idx) -> {
            pt.notifierIndex = idx;
        });
    }

    @Override
    public void bridge$setBlockCreator(class_2338 pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.CREATOR, (pt, idx) -> {
            pt.creatorindex = idx;
        });
    }

    private Optional<UUID> impl$getValidatedUUID(int key, int ownerIndex) {
        PrimaryLevelDataBridge worldInfo = (PrimaryLevelDataBridge)this.field_12858.method_8401();
        UUID uuid = worldInfo.bridge$getUniqueIdForIndex(ownerIndex).orElse(null);
        if (uuid != null) {
            if (SpongeConfigs.getCommon().get().world.invalidLookupUuids.contains(uuid)) {
                if (key <= Short.MAX_VALUE) {
                    this.impl$trackedShortBlockPositions.remove((short)key);
                }
                this.impl$trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    @Override
    public void bridge$setNeighborChunk(int index, @Nullable class_2818 chunk) {
        this.impl$neighbors[index] = chunk;
    }

    @Override
    public @Nullable class_2818 bridge$getNeighborChunk(int index) {
        return this.impl$neighbors[index];
    }

    @Override
    public List<class_2818> bridge$getNeighbors() {
        ArrayList<class_2818> neighborList = new ArrayList<class_2818>();
        for (class_2818 neighbor : this.impl$neighbors) {
            if (neighbor == null) continue;
            neighborList.add(neighbor);
        }
        return neighborList;
    }

    @Override
    public boolean bridge$areNeighborsLoaded() {
        for (int i = 0; i < 4; ++i) {
            if (this.impl$neighbors[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void bridge$setNeighbor(Direction direction, @Nullable class_2818 neighbor) {
        this.impl$neighbors[DirectionUtil.directionToIndex((Direction)direction)] = neighbor;
    }

    @Override
    public long bridge$getScheduledForUnload() {
        return this.impl$scheduledForUnload;
    }

    @Override
    public void bridge$setScheduledForUnload(long scheduled) {
        this.impl$scheduledForUnload = scheduled;
    }

    @Override
    public boolean bridge$isActive() {
        if (this.bridge$isPersistedChunk()) {
            return true;
        }
        return this.field_12855 && !this.bridge$isQueuedForUnload() && this.bridge$getScheduledForUnload() == -1L;
    }

    public String toString() {
        return new StringJoiner(", ", LevelChunkMixin.class.getSimpleName() + "[", "]").add("World=" + String.valueOf(this.field_12858)).add("Position=" + this.field_34538.field_9181 + ":" + this.field_34538.field_9180).add("super=" + super.toString()).toString();
    }

    @Override
    public long bridge$getCacheKey() {
        return this.impl$cacheKey;
    }

    @Override
    public boolean bridge$spawnEntity(Entity entity) {
        class_1297 mcEntity = (class_1297)entity;
        class_2338 blockPos = mcEntity.method_24515();
        if (this.field_34538.field_9181 == blockPos.method_10263() >> 4 && this.field_34538.field_9180 == blockPos.method_10260() >> 4) {
            this.field_12858.method_8649(mcEntity);
            return true;
        }
        return false;
    }

    @Override
    public class_2487 data$getCompound() {
        return this.impl$compound;
    }

    @Override
    public void data$setCompound(class_2487 nbt) {
        this.impl$compound = nbt;
    }

    @Override
    public <E> DataTransactionResult bridge$offer(Key<@NonNull ? extends Value<E>> key, E value) {
        DataTransactionResult result = DataHolderProcessor.bridge$offer(this, key, value);
        this.shadow$method_65063();
        return result;
    }

    @Override
    public <E> DataTransactionResult bridge$remove(Key<@NonNull ? extends Value<E>> key) {
        DataTransactionResult result = DataHolderProcessor.bridge$remove(this, key);
        this.shadow$method_65063();
        return result;
    }
}

