/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1267;
import net.minecraft.class_1934;
import net.minecraft.class_1940;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2632;
import net.minecraft.class_2874;
import net.minecraft.class_31;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5363;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.level.LevelSettingsAccessor;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.fixer.LegacyUUIDCodec;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeServerLevelData;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_31.class})
public abstract class PrimaryLevelDataMixin
implements class_5268,
class_5219,
PrimaryLevelDataBridge,
DataCompoundHolder {
    @Shadow
    private class_1940 field_25030;
    @Shadow
    private class_2338 field_48380;
    @Shadow
    private float field_26367;
    private final SpongeServerLevelData impl$spongeData = new SpongeServerLevelData();
    private class_2874 impl$dimensionType;
    private @Nullable SerializationBehavior impl$serializationBehavior;
    private @Nullable Component impl$displayName;
    private @Nullable Integer impl$viewDistance;
    private Boolean impl$pvp;
    private final BiMap<Integer, UUID> impl$playerUniqueIdMap = HashBiMap.create();
    private boolean impl$customDifficulty = false;
    private boolean impl$customGameType = false;
    private boolean impl$customSpawnPosition = false;
    private boolean impl$loadOnStartup;
    private boolean impl$performsSpawnLogic;
    private BiMap<Integer, UUID> impl$mapUUIDIndex = HashBiMap.create();
    private @Nullable class_2487 impl$compound;

    @Shadow
    public abstract boolean shadow$method_197();

    @Shadow
    public abstract void shadow$method_187(class_2338 var1, float var2);

    @Override
    public SpongeServerLevelData bridge$spongeData() {
        return this.impl$spongeData;
    }

    @Override
    public class_2874 bridge$dimensionType() {
        return this.impl$dimensionType;
    }

    @Override
    public void bridge$dimensionType(class_2874 type, boolean updatePlayers) {
        this.impl$dimensionType = type;
    }

    @Override
    public boolean bridge$customDifficulty() {
        return this.impl$customDifficulty;
    }

    @Override
    public boolean bridge$customGameType() {
        return this.impl$customGameType;
    }

    @Override
    public boolean bridge$customSpawnPosition() {
        return this.impl$customSpawnPosition;
    }

    @Override
    public void bridge$forceSetDifficulty(class_1267 difficulty) {
        this.impl$customDifficulty = true;
        this.field_25030 = this.field_25030.method_28381(difficulty);
        class_3218 level = this.bridge$level();
        if (level != null) {
            this.impl$updateWorldForDifficultyChange(level, this.shadow$method_197());
        }
    }

    @Override
    public Optional<Boolean> bridge$pvp() {
        return Optional.ofNullable(this.impl$pvp);
    }

    @Override
    public void bridge$setPvp(@Nullable Boolean pvp) {
        this.impl$pvp = pvp;
    }

    @Override
    public boolean bridge$performsSpawnLogic() {
        return this.impl$performsSpawnLogic;
    }

    @Override
    public void bridge$setPerformsSpawnLogic(boolean performsSpawnLogic) {
        this.impl$performsSpawnLogic = performsSpawnLogic;
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.impl$loadOnStartup;
    }

    @Override
    public void bridge$setLoadOnStartup(boolean loadOnStartup) {
        this.impl$loadOnStartup = loadOnStartup;
    }

    @Override
    public Optional<SerializationBehavior> bridge$serializationBehavior() {
        return Optional.ofNullable(this.impl$serializationBehavior);
    }

    @Override
    public void bridge$setSerializationBehavior(@Nullable SerializationBehavior behavior) {
        this.impl$serializationBehavior = behavior;
    }

    @Override
    public Optional<Component> bridge$displayName() {
        return Optional.ofNullable(this.impl$displayName);
    }

    @Override
    public void bridge$setDisplayName(@Nullable Component displayName) {
        this.impl$displayName = displayName;
    }

    @Override
    public Optional<Integer> bridge$viewDistance() {
        return Optional.ofNullable(this.impl$viewDistance);
    }

    @Override
    public void bridge$setViewDistance(@Nullable Integer viewDistance) {
        this.impl$viewDistance = viewDistance;
        this.bridge$triggerViewDistanceLogic();
    }

    @Override
    public void bridge$populateFromLevelStem(class_5363 dimension) {
        LevelStemBridge bridge = (LevelStemBridge)dimension;
        this.impl$dimensionType = (class_2874)dimension.comp_1012().comp_349();
        this.impl$displayName = bridge.bridge$displayName();
        class_1267 difficulty = bridge.bridge$difficulty();
        class_1934 gameType = bridge.bridge$gameMode();
        Boolean isHardcore = bridge.bridge$hardcore();
        Boolean allowCommands = bridge.bridge$allowCommands();
        if (difficulty != null) {
            this.impl$customDifficulty = true;
        }
        if (gameType != null) {
            this.impl$customGameType = true;
        }
        this.field_25030 = new class_1940(this.field_25030.method_27339(), gameType == null ? this.field_25030.method_8574() : gameType, isHardcore == null ? this.field_25030.method_8583() : isHardcore.booleanValue(), difficulty == null ? this.field_25030.method_27340() : difficulty, allowCommands == null ? this.field_25030.method_8582() : allowCommands.booleanValue(), this.field_25030.method_27341(), this.field_25030.method_29558());
        Vector3i spawnPos = bridge.bridge$spawnPosition();
        if (spawnPos != null) {
            this.shadow$method_187(VecHelper.toBlockPos(spawnPos), this.field_26367);
            this.impl$customSpawnPosition = true;
        }
        this.impl$serializationBehavior = bridge.bridge$serializationBehavior();
        this.impl$pvp = bridge.bridge$pvp();
        this.impl$loadOnStartup = bridge.bridge$loadOnStartup();
        this.impl$performsSpawnLogic = bridge.bridge$performsSpawnLogic();
        this.impl$viewDistance = bridge.bridge$viewDistance();
    }

    @Override
    public BiMap<Integer, UUID> bridge$getMapUUIDIndex() {
        return this.impl$mapUUIDIndex;
    }

    @Override
    public int bridge$getIndexForUniqueId(UUID uuid) {
        Integer index = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)uuid);
        if (index != null) {
            return index;
        }
        int newIndex = this.impl$playerUniqueIdMap.size();
        this.impl$playerUniqueIdMap.put((Object)newIndex, (Object)uuid);
        return newIndex;
    }

    @Override
    public Optional<UUID> bridge$getUniqueIdForIndex(int index) {
        return Optional.ofNullable((UUID)this.impl$playerUniqueIdMap.get((Object)index));
    }

    void impl$updateWorldForDifficultyChange(class_3218 level, boolean isLocked) {
        MinecraftServer server = level.method_8503();
        class_1267 difficulty = this.method_207();
        if (difficulty == class_1267.field_5807) {
            level.method_8424(true);
        } else if (server.method_3724()) {
            level.method_8424(difficulty != class_1267.field_5801);
        } else {
            level.method_8424(((MinecraftServerAccessor)server).invoker$isSpawningMonsters());
        }
        level.method_18456().forEach(player -> player.field_13987.method_14364((class_2596)new class_2632(difficulty, isLocked)));
    }

    @Override
    public void bridge$hardcore(boolean hardcore) {
        ((LevelSettingsAccessor)this.field_25030).accessor$hardcore(hardcore);
    }

    @Override
    public void bridge$allowCommands(boolean allowCommands) {
        ((LevelSettingsAccessor)this.field_25030).accessor$allowCommands(allowCommands);
    }

    @Override
    public void bridge$readSpongeLevelData(Dynamic<class_2520> dynamic) {
        dynamic.get("SpongeData").get().ifSuccess(v2 -> {
            v2.get("UUID").read((Decoder)class_4844.field_25122).result().ifPresent(this.impl$spongeData::setUniqueId);
            v2.get("MapUUIDs").readMap((Decoder)Codec.STRING, (Decoder)class_4844.field_25122).result().ifPresent(value -> {
                HashBiMap mapIndex = HashBiMap.create();
                for (Pair pair : value) {
                    int id = Integer.parseInt((String)pair.getFirst());
                    mapIndex.put((Object)id, (Object)((UUID)pair.getSecond()));
                }
                this.impl$mapUUIDIndex = mapIndex;
            });
            v2.get("PlayerIdTable").readList(LegacyUUIDCodec.CODEC).result().orElseGet(() -> v2.get("player-uuid-table").readList((Decoder)class_4844.field_25122).result().orElse(Collections.emptyList())).forEach(uuid -> this.impl$playerUniqueIdMap.inverse().putIfAbsent(uuid, (Object)this.impl$playerUniqueIdMap.size()));
        });
        this.data$setCompound((class_2487)dynamic.getValue());
        DataUtil.syncTagToData(this);
        this.data$setCompound(null);
    }

    @Override
    public class_2487 bridge$writeSpongeLevelData() {
        class_2487 data = new class_2487();
        data.method_25927("UUID", this.impl$spongeData.uniqueId());
        class_2487 mapUUIDIndexTag = new class_2487();
        MapUtil.saveMapUUIDIndex(mapUUIDIndexTag, this.impl$mapUUIDIndex);
        data.method_10566("MapUUIDs", (class_2520)mapUUIDIndexTag);
        class_2499 playerIdList = new class_2499();
        data.method_10566("player-uuid-table", (class_2520)playerIdList);
        this.impl$playerUniqueIdMap.values().forEach(uuid -> playerIdList.add((Object)new class_2495(class_4844.method_26275((UUID)uuid))));
        return data;
    }

    public String toString() {
        return new StringJoiner(", ", class_31.class.getSimpleName() + "[", "]").add("key=" + String.valueOf(this.impl$spongeData.key())).add("worldType=" + String.valueOf(this.impl$dimensionType)).add("uniqueId=" + String.valueOf(this.impl$spongeData.uniqueId())).add("spawn=" + String.valueOf(VecHelper.toVector3i(this.field_48380))).add("gameType=" + String.valueOf(this.method_210())).add("hardcore=" + this.method_152()).add("difficulty=" + String.valueOf(this.method_207())).toString();
    }

    @Inject(method={"method_156()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onIsRaining(CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$dimensionType.comp_643()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_203()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onIsThundering(CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$dimensionType.comp_643()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public class_2487 data$getCompound() {
        return this.impl$compound;
    }

    @Override
    public void data$setCompound(class_2487 nbt) {
        this.impl$compound = nbt;
    }
}

