/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={class_1531.class, class_1308.class, class_1657.class})
public abstract class TraitMixin_ArmorEquipable_Inventory_API
implements ArmorEquipable {
    public boolean canEquip(EquipmentType type) {
        return true;
    }

    public boolean canEquip(EquipmentType type, @Nullable ItemStackLike equipment) {
        return true;
    }

    public Optional<ItemStack> equipped(EquipmentType type) {
        InventoryAdapter inv = ((InventoryBridge)((Object)this)).bridge$getAdapter();
        EquipmentInventoryLens lens = this.impl$equipmentInventory(inv);
        Fabric fabric = inv.inventoryAdapter$getFabric();
        return Optional.of(ItemStackUtil.fromNative(lens.getSlotLens(type).getStack(fabric)));
    }

    public boolean equip(EquipmentType type, @Nullable ItemStackLike equipment) {
        InventoryAdapter inv = ((InventoryBridge)((Object)this)).bridge$getAdapter();
        EquipmentInventoryLens lens = this.impl$equipmentInventory(inv);
        Fabric fabric = inv.inventoryAdapter$getFabric();
        return lens.getSlotLens(type).setStack(fabric, ItemStackUtil.fromLikeToNative(equipment));
    }

    public ItemStack itemInHand(HandType handType) {
        Objects.requireNonNull(handType);
        class_1799 nmsItem = ((class_1309)this).method_5998((class_1268)handType);
        return ItemStackUtil.fromNative(nmsItem);
    }

    public void setItemInHand(HandType handType, @Nullable ItemStackLike itemInHand) {
        Objects.requireNonNull(handType);
        ((class_1309)this).method_6122((class_1268)handType, ItemStackUtil.fromLikeToNative(itemInHand).method_7972());
    }

    public ItemStack head() {
        return (ItemStack)this.equipped((Supplier)EquipmentTypes.HEAD).get();
    }

    public void setHead(ItemStackLike head) {
        this.equip((Supplier)EquipmentTypes.HEAD, head);
    }

    public ItemStack chest() {
        return (ItemStack)this.equipped((Supplier)EquipmentTypes.CHEST).get();
    }

    public void setChest(ItemStackLike chest) {
        this.equip((Supplier)EquipmentTypes.CHEST, chest);
    }

    public ItemStack legs() {
        return (ItemStack)this.equipped((Supplier)EquipmentTypes.LEGS).get();
    }

    public void setLegs(ItemStackLike legs) {
        this.equip((Supplier)EquipmentTypes.LEGS, legs);
    }

    public ItemStack feet() {
        return (ItemStack)this.equipped((Supplier)EquipmentTypes.FEET).get();
    }

    public void setFeet(ItemStackLike feet) {
        this.equip((Supplier)EquipmentTypes.FEET, feet);
    }

    private EquipmentInventoryLens impl$equipmentInventory(InventoryAdapter adapter) {
        Lens rootLens = adapter.inventoryAdapter$getRootLens();
        if (rootLens instanceof EquipmentInventoryLens) {
            return (EquipmentInventoryLens)rootLens;
        }
        if (rootLens instanceof PlayerInventoryLens) {
            return ((PlayerInventoryLens)rootLens).getEquipmentLens();
        }
        throw new IllegalStateException("Unexpected lens for Equipable Inventory " + rootLens.getClass().getName());
    }
}

