/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api.inventory.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.menu.InventoryMenu;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.level.ServerPlayer_ContainerListenerAccessor;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.inventory.adapter.impl.DefaultImplementedAdapterInventory;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={class_1703.class}, priority=998)
public abstract class ContainerMixin_Inventory_API
implements Container,
DefaultImplementedAdapterInventory.WithClear {
    @Shadow
    @Final
    private List<class_1712> field_7765;
    @Shadow
    @Final
    private @Nullable class_3917<?> field_17493;

    public boolean isViewedSlot(Slot slot) {
        Set<class_1735> set;
        if (slot instanceof class_1735 && (set = ((ContainerBridge)((Object)this)).bridge$getInventories().get(((class_1735)slot).field_7871)) != null && set.contains(slot)) {
            if (((ContainerBridge)((Object)this)).bridge$getInventories().size() == 1) {
                return true;
            }
            if (((class_1735)slot).field_7871.getClass() != class_1661.class) {
                return true;
            }
        }
        return false;
    }

    public List<Inventory> viewed() {
        ArrayList<Inventory> list = new ArrayList<Inventory>();
        for (class_1263 inv : ((ContainerBridge)((Object)this)).bridge$getInventories().keySet()) {
            Inventory inventory = InventoryUtil.toInventory(inv, null);
            list.add(inventory);
        }
        return list;
    }

    public boolean setCursor(ItemStackLike item) {
        if (!this.isOpen()) {
            return false;
        }
        class_1799 nativeStack = ItemStackUtil.fromLikeToNative(item);
        this.listeners().stream().findFirst().ifPresent(p -> p.field_7512.method_34254(nativeStack));
        return true;
    }

    public Optional<ItemStack> cursor() {
        return this.listeners().stream().findFirst().map(p -> p.field_7512.method_34255()).map(ItemStackUtil::fromNative);
    }

    public ServerPlayer viewer() {
        return this.listeners().stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Container without viewer"));
    }

    public boolean isOpen() {
        ContainerMixin_Inventory_API thisContainer = this;
        return this.viewer().openInventory().map(c -> c == thisContainer).orElse(false);
    }

    public Optional<ContainerType> type() {
        return Optional.ofNullable((ContainerType)this.field_17493);
    }

    private List<class_3222> listeners() {
        return this.field_7765.stream().filter(listener -> this.field_7765.get(0).getClass().getEnclosingClass() == class_3222.class).map(listener -> ((ServerPlayer_ContainerListenerAccessor)listener).accessor$this$0()).collect(Collectors.toList());
    }

    public Optional<InventoryMenu> currentMenu() {
        return Optional.ofNullable(((MenuBridge)((Object)this)).bridge$getMenu());
    }
}

