/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.entity;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin_Inventory
extends class_1297 {
    @Shadow
    private class_1799 field_48826;

    @Shadow
    public abstract void shadow$method_5673(class_1304 var1, class_1799 var2);

    @Shadow
    protected abstract class_1799 shadow$method_30126(class_1304 var1);

    @Shadow
    protected abstract class_1799 shadow$method_30125(class_1304 var1);

    @Shadow
    protected abstract void shadow$method_6040();

    protected LivingEntityMixin_Inventory(class_1299<?> param0, class_1937 param1) {
        super(param0, param1);
    }

    @Inject(method={"method_30121(Ljava/util/Map;)V"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/class_3215;method_18754(Lnet/minecraft/class_1297;Lnet/minecraft/class_2596;)V")})
    protected void inventory$onHandleHandSwap(Map<class_1304, class_1799> map, CallbackInfo ci) {
        Slot mainHand = this.impl$getSpongeSlot(class_1304.field_6173);
        boolean customMainHand = this.impl$throwEquipmentEvent(class_1304.field_6173, mainHand, map.get(class_1304.field_6173), this.shadow$method_30126(class_1304.field_6173));
        Slot offHand = this.impl$getSpongeSlot(class_1304.field_6171);
        boolean customOffHand = this.impl$throwEquipmentEvent(class_1304.field_6171, offHand, map.get(class_1304.field_6171), this.shadow$method_30126(class_1304.field_6171));
        if (customMainHand || customOffHand) {
            ci.cancel();
        }
    }

    @Inject(method={"method_30123(Ljava/util/Map;)V"}, at={@At(value="INVOKE", remap=false, target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V")})
    protected void inventory$onHandleEquipmentChanges(Map<class_1304, class_1799> map, CallbackInfo ci) {
        map.entrySet().forEach(entry -> {
            Slot slotAdapter = this.impl$getSpongeSlot((class_1304)entry.getKey());
            class_1799 oldStack = switch (((class_1304)entry.getKey()).method_5925()) {
                default -> throw new MatchException(null, null);
                case class_1304.class_1305.field_6177 -> this.shadow$method_30126((class_1304)entry.getKey());
                case class_1304.class_1305.field_6178 -> this.shadow$method_30125((class_1304)entry.getKey());
                case class_1304.class_1305.field_48825 -> this.field_48826;
            };
            entry.setValue(this.impl$callEquipmentEvent((class_1304)entry.getKey(), slotAdapter, (class_1799)entry.getValue(), oldStack));
        });
    }

    @Redirect(method={"method_37119(Lnet/minecraft/class_1799;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6040()V"))
    protected void inventory$onUpdateUsingItem(class_1309 thisEntity) {
        this.shadow$method_6040();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private class_1799 impl$callEquipmentEvent(class_1304 equipmentslottype, Slot slot, class_1799 newStack, class_1799 oldStack) {
        ChangeEntityEquipmentEvent event = InventoryEventFactory.callChangeEntityEquipmentEvent((class_1309)this, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack), slot);
        if (event.isCancelled()) {
            this.shadow$method_5673(equipmentslottype, oldStack);
            return oldStack;
        }
        @NonNull Transaction transaction = event.transaction();
        if (!transaction.isValid()) {
            this.shadow$method_5673(equipmentslottype, oldStack);
            return oldStack;
        }
        Optional optional = transaction.custom();
        if (optional.isPresent()) {
            class_1799 custom = ItemStackUtil.fromSnapshotToNative((ItemStackSnapshot)optional.get());
            this.shadow$method_5673(equipmentslottype, custom);
            return custom;
        }
        return newStack;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean impl$throwEquipmentEvent(class_1304 equipmentslottype, Slot slot, class_1799 newStack, class_1799 oldStack) {
        ChangeEntityEquipmentEvent event = InventoryEventFactory.callChangeEntityEquipmentEvent((class_1309)this, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack), slot);
        if (event.isCancelled()) {
            this.shadow$method_5673(equipmentslottype, oldStack);
            return true;
        }
        @NonNull Transaction transaction = event.transaction();
        if (!transaction.isValid()) {
            this.shadow$method_5673(equipmentslottype, oldStack);
            return true;
        }
        Optional optional = transaction.custom();
        if (optional.isPresent()) {
            class_1799 custom = ItemStackUtil.fromSnapshotToNative((ItemStackSnapshot)optional.get());
            this.shadow$method_5673(equipmentslottype, custom);
            return true;
        }
        return false;
    }

    protected Slot impl$getSpongeSlot(class_1304 equipmentSlot) {
        EquipmentType equipmentType = (EquipmentType)equipmentSlot;
        if (this instanceof InventoryBridge) {
            InventoryAdapter adapter = ((InventoryBridge)((Object)this)).bridge$getAdapter();
            Lens lens = adapter.inventoryAdapter$getRootLens();
            if (lens instanceof EquipmentInventoryLens) {
                SlotLens slotLens = ((EquipmentInventoryLens)lens).getSlotLens(equipmentType);
                return slotLens.getAdapter(adapter.inventoryAdapter$getFabric(), (Inventory)adapter);
            }
            throw new IllegalStateException("Expected EquipmentInventoryLens for " + ((Object)((Object)this)).getClass().getName() + " Inventory but found: " + lens.getClass().getName());
        }
        throw new IllegalStateException("Living Entity has no InventoryAdapter: " + ((Object)((Object)this)).getClass().getName());
    }
}

