/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.config.common.CommonConfig;
import org.spongepowered.common.config.common.ExploitCategory;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.mixin.plugin.AbstractMixinConfigPlugin;

public class ExploitPlugin
extends AbstractMixinConfigPlugin {
    private static final Map<String, Function<ExploitCategory, Boolean>> MIXIN_ENABLED_MAPPINGS = ImmutableMap.builder().put((Object)"org.spongepowered.common.mixin.exploit.world.item.WritableBookItemMixin_LimitBookSize", exploitCategory -> true).build();

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        CommonConfig globalConfig = SpongeConfigs.getCommon().get();
        if (globalConfig.modules.exploits) {
            Function<ExploitCategory, Boolean> function = MIXIN_ENABLED_MAPPINGS.get(mixinClassName);
            if (function == null) {
                new PrettyPrinter(50).add("Could not find function for exploit patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return function.apply(globalConfig.exploits);
        }
        return false;
    }
}

