/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin.entityactivation;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1421;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1480;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1534;
import net.minecraft.class_1538;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1569;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1671;
import net.minecraft.class_1682;
import net.minecraft.class_238;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5579;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.explosive.fused.FusedExplosive;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.level.entity.PersistentEntitySectionManagerAccessor;
import org.spongepowered.common.accessor.world.phys.AABBAccessor;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.activation.ActivationCapabilityBridge;
import org.spongepowered.common.bridge.world.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.EntityActivationRangeCategory;
import org.spongepowered.common.config.inheritable.GlobalConfig;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

public final class EntityActivationRange {
    private static final ImmutableMap<Byte, String> activationTypeMappings = new ImmutableMap.Builder().put((Object)1, (Object)"monster").put((Object)2, (Object)"creature").put((Object)3, (Object)"aquatic").put((Object)4, (Object)"ambient").put((Object)5, (Object)"misc").build();
    static class_238 maxBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static class_238 miscBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static class_238 creatureBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static class_238 monsterBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static class_238 aquaticBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static class_238 ambientBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static class_238 tileEntityBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static Map<Byte, Integer> maxActivationRanges = new HashMap<Byte, Integer>();

    public static byte initializeEntityActivationType(class_1297 entity) {
        if (entity instanceof class_1569) {
            return 1;
        }
        if (entity instanceof class_1429) {
            return 2;
        }
        if (entity instanceof class_1480) {
            return 3;
        }
        if (entity instanceof class_1421) {
            return 4;
        }
        return 5;
    }

    public static void initializeEntityActivationState(class_1297 entity) {
        ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
        if (entity.method_37908().method_8608()) {
            return;
        }
        if (entity instanceof class_1657 && !((PlatformEntityBridge)entity).bridge$isFakePlayer() || entity instanceof class_1682 || entity instanceof class_1510 || entity instanceof class_1508 || entity instanceof class_1528 || entity instanceof class_1668 || entity instanceof class_1538 || entity instanceof class_1541 || entity instanceof class_1534 || entity instanceof class_1511 || entity instanceof class_1671 || entity instanceof class_1540) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.getForWorld(entity.method_37908());
        EntityActivationRangeCategory config = ((WorldConfig)configAdapter.get()).entityActivationRange;
        EntityTypeBridge type = (EntityTypeBridge)entity.method_5864();
        class_2960 key = class_1299.method_5890((class_1299)entity.method_5864());
        byte activationType = spongeEntity.activation$getActivationType();
        String activationTypeName = (String)activationTypeMappings.getOrDefault((Object)activationType, (Object)"misc");
        if (!type.bridge$isActivationRangeInitialized()) {
            EntityActivationRange.addEntityToConfig(config.autoPopulate, key, activationType, activationTypeName);
            type.bridge$setActivationRangeInitialized(true);
        }
        EntityActivationRangeCategory.ModSubCategory entityMod = config.mods.get(key.method_12836());
        int defaultActivationRange = config.globalRanges.get(activationTypeName);
        if (entityMod == null) {
            spongeEntity.activation$setActivationRange(defaultActivationRange);
            if (defaultActivationRange > 0) {
                spongeEntity.activation$setDefaultActivationState(false);
            }
        } else {
            if (!entityMod.enabled) {
                spongeEntity.activation$setDefaultActivationState(true);
                return;
            }
            Integer defaultModActivationRange = entityMod.defaultRanges.get(activationTypeName);
            Integer entityActivationRange = entityMod.entities.get(key.method_12832());
            if (defaultModActivationRange != null && entityActivationRange == null) {
                spongeEntity.activation$setActivationRange(defaultModActivationRange);
                if (defaultModActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            } else if (entityActivationRange != null) {
                spongeEntity.activation$setActivationRange(entityActivationRange);
                if (entityActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            }
        }
    }

    public static class_238 growBb(class_238 target, class_238 source, int x, int y, int z) {
        ((AABBAccessor)target).accessor$setMinX(source.field_1323 - (double)x);
        ((AABBAccessor)target).accessor$setMinY(source.field_1322 - (double)y);
        ((AABBAccessor)target).accessor$setMinZ(source.field_1321 - (double)z);
        ((AABBAccessor)target).accessor$setMaxX(source.field_1320 + (double)x);
        ((AABBAccessor)target).accessor$setMaxY(source.field_1325 + (double)y);
        ((AABBAccessor)target).accessor$setMaxZ(source.field_1324 + (double)z);
        return target;
    }

    public static void activateEntities(class_3218 world) {
        if (((LevelBridge)world).bridge$isFake()) {
            return;
        }
        for (class_3222 player : world.method_18456()) {
            int maxRange = 0;
            for (Integer range : maxActivationRanges.values()) {
                if (range <= maxRange) continue;
                maxRange = range;
            }
            maxRange = Math.min((((ServerWorld)world).properties().viewDistance() << 4) - 8, maxRange);
            ((ActivationCapabilityBridge)player).activation$setActivatedTick(SpongeCommon.server().method_3780());
            class_238 aabb = maxBB;
            EntityActivationRange.growBb(aabb, player.method_5829(), maxRange, 256, maxRange);
            int i = class_3532.method_15357((double)(aabb.field_1323 / 16.0));
            int j = class_3532.method_15357((double)(aabb.field_1320 / 16.0));
            int k = class_3532.method_15357((double)(aabb.field_1321 / 16.0));
            int l = class_3532.method_15357((double)(aabb.field_1324 / 16.0));
            for (int i1 = i; i1 <= j; ++i1) {
                for (int j1 = k; j1 <= l; ++j1) {
                    class_2818 chunk = world.method_14178().method_21730(i1, j1);
                    if (chunk == null) continue;
                    EntityActivationRange.activateChunkEntities(player, chunk);
                }
            }
        }
    }

    private static void activateChunkEntities(class_3222 player, class_2818 chunk) {
        class_5579<class_1297> entityManager = ((ServerLevelAccessor)chunk.method_12200()).accessor$getEntityManager();
        class_5573 entitySectionStorage = ((PersistentEntitySectionManagerAccessor)entityManager).accessor$sectionStorage();
        entitySectionStorage.method_31782(chunk.method_12004().method_8324()).flatMap(class_5572::method_31766).forEach(entity -> {
            if (!entity.method_31476().equals((Object)chunk.method_12004())) {
                return;
            }
            ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
            long currentTick = SpongeCommon.server().method_3780();
            if (!((TrackableBridge)entity).bridge$shouldTick()) {
                return;
            }
            if (currentTick <= spongeEntity.activation$getActivatedTick()) {
                return;
            }
            if (spongeEntity.activation$getDefaultActivationState()) {
                EntityActivationRange.initializeEntityActivationState(entity);
                spongeEntity.activation$setActivatedTick(currentTick);
                return;
            }
            class_238 aabb = switch (spongeEntity.activation$getActivationType()) {
                case 5 -> miscBB;
                case 4 -> ambientBB;
                case 3 -> aquaticBB;
                case 2 -> creatureBB;
                default -> monsterBB;
            };
            int bbActivationRange = spongeEntity.activation$getActivationRange();
            EntityActivationRange.growBb(aabb, player.method_5829(), bbActivationRange, 256, bbActivationRange);
            if (aabb.method_994(entity.method_5829())) {
                spongeEntity.activation$setActivatedTick(currentTick);
            }
        });
    }

    public static boolean checkEntityImmunities(class_1297 entity) {
        if (entity.method_5799() || ((EntityAccessor)entity).accessor$remainingFireTicks() > 0) {
            return true;
        }
        if (!(entity instanceof Projectile) ? !entity.method_5685().isEmpty() || entity.method_5854() != null : !entity.method_24828()) {
            return true;
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (living.field_6235 > 0 || living.method_6026().size() > 0) {
                return true;
            }
            if (entity instanceof class_1308 && ((class_1309)entity).method_6065() != null || ((class_1309)entity).method_6052() != null) {
                return true;
            }
            if (entity instanceof class_1646 && ((class_1646)entity).method_19184()) {
                return true;
            }
            if (entity instanceof class_1429) {
                class_1429 animal = (class_1429)entity;
                if (animal.method_6109() || animal.method_6479()) {
                    return true;
                }
                if (entity instanceof class_1472 && ((class_1472)entity).method_6629()) {
                    return true;
                }
            }
            return entity instanceof FusedExplosive && ((FusedExplosive)entity).get(Keys.IS_PRIMED).orElse(false) != false;
        }
        return false;
    }

    public static boolean checkIfActive(class_1297 entity) {
        boolean isActive;
        if (entity instanceof class_1657 || entity.method_37908().method_8608() || entity.method_33724() || entity instanceof class_1671) {
            return true;
        }
        LevelChunkBridge activeChunk = ((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
        if (activeChunk == null) {
            return true;
        }
        if (!activeChunk.bridge$isActive()) {
            return false;
        }
        if (activeChunk.bridge$isPersistedChunk() || ((PlatformEntityBridge)entity).bridge$isFakePlayer() && entity instanceof class_3222) {
            return true;
        }
        long currentTick = SpongeCommon.server().method_3780();
        ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
        boolean bl = isActive = spongeEntity.activation$getActivatedTick() >= currentTick || spongeEntity.activation$getDefaultActivationState();
        if (!isActive) {
            if ((currentTick - spongeEntity.activation$getActivatedTick() - 1L) % 20L == 0L) {
                if (EntityActivationRange.checkEntityImmunities(entity)) {
                    spongeEntity.activation$setActivatedTick(currentTick + 20L);
                }
                isActive = true;
            }
        } else if (!spongeEntity.activation$getDefaultActivationState() && entity.field_6012 % 4 == 0 && !EntityActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        if (isActive && !activeChunk.bridge$areNeighborsLoaded()) {
            isActive = false;
        }
        return isActive;
    }

    public static void addEntityToConfig(boolean autoPopulate, class_2960 key, byte activationType, String activationTypeName) {
        Integer defaultRange;
        InheritableConfigHandle<GlobalConfig> globalConfig = SpongeGameConfigs.getGlobalInheritable();
        EntityActivationRangeCategory activationConfig = ((GlobalConfig)globalConfig.get()).entityActivationRange;
        boolean requiresSave = false;
        Integer range = defaultRange = activationConfig.globalRanges.getOrDefault(activationTypeName, 32);
        EntityActivationRangeCategory.ModSubCategory modSubCategory = activationConfig.mods.get(key.method_12836());
        if (autoPopulate && modSubCategory == null) {
            modSubCategory = new EntityActivationRangeCategory.ModSubCategory();
            activationConfig.mods.put(key.method_12836(), modSubCategory);
            requiresSave = true;
        }
        if (modSubCategory != null) {
            Integer modActivationRange = modSubCategory.defaultRanges.get(activationTypeName);
            if (autoPopulate && modActivationRange == null) {
                modSubCategory.defaultRanges.put(activationTypeName, defaultRange);
                requiresSave = true;
            } else if (modActivationRange != null && modActivationRange > range) {
                range = modActivationRange;
            }
            Integer entityActivationRange = modSubCategory.entities.get(key.method_12832());
            if (autoPopulate && entityActivationRange == null) {
                modSubCategory.entities.put(key.method_12832(), modSubCategory.defaultRanges.get(activationTypeName));
                requiresSave = true;
            }
            if (entityActivationRange != null && entityActivationRange > range) {
                range = entityActivationRange;
            }
        }
        int newRange = range;
        maxActivationRanges.compute(activationType, (k, maxRange) -> maxRange == null || newRange > maxRange ? newRange : maxRange);
        if (autoPopulate && requiresSave) {
            globalConfig.save();
        }
    }
}

