/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import net.minecraft.class_1297;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.util.PrettyPrinter;

@Mixin(value={class_3898.class})
public abstract class ChunkMapMixin_Tracker {
    @Shadow
    @Final
    class_3218 field_17214;

    @Redirect(method={"method_18701(Lnet/minecraft/class_1297;)V"}, at=@At(value="NEW", args={"class=java/lang/IllegalStateException"}, remap=false))
    private IllegalStateException tracker$reportEntityAlreadyTrackedWithWorld(String string, class_1297 entityIn) {
        IllegalStateException exception = new IllegalStateException(String.format("Entity %s is already tracked for world: %s", entityIn, ((ServerWorld)this.field_17214).key()));
        if (SpongeConfigs.getCommon().get().phaseTracker.verboseErrors) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Exception tracking entity", "An entity that was already tracked was added to the tracker!", exception);
        }
        return exception;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"method_61257(Lnet/minecraft/class_3193;Ljava/util/List;)Lnet/minecraft/class_2818;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_39223(Lnet/minecraft/class_2818;)V"))
    private void tracker$wrapUnpackTicks(class_3218 level, class_2818 chunk) {
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance(level);
        if (!phaseTracker.onSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async Chunk Unpacking").centre().hr().addWrapped("Someone is attempting to unpack chunk scheduled updates while off the main thread, this isgenerally unsupported and Sponge would appreciate a report about this. Please attach the generated classes output as a zip file after enabling -Dmixin.debug.export=true and request triage support on discord. Do NOT report as an issue on GitHub.", new Object[0]).add().add(" %s : %s", "Chunk Pos", chunk.method_12004().toString()).add().add(new Exception("Async Chunk Scheduling Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        if (phaseTracker.getCurrentState() == GenerationPhase.State.CHUNK_LOADING) {
            return;
        }
        try (@NonNull ChunkLoadContext ctx = ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(phaseTracker).source(chunk)).world(level)).chunk(chunk);){
            ctx.buildAndSwitch();
            chunk.method_20530(level.method_8401().method_188());
        }
    }
}

