/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1919;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_3610;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9892;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.explosive.DetonateExplosiveEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.entity.GrieferBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.effect.CheckBlockPostPlacementIsSameEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyClientEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyNeighborSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.PerformBlockDropsFromDestruction;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveTileEntityFromChunkEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.SetAndRegisterBlockEntityToLevelChunk;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateConnectingBlocksEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateWorldRendererEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldBlockChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldDestroyBlockLevelEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.TileEntityPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.WorldPipeline;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.mixin.tracker.world.level.LevelMixin_Tracker;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

@Mixin(value={class_3218.class})
public abstract class ServerLevelMixin_Tracker
extends LevelMixin_Tracker
implements TrackedWorldBridge {
    private Explosion tracker$apiExplosion;

    @WrapOperation(method={"method_31420(Lnet/minecraft/class_8921;Lnet/minecraft/class_3695;Lnet/minecraft/class_1297;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_18472(Ljava/util/function/Consumer;Lnet/minecraft/class_1297;)V")})
    private void tracker$wrapNormalEntityTick(class_3218 level, Consumer<class_1297> entityUpdateConsumer, class_1297 entity, Operation<Void> tick) {
        TrackingUtil.tickEntity(entity, () -> tick.call(new Object[]{level, entityUpdateConsumer, entity}));
    }

    @WrapOperation(method={"method_14189(Lnet/minecraft/class_2338;Lnet/minecraft/class_2248;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2680;method_26192(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_5819;)V")})
    private void tracker$wrapBlockTick(class_2680 blockState, class_3218 worldIn, class_2338 posIn, class_5819 randomIn, Operation<Void> tick) {
        TrackingUtil.updateTickBlock(this, blockState, posIn, () -> tick.call(new Object[]{blockState, worldIn, posIn, randomIn}));
    }

    @WrapOperation(method={"method_14171(Lnet/minecraft/class_2338;Lnet/minecraft/class_3611;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3610;method_15770(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)V")})
    private void tracker$wrapFluidTick(class_3610 fluidState, class_3218 level, class_2338 pos, class_2680 blockState, Operation<Void> tick) {
        TrackingUtil.updateTickFluid(this, fluidState, pos, blockState, () -> tick.call(new Object[]{fluidState, level, pos, blockState}));
    }

    @WrapOperation(method={"method_18203(Lnet/minecraft/class_2818;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2680;method_26199(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_5819;)V")})
    private void tracker$wrapBlockRandomTick(class_2680 blockState, class_3218 worldIn, class_2338 posIn, class_5819 randomIn, Operation<Void> tick) {
        TrackingUtil.randomTickBlock(this, blockState, posIn, this.field_9229, () -> tick.call(new Object[]{blockState, worldIn, posIn, randomIn}));
    }

    @WrapOperation(method={"method_18203(Lnet/minecraft/class_2818;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3610;method_15757(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_5819;)V")})
    private void tracker$wrapFluidRandomTick(class_3610 fluidState, class_3218 worldIn, class_2338 pos, class_5819 random, Operation<Void> tick) {
        TrackingUtil.randomTickFluid(this, fluidState, pos, this.field_9229, () -> tick.call(new Object[]{fluidState, worldIn, pos, random}));
    }

    @Inject(method={"method_18203(Lnet/minecraft/class_2818;I)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/class_3695;method_15396(Ljava/lang/String;)V", args={"ldc=thunder"})})
    private void tracker$startWeatherTickPhase(class_2818 param0, int param1, CallbackInfo ci) {
        ((PhaseContext)TickPhase.Tick.WEATHER.createPhaseContext(PhaseTracker.getWorldInstance((class_3218)this))).buildAndSwitch();
    }

    @Inject(method={"method_18203(Lnet/minecraft/class_2818;I)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/class_3695;method_15405(Ljava/lang/String;)V", args={"ldc=tickBlocks"})})
    private void tracker$closeWeatherTickPhase(class_2818 param0, int param1, CallbackInfo ci) {
        PhaseContext<@NonNull ?> context = PhaseTracker.getWorldInstance((class_3218)this).getPhaseContext();
        if (context.getState() != TickPhase.Tick.WEATHER) {
            throw new IllegalStateException("Expected to be in a Weather ticking state, but we aren't.");
        }
        context.close();
    }

    @WrapOperation(method={"method_14174(Lnet/minecraft/class_1919;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2680;method_26177(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;II)Z")})
    private boolean tracker$wrapBlockStateEventReceived(class_2680 recievingState, class_1937 thisWorld, class_2338 targetPos, int eventId, int flag, Operation<Boolean> blockEvent, class_1919 data) {
        return TrackingUtil.fireMinecraftBlockEvent((class_3218)this, data, () -> (Boolean)blockEvent.call(new Object[]{recievingState, thisWorld, targetPos, eventId, flag}));
    }

    @WrapOperation(method={"method_8427(Lnet/minecraft/class_2338;Lnet/minecraft/class_2248;II)V"}, at={@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;add(Ljava/lang/Object;)Z", remap=false)})
    private <K> boolean tracker$associatePhaseContextDataWithBlockEvent(ObjectLinkedOpenHashSet<K> list, K curr, Operation<Boolean> original, class_2338 pos, class_2248 blockIn, int eventID, int eventParam) {
        PhaseContext<@NonNull ?> currentContext = PhaseTracker.getWorldInstance((class_3218)this).getPhaseContext();
        class_1919 blockEventData = (class_1919)curr;
        TrackableBlockEventDataBridge blockEvent = (TrackableBlockEventDataBridge)blockEventData;
        if (currentContext.ignoresBlockEvent()) {
            return (Boolean)original.call(new Object[]{list, curr});
        }
        class_2680 state = this.shadow$method_8320(pos);
        if (((TrackableBridge)blockIn).bridge$allowsBlockEventCreation()) {
            blockEvent.bridge$setSourceUserUUID(currentContext.getActiveUserUUID());
            if (((BlockStateBridge)state).bridge$hasTileEntity()) {
                blockEvent.bridge$setTileEntity((BlockEntity)this.shadow$method_8321(pos));
            }
            if (blockEvent.bridge$getTileEntity() == null) {
                LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)this).position(pos.method_10263(), pos.method_10264(), pos.method_10260()).state((BlockState)state).build();
                blockEvent.bridge$setTickingLocatable(locatable);
            }
        }
        if (!((TrackableBridge)blockIn).bridge$allowsBlockEventCreation()) {
            return (Boolean)original.call(new Object[]{list, curr});
        }
        currentContext.appendNotifierToBlockEvent(this, pos, blockEvent);
        if (ShouldFire.CHANGE_BLOCK_EVENT_PRE && (blockIn instanceof class_2665 ? SpongeCommonEventFactory.handlePistonEvent(this, pos, state, eventID) : SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)((Object)this), pos).isCancelled())) {
            return false;
        }
        currentContext.getTransactor().logBlockEvent(state, this, pos, blockEvent);
        return (Boolean)original.call(new Object[]{list, curr});
    }

    @Redirect(method={"method_8454(Lnet/minecraft/class_1297;Lnet/minecraft/class_1282;Lnet/minecraft/class_5362;DDDFZLnet/minecraft/class_1937$class_7867;Lnet/minecraft/class_2394;Lnet/minecraft/class_2394;Lnet/minecraft/class_6880;)V"}, at=@At(value="NEW", target="(Lnet/minecraft/class_3218;Lnet/minecraft/class_1297;Lnet/minecraft/class_1282;Lnet/minecraft/class_5362;Lnet/minecraft/class_243;FZLnet/minecraft/class_1927$class_4179;)Lnet/minecraft/class_9892;"))
    private class_9892 tracker$onExplode(class_3218 $$0, class_1297 entity, class_1282 $$2, class_5362 $$3, class_243 $$4, float radius, boolean $$6, class_1927.class_4179 blockInteraction) {
        GrieferBridge grieferBridge;
        boolean cannotGrief = entity instanceof GrieferBridge && !(grieferBridge = (GrieferBridge)entity).bridge$canGrief();
        float finalRadius = radius;
        if (entity instanceof ExplosiveBridge) {
            ExplosiveBridge bridge = (ExplosiveBridge)entity;
            finalRadius = bridge.bridge$getExplosionRadius().orElse(Float.valueOf(finalRadius)).floatValue();
        }
        return new class_9892($$0, entity, $$2, $$3, $$4, finalRadius, $$6, cannotGrief ? class_1927.class_4179.field_40878 : blockInteraction);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"method_8454(Lnet/minecraft/class_1297;Lnet/minecraft/class_1282;Lnet/minecraft/class_5362;DDDFZLnet/minecraft/class_1937$class_7867;Lnet/minecraft/class_2394;Lnet/minecraft/class_2394;Lnet/minecraft/class_6880;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_9892;method_61737()V"))
    private void tracker$onExplode(class_9892 instance) {
        class_9892 mcExplosion = instance;
        class_1297 entity = instance.method_46406();
        ServerWorld thisWorld = (ServerWorld)this;
        Explosion.Builder explosionBuilder = (Explosion.Builder)Explosion.builder().from((Object)((Explosion)mcExplosion));
        if (!(entity instanceof Explosive)) {
            mcExplosion.method_61737();
            this.tracker$apiExplosion = explosionBuilder.build();
            return;
        }
        Explosive apiExplosive = (Explosive)entity;
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)this);
        DetonateExplosiveEvent detonateEvent = SpongeEventFactory.createDetonateExplosiveEvent((Cause)phaseTracker.currentCause(), (Explosion.Builder)explosionBuilder, (Explosive)apiExplosive, (Explosion)((Explosion)instance));
        if (Sponge.eventManager().post((Event)detonateEvent)) {
            this.tracker$cancelExplosionEffects(entity);
            return;
        }
        Explosion apiExplosion = detonateEvent.explosionBuilder().build();
        if (apiExplosion.radius() <= 0.0f) {
            this.tracker$cancelExplosionEffects(entity);
            return;
        }
        if (ShouldFire.EXPLOSION_EVENT_PRE) {
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre((Cause)phaseTracker.currentCause(), (Explosion)apiExplosion, (ServerWorld)thisWorld);
            if (SpongeCommon.post((Event)event)) {
                this.tracker$cancelExplosionEffects(entity);
                return;
            }
            try {
                mcExplosion = (class_9892)event.explosion();
                apiExplosion = event.explosion();
            }
            catch (ClassCastException e) {
                new PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not originate from this implementation.").trace();
                mcExplosion = (class_9892)detonateEvent.explosionBuilder().build();
            }
        }
        try (@NonNull P ctx = GeneralPhase.State.EXPLOSION.createPhaseContext(phaseTracker).explosion(mcExplosion).source(apiExplosion.sourceExplosive().orElse(this));){
            ((PhaseContext)ctx).buildAndSwitch();
            mcExplosion.method_61737();
        }
        this.tracker$apiExplosion = apiExplosion;
    }

    @Inject(method={"method_8454(Lnet/minecraft/class_1297;Lnet/minecraft/class_1282;Lnet/minecraft/class_5362;DDDFZLnet/minecraft/class_1937$class_7867;Lnet/minecraft/class_2394;Lnet/minecraft/class_2394;Lnet/minecraft/class_6880;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/class_9892;method_61737()V", shift=At.Shift.AFTER)})
    private void tracker$onCancelled(CallbackInfo ci) {
        if (this.tracker$apiExplosion == null) {
            ci.cancel();
        }
    }

    @Redirect(method={"method_8454(Lnet/minecraft/class_1297;Lnet/minecraft/class_1282;Lnet/minecraft/class_5362;DDDFZLnet/minecraft/class_1937$class_7867;Lnet/minecraft/class_2394;Lnet/minecraft/class_2394;Lnet/minecraft/class_6880;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3244;method_14364(Lnet/minecraft/class_2596;)V"))
    private void tracker$onClientboundExplodePacket(class_3244 instance, class_2596 packet) {
        class_2664 originalPacket = (class_2664)packet;
        ((ServerLevelBridge)((Object)this)).bridge$handleExplosionPacket(instance, this.tracker$apiExplosion, originalPacket);
    }

    @Inject(method={"method_8454(Lnet/minecraft/class_1297;Lnet/minecraft/class_1282;Lnet/minecraft/class_5362;DDDFZLnet/minecraft/class_1937$class_7867;Lnet/minecraft/class_2394;Lnet/minecraft/class_2394;Lnet/minecraft/class_6880;)V"}, at={@At(value="RETURN")})
    private void tracker$afterExplodeCleanup(class_1297 $$0, class_1282 $$1, class_5362 $$2, double $$3, double $$4, double $$5, float $$6, boolean $$7, class_1937.class_7867 $$8, class_2394 $$9, class_2394 $$10, class_6880<class_3414> $$11, CallbackInfo ci) {
        this.tracker$apiExplosion = null;
    }

    private void tracker$cancelExplosionEffects(class_1297 entity) {
        if (entity instanceof ExplosiveBridge) {
            ExplosiveBridge explosiveBridge = (ExplosiveBridge)entity;
            explosiveBridge.bridge$cancelExplosion();
        }
    }

    @Override
    public Optional<WorldPipeline.Builder> bridge$startBlockChange(class_2338 pos, class_2680 newState, int flags) {
        if (((class_3218)this).method_31606(pos)) {
            return Optional.empty();
        }
        if (this.shadow$method_27982()) {
            return Optional.empty();
        }
        if (this.bridge$isFake()) {
            return Optional.empty();
        }
        PhaseTracker instance = PhaseTracker.getWorldInstance((class_3218)this);
        if (!instance.onSidedThread()) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        class_2818 chunk = this.shadow$method_8500(pos);
        if (chunk.method_12223()) {
            return Optional.empty();
        }
        class_2680 currentState = chunk.method_8320(pos);
        return Optional.of(this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag, 512));
    }

    private WorldPipeline.Builder bridge$makePipeline(class_2338 pos, class_2680 currentState, class_2680 newState, class_2818 chunk, SpongeBlockChangeFlag spongeFlag, int limit) {
        TrackedLevelChunkBridge mixinChunk = (TrackedLevelChunkBridge)chunk;
        ChunkPipeline chunkPipeline = mixinChunk.bridge$createChunkPipeline(pos, newState, currentState, spongeFlag, limit);
        WorldPipeline.Builder worldPipelineBuilder = WorldPipeline.builder(chunkPipeline);
        worldPipelineBuilder.addEffect((pipeline, oldState, newState1, flag1, cursorLimit) -> {
            if (oldState == null) {
                return EffectResult.NULL_RETURN;
            }
            return EffectResult.NULL_PASS;
        }).addEffect(CheckBlockPostPlacementIsSameEffect.getInstance()).addEffect(UpdateWorldRendererEffect.getInstance()).addEffect(NotifyClientEffect.getInstance()).addEffect(NotifyNeighborSideEffect.getInstance()).addEffect(UpdateConnectingBlocksEffect.getInstance());
        return worldPipelineBuilder;
    }

    @Override
    public boolean method_30092(class_2338 pos, class_2680 newState, int flags, int limit) {
        if (((class_3218)this).method_31606(pos)) {
            return false;
        }
        if (this.shadow$method_27982()) {
            return false;
        }
        if (this.bridge$isFake()) {
            return super.method_30092(pos, newState, flags, limit);
        }
        PhaseTracker instance = PhaseTracker.getWorldInstance((class_3218)this);
        if (!instance.onSidedThread()) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        class_2818 chunk = this.shadow$method_8500(pos);
        if (chunk.method_12223()) {
            return false;
        }
        class_2680 currentState = chunk.method_8320(pos);
        if (currentState == newState) {
            return false;
        }
        WorldPipeline pipeline = this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag, limit).addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
        return pipeline.processEffects(instance.getPhaseContext(), currentState, newState, pos, null, spongeFlag, limit);
    }

    @Override
    public boolean method_30093(class_2338 pos, boolean doDrops, @Nullable class_1297 p_241212_3_, int limit) {
        class_2680 currentState = this.shadow$method_8320(pos);
        if (currentState.method_26215()) {
            return false;
        }
        if (this.bridge$isFake()) {
            return super.method_30093(pos, doDrops, p_241212_3_, limit);
        }
        PhaseTracker instance = PhaseTracker.getWorldInstance((class_3218)this);
        if (!instance.onSidedThread()) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        class_3610 fluidstate = this.shadow$method_8316(pos);
        class_2680 emptyBlock = fluidstate.method_15759();
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(3);
        class_2818 chunk = this.shadow$method_8500(pos);
        if (chunk.method_12223()) {
            return false;
        }
        WorldPipeline.Builder pipelineBuilder = this.bridge$makePipeline(pos, currentState, emptyBlock, chunk, spongeFlag, limit).addEffect(WorldDestroyBlockLevelEffect.getInstance());
        if (doDrops) {
            pipelineBuilder.addEffect(PerformBlockDropsFromDestruction.getInstance());
        }
        WorldPipeline pipeline = pipelineBuilder.addEffect((pipeline1, oldState, newState, flag, limit1) -> {
            pipeline1.getServerWorld().method_43276((class_6880)class_5712.field_28165, oldState.pos(), class_5712.class_7397.method_43286((class_1297)p_241212_3_, (class_2680)oldState.state()));
            return EffectResult.NULL_PASS;
        }).addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
        return pipeline.processEffects(instance.getPhaseContext(), currentState, emptyBlock, pos, p_241212_3_, spongeFlag, limit);
    }

    @Override
    public SpongeBlockSnapshot bridge$createSnapshot(class_2680 state, class_2338 pos, BlockChangeFlag updateFlag) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.reset();
        builder.blockState(state).world((class_3218)this).position(VecHelper.toVector3i(pos));
        class_2818 chunk = this.shadow$method_8500(pos);
        if (chunk == null) {
            return builder.flag(updateFlag).build();
        }
        Optional<UUID> creator = ((LevelChunkBridge)chunk).bridge$getBlockCreatorUUID(pos);
        Optional<UUID> notifier = ((LevelChunkBridge)chunk).bridge$getBlockNotifierUUID(pos);
        creator.ifPresent(builder::creator);
        notifier.ifPresent(builder::notifier);
        boolean hasTileEntity = ((BlockStateBridge)state).bridge$hasTileEntity();
        class_2586 tileEntity = chunk.method_12201(pos, class_2818.class_2819.field_12859);
        if ((hasTileEntity || tileEntity != null) && tileEntity != null) {
            class_2487 nbt = new class_2487();
            try {
                tileEntity.method_38242((class_7225.class_7874)tileEntity.method_10997().method_30349());
                builder.addUnsafeCompound(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        builder.flag(updateFlag);
        return builder.build();
    }

    @Override
    public void shadow$method_8544(class_2338 pos) {
        class_2338 immutable = pos.method_10062();
        class_2586 tileentity = this.shadow$method_8321(immutable);
        if (tileentity == null) {
            return;
        }
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)this);
        if (this.bridge$isFake() || !phaseTracker.onSidedThread()) {
            super.shadow$method_8544(immutable);
            return;
        }
        PhaseContext<@NonNull ?> current = phaseTracker.getPhaseContext();
        if (current.getTransactor().logTileRemoval(tileentity, () -> (class_3218)this)) {
            TileEntityPipeline pipeline = TileEntityPipeline.kickOff((class_3218)this, immutable).addEffect(RemoveTileEntityFromChunkEffect.getInstance()).build();
            pipeline.processEffects(current, new PipelineCursor(tileentity.method_11010(), immutable, tileentity, null, 512));
            return;
        }
        super.shadow$method_8544(immutable);
    }

    @Override
    public void shadow$method_8438(class_2586 proposed) {
        PhaseContext<?> current;
        class_2338 immutable = proposed.method_11016().method_10062();
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)this);
        if (this.bridge$isFake() || !phaseTracker.onSidedThread()) {
            super.shadow$method_8438(proposed);
            return;
        }
        if (proposed != null && proposed.method_10997() != (class_3218)this) {
            proposed.method_31662((class_1937)((class_3218)this));
        }
        if ((current = phaseTracker.getPhaseContext()).doesBlockEventTracking()) {
            @Nullable class_2586 existing = this.shadow$method_8500(immutable).method_8321(immutable);
            if (current.getTransactor().logTileReplacement(immutable, existing, proposed, () -> (class_3218)this)) {
                TileEntityPipeline pipeline = TileEntityPipeline.kickOff((class_3218)this, immutable).addEffect(SetAndRegisterBlockEntityToLevelChunk.getInstance()).build();
                pipeline.processEffects(current, new PipelineCursor(proposed.method_11010(), immutable, proposed, null, 512));
                return;
            }
        }
        super.shadow$method_8438(proposed);
    }

    @Inject(method={"method_14175(Lnet/minecraft/class_1297;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_5579;method_31818(Lnet/minecraft/class_5568;)Z")}, cancellable=true)
    private void tracker$throwPreEventAndRecord(class_1297 entityIn, CallbackInfoReturnable<Boolean> cir) {
        if (this.bridge$isFake()) {
            return;
        }
        PhaseTracker tracker = PhaseTracker.getWorldInstance((class_3218)this);
        if (!tracker.onSidedThread()) {
            return;
        }
        PhaseContext<@NonNull ?> current = tracker.getPhaseContext();
        if (!current.doesAllowEntitySpawns()) {
            cir.setReturnValue((Object)false);
            return;
        }
        try (CauseStackManager.StackFrame frame = tracker.pushCauseFrame();){
            ArrayList<Entity> entities = new ArrayList<Entity>();
            entities.add((Entity)entityIn);
            frame.addContext(EventContextKeys.SPAWN_TYPE, current.getSpawnTypeForTransaction(entityIn));
            SpawnEntityEvent.Pre pre = SpongeEventFactory.createSpawnEntityEventPre((Cause)frame.currentCause(), entities);
            Sponge.eventManager().post((Event)pre);
            if (pre.isCancelled() || entities.isEmpty()) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
        if (current.allowsBulkEntityCaptures()) {
            current.getTransactor().logEntitySpawn(current, this, entityIn);
        }
    }
}

