/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.chunk;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.class_6755;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.mixin.tracker.world.level.chunk.ChunkAccessMixin_Tracker;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

@Mixin(value={class_2818.class})
public abstract class LevelChunkMixin_Tracker
extends ChunkAccessMixin_Tracker
implements TrackedLevelChunkBridge,
class_5539 {
    @Shadow
    @Final
    class_1937 field_12858;
    private @MonotonicNonNull PhaseContext<@NonNull ?> tracker$postProcessContext = null;

    @Shadow
    public abstract @Nullable class_2586 shadow$method_12201(class_2338 var1, class_2818.class_2819 var2);

    @Shadow
    public abstract class_2680 method_8320(class_2338 var1);

    @Inject(method={"method_12010(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Z)Lnet/minecraft/class_2680;"}, at={@At(value="HEAD")}, cancellable=true)
    private void tracker$sanityCheckServerWorldSetBlockState(class_2338 pos, class_2680 state, boolean isMoving, CallbackInfoReturnable<class_2680> cir) {
        if (!((LevelBridge)this.field_12858).bridge$isFake()) {
            new PrettyPrinter(80).add("Illegal Direct Chunk Access").hr().add(new IllegalAccessException("No one should be accessing Chunk.setBlock in a ServerWorld's environment")).log(PhaseTracker.LOGGER, Level.WARN);
            cir.setReturnValue(null);
        }
    }

    @Override
    public @NonNull ChunkPipeline bridge$createChunkPipeline(class_2338 pos, class_2680 newState, class_2680 currentState, SpongeBlockChangeFlag flag, int limit) {
        boolean isFake = ((LevelBridge)this.field_12858).bridge$isFake();
        if (isFake) {
            throw new IllegalStateException("Cannot call ChunkBridge.bridge$buildChunkPipeline in non-Server managed worlds");
        }
        int xPos = pos.method_10263() & 0xF;
        int yPos = pos.method_10264();
        int zPos = pos.method_10260() & 0xF;
        int sectionIndex = ((class_2818)this).method_31602(yPos);
        class_2826 chunksection = this.shadow$method_38259(this.method_31602(yPos));
        boolean isEmpty = chunksection.method_38292();
        if (isEmpty && newState.method_26215()) {
            return ChunkPipeline.nullReturn((class_2818)this, (class_3218)this.field_12858);
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.getWorldInstance((class_3218)this.field_12858).getPhaseContext();
        @Nullable class_2586 existing = this.shadow$method_12201(pos, class_2818.class_2819.field_12859);
        WeakReference<class_3218> ref = new WeakReference<class_3218>((class_3218)this.field_12858);
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, pos, flag, limit, existing, () -> Objects.requireNonNull((class_3218)ref.get(), "ServerWorld dereferenced"), Optional::empty, Optional::empty);
        ChangeBlock transaction = context.createTransaction(snapshot, newState, flag);
        snapshot.blockChange = context.associateBlockChangeWithSnapshot(newState, currentState);
        if (((BlockStateBridge)snapshot.state()).bridge$hasTileEntity() && (snapshot.blockChange == BlockChange.BREAK || snapshot.blockChange == BlockChange.MODIFY)) {
            transaction.queuedRemoval = existing;
        }
        ChunkPipeline.Builder builder = ChunkPipeline.builder().kickOff(transaction).chunk((class_2818)this).chunkSection(chunksection).world((class_3218)this.field_12858);
        transaction.populateChunkEffects(builder);
        return builder.build();
    }

    @Inject(method={"method_12221(Lnet/minecraft/class_3218;)V"}, at={@At(value="HEAD")})
    private void tracker$startChunkPostProcess(CallbackInfo ci) {
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)this.field_12858);
        if (this.tracker$postProcessContext != null) {
            PhasePrinter.printMessageWithCaughtException(phaseTracker, "Expected to not have a chunk post process", "Chunk Post Process has not completed!", GenerationPhase.State.CHUNK_LOADING, this.tracker$postProcessContext, (Throwable)new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
            this.tracker$postProcessContext.close();
        }
        this.tracker$postProcessContext = ((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(phaseTracker).chunk((class_2818)this).world((class_3218)this.field_12858)).buildAndSwitch();
    }

    @Inject(method={"method_12221(Lnet/minecraft/class_3218;)V"}, at={@At(value="RETURN")})
    private void tracker$endChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext == null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Expected to complete Chunk Post Process", "Chunk Post Process has a null PhaseContext", new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
        }
        this.tracker$postProcessContext.close();
        this.tracker$postProcessContext = null;
    }

    @Redirect(method={"method_12041(Lnet/minecraft/class_2338;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2586;method_11012()V"))
    private void tracker$resetTileEntityActiveChunk(class_2586 tileEntityIn) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(null);
        tileEntityIn.method_11012();
    }

    @Inject(method={"method_12007(Lnet/minecraft/class_2586;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2586;method_10996()V")})
    private void tracker$SetActiveChunkOnTileEntityAdd(class_2586 tileEntityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(this);
        ((CreatorTrackedBridge)tileEntityIn).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, ((LevelChunkBridge)((Object)this)).bridge$getBlockCreatorUUID(tileEntityIn.method_11016()).orElse(null));
        ((CreatorTrackedBridge)tileEntityIn).tracker$setTrackedUUID(PlayerTracker.Type.NOTIFIER, null);
    }

    @Redirect(method={"method_20530(J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_6755;method_39364(J)V"))
    private void tracker$wrapRescheduledTicks(class_6755 instance, long $$0) {
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)this.field_12858);
        if (!phaseTracker.onSidedThread()) {
            return;
        }
        try (ChunkLoadContext context = GenerationPhase.State.CHUNK_LOADING.createPhaseContext(phaseTracker);){
            context.chunk((class_2818)this);
            context.buildAndSwitch();
            instance.method_39364($$0);
        }
    }
}

