/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.chunk.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2818;
import net.minecraft.class_2852;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.storage.SerializableChunkDataBridge;
import org.spongepowered.common.entity.PlayerTracker;

@Mixin(value={class_2852.class})
public abstract class SerializableChunkDataMixin_Tracker
implements SerializableChunkDataBridge {
    private Map<Short, PlayerTracker> tracker$shortPlayerPos = null;
    private Map<Integer, PlayerTracker> tracker$intPlayerPos = null;

    @Override
    public void bridge$setTrackerData(class_2818 chunkAccess) {
        LevelChunkBridge chunk = (LevelChunkBridge)chunkAccess;
        if (!chunk.bridge$getTrackedShortPlayerPositions().isEmpty() || !chunk.bridge$getTrackedIntPlayerPositions().isEmpty()) {
            this.tracker$shortPlayerPos = chunk.bridge$getTrackedShortPlayerPositions();
            this.tracker$intPlayerPos = chunk.bridge$getTrackedIntPlayerPositions();
        }
    }

    @Override
    public void bridge$writeTrackerData(class_2487 level) {
        if (this.tracker$intPlayerPos == null && this.tracker$shortPlayerPos == null) {
            return;
        }
        class_2487 trackedNbt = new class_2487();
        class_2499 positions = new class_2499();
        trackedNbt.method_10566("BlockPosTable", (class_2520)positions);
        level.method_10566("SpongeData", (class_2520)trackedNbt);
        SerializableChunkDataMixin_Tracker.tracker$writeMap(positions, this.tracker$shortPlayerPos, (nbt, pos) -> nbt.method_10575("pos", pos.shortValue()));
        SerializableChunkDataMixin_Tracker.tracker$writeMap(positions, this.tracker$intPlayerPos, (nbt, pos) -> nbt.method_10569("ipos", pos.intValue()));
    }

    private static <T> void tracker$writeMap(class_2499 positions, Map<T, PlayerTracker> map, BiConsumer<class_2487, T> consumer) {
        for (Map.Entry<T, PlayerTracker> mapEntry : map.entrySet()) {
            T pos = mapEntry.getKey();
            int ownerUniqueIdIndex = mapEntry.getValue().creatorindex;
            int notifierUniqueIdIndex = mapEntry.getValue().notifierIndex;
            class_2487 valueNbt = new class_2487();
            valueNbt.method_10569("owner", ownerUniqueIdIndex);
            valueNbt.method_10569("notifier", notifierUniqueIdIndex);
            consumer.accept(valueNbt, (class_2487)pos);
            positions.add((Object)valueNbt);
        }
    }

    @Override
    public void bridge$parseTrackerData(class_2487 fullTag) {
        class_2487 spongeData = fullTag.method_10562("SpongeData");
        this.tracker$intPlayerPos = new HashMap<Integer, PlayerTracker>();
        this.tracker$shortPlayerPos = new HashMap<Short, PlayerTracker>();
        if (spongeData.method_33133()) {
            return;
        }
        class_2499 list = spongeData.method_10554("BlockPosTable", 10);
        for (class_2520 tag : list) {
            PlayerTracker tracker = new PlayerTracker();
            class_2487 data = (class_2487)tag;
            boolean isShortPos = data.method_10545("pos");
            if (data.method_10545("owner")) {
                tracker.creatorindex = data.method_10550("owner");
            }
            if (data.method_10545("notifier")) {
                tracker.notifierIndex = data.method_10550("notifier");
            }
            if (tracker.notifierIndex == -1 && tracker.creatorindex == -1) continue;
            if (isShortPos) {
                this.tracker$shortPlayerPos.put(data.method_10568("pos"), tracker);
                continue;
            }
            this.tracker$intPlayerPos.put(data.method_10550("ipos"), tracker);
        }
    }

    @Override
    public void bridge$readTrackerDataFrom(class_2818 levelChunk) {
        LevelChunkBridge chunk = (LevelChunkBridge)levelChunk;
        chunk.bridge$setTrackedIntPlayerPositions(this.tracker$intPlayerPos);
        chunk.bridge$setTrackedShortPlayerPositions(this.tracker$shortPlayerPos);
    }
}

