/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2899;
import net.minecraft.class_2913;
import net.minecraft.class_8594;
import net.minecraft.class_8595;
import net.minecraft.class_8710;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.common.network.channel.SpongeChannelPayload;

public final class PacketUtil {
    private static final Object UNSAFE;
    private static final MethodHandle ALLOCATE_INSTANCE;

    public static class_2596<?> createLoginPayloadResponse(@Nullable class_8594 payload, int transactionId) {
        return new class_2913(transactionId, payload);
    }

    public static class_2596<?> createLoginPayloadRequest(class_8595 payload, int transactionId) {
        return new class_2899(transactionId, payload);
    }

    public static class_2596<?> createPlayPayload(class_8710.class_9154<? extends class_8710> channel, ChannelBuf payload, EngineConnectionSide<?> side) {
        if (side == EngineConnectionSide.CLIENT) {
            return new class_2817((class_8710)SpongeChannelPayload.fromType(channel, b -> b.method_52975((ByteBuf)((class_2540)payload)).slice()));
        }
        if (side == EngineConnectionSide.SERVER) {
            return new class_2658((class_8710)SpongeChannelPayload.fromType(channel, b -> b.method_52975((ByteBuf)((class_2540)payload)).slice()));
        }
        throw new UnsupportedOperationException();
    }

    public static <P extends Packet> Supplier<P> getConstructor(Class<P> packetClass) {
        Constructor constructor;
        try {
            constructor = packetClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return () -> {
            try {
                return (Packet)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    private static <P extends class_2596<?>> @NonNull P createPacketWithoutConstructor(@NonNull Class<P> packet) {
        try {
            return (P)ALLOCATE_INSTANCE.invoke(UNSAFE, packet);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to create instance of packet " + String.valueOf(packet), ex);
        }
    }

    private PacketUtil() {
    }

    static {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = unsafeField.get(null);
            ALLOCATE_INSTANCE = MethodHandles.lookup().findVirtual(unsafeClass, "allocateInstance", MethodType.methodType(Object.class, Class.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new ExceptionInInitializerError("Unable to access Unsafe instance!");
        }
    }
}

