/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import com.mojang.authlib.GameProfile;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ServerLoginPacketListenerImplBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfile;

public abstract class SpongeEngineConnection
implements EngineConnection {
    protected final class_2535 connection;
    private final AtomicReference<EventFireState> eventFireState;
    private @MonotonicNonNull GameProfile gameProfile;

    public SpongeEngineConnection(class_2535 connection) {
        this.connection = connection;
        this.eventFireState = new AtomicReference<EventFireState>(EventFireState.NONE);
    }

    public boolean active() {
        return this.connection.method_10758();
    }

    public Optional<EngineConnectionState> state() {
        if (this.active()) {
            ServerLoginPacketListenerImplBridge loginBridge;
            EngineConnectionState state = (EngineConnectionState)this.connection.method_10744();
            if (!(state instanceof ServerLoginPacketListenerImplBridge) || (loginBridge = (ServerLoginPacketListenerImplBridge)state).bridge$isIntentDone()) {
                return Optional.of(state);
            }
            return Optional.of(this.createIntentState(state.transferred()));
        }
        return Optional.empty();
    }

    public InetSocketAddress address() {
        return ((ConnectionBridge)this.connection).bridge$getAddress();
    }

    public InetSocketAddress virtualHost() {
        return ((ConnectionBridge)this.connection).bridge$getVirtualHost();
    }

    public void close() {
        this.connection.method_10747((class_2561)class_2561.method_43471((String)"disconnect.disconnected"));
    }

    public void close(Component reason) {
        this.connection.method_10747(SpongeAdventure.asVanilla(reason));
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    public class_2535 connection() {
        return this.connection;
    }

    public void disconnected() {
        if (this.eventFireState.getAndSet(EventFireState.DISCONNECTED).shouldFireDisconnectionImmediately()) {
            this.fireDisconnectEvent();
        }
    }

    public boolean postGuardedEvent(ServerSideConnectionEvent event) {
        Cancellable cancellable;
        if (!this.eventFireState.compareAndSet(EventFireState.NONE, EventFireState.IN_FLIGHT) && !this.eventFireState.compareAndSet(EventFireState.POST, EventFireState.IN_FLIGHT)) {
            return false;
        }
        SpongeCommon.post((Event)event);
        if (!this.eventFireState.compareAndSet(EventFireState.IN_FLIGHT, EventFireState.POST)) {
            this.fireDisconnectEvent();
        }
        return event instanceof Cancellable && (cancellable = (Cancellable)event).isCancelled();
    }

    private void fireDisconnectEvent() {
        this.eventFireState.set(EventFireState.DISCONNECTED);
        ServerSideConnectionEvent.Disconnect event = SpongeEventFactory.createServerSideConnectionEventDisconnect((Cause)PhaseTracker.getInstance().currentCause(), (ServerSideConnection)((ServerSideConnection)this), Optional.ofNullable(this.gameProfile).map(SpongeGameProfile::of));
        SpongeCommon.post((Event)event);
    }

    protected abstract EngineConnectionState.Intent createIntentState(boolean var1);

    private static enum EventFireState {
        NONE,
        IN_FLIGHT,
        POST,
        DISCONNECTED;


        boolean shouldFireDisconnectionImmediately() {
            return this == POST;
        }
    }
}

