/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import java.util.Set;
import net.minecraft.class_2535;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.TransactionStore;

public final class ConnectionUtil {
    public static boolean isIntentPhase(EngineConnection connection) {
        EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().method_10744();
        return state instanceof EngineConnectionState.Intent;
    }

    public static boolean isLoginPhase(EngineConnection connection) {
        EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().method_10744();
        return state instanceof EngineConnectionState.Login;
    }

    public static Set<ResourceKey> getRegisteredChannels(EngineConnection connection) {
        class_2535 networkManager = ((SpongeEngineConnection)connection).connection();
        return ((ConnectionBridge)networkManager).bridge$getRegisteredChannels();
    }

    public static TransactionStore getTransactionStore(EngineConnection connection) {
        class_2535 networkManager = ((SpongeEngineConnection)connection).connection();
        return ((ConnectionBridge)networkManager).bridge$getTransactionStore();
    }

    public static void checkHandshakeOrIntentPhase(EngineConnection connection) {
        if (!ConnectionUtil.isIntentPhase(connection) && !ConnectionUtil.isLoginPhase(connection)) {
            throw new IllegalStateException("This dispatcher may only be used for connections in the handshake phase.");
        }
    }

    public static void checkHandshakePhase(EngineConnection connection) {
        if (!ConnectionUtil.isLoginPhase(connection)) {
            throw new IllegalStateException("This dispatcher may only be used for connections in the handshake phase.");
        }
    }

    public static void checkPlayPhase(EngineConnection connection) {
        if (ConnectionUtil.isLoginPhase(connection)) {
            throw new IllegalStateException("This dispatcher may only be used for connections in the play phase.");
        }
    }

    private ConnectionUtil() {
    }
}

