/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.ClientConnectionState;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.ServerConnectionState;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.network.channel.Channel;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelExceptionHandler;
import org.spongepowered.api.network.channel.ChannelNotSupportedException;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.network.channel.ChannelExceptionUtil;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.SpongeChannelPayload;
import org.spongepowered.common.network.channel.TransactionResult;

public abstract class SpongeChannel
implements Channel {
    private final ResourceKey key;
    private final SpongeChannelManager manager;
    private final Logger logger;
    private final int type;
    private final class_8710.class_9154<SpongeChannelPayload> payloadType;
    private volatile ChannelExceptionHandler<EngineConnectionState> exceptionHandler = ChannelExceptionHandler.logEverything().suppress(ChannelNotSupportedException.class);

    public SpongeChannel(int type, ResourceKey key, SpongeChannelManager manager) {
        this.type = type;
        this.key = key;
        this.manager = manager;
        this.logger = LogManager.getLogger((String)("channel/" + key.formatted()));
        this.payloadType = new class_8710.class_9154((class_2960)key);
    }

    public int getType() {
        return this.type;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public class_8710.class_9154<SpongeChannelPayload> payloadType() {
        return this.payloadType;
    }

    public SpongeChannelManager manager() {
        return this.manager;
    }

    public ResourceKey key() {
        return this.key;
    }

    public void setExceptionHandler(ChannelExceptionHandler<EngineConnectionState> handler) {
        Objects.requireNonNull(handler, "handler");
        this.exceptionHandler = handler;
    }

    public String toString() {
        return new StringJoiner(", ", SpongeChannel.class.getSimpleName() + "[", "]").add("key=" + String.valueOf(this.key)).toString();
    }

    public boolean checkSupported(EngineConnection connection, EngineConnectionState state, CompletableFuture<?> future) {
        if (!ConnectionUtil.getRegisteredChannels(connection).contains(this.key())) {
            this.handleException(connection, state, (Throwable)new ChannelNotSupportedException("The channel \"" + String.valueOf(this.key()) + "\" isn't supported."), future);
            return false;
        }
        return true;
    }

    protected abstract void handlePlayPayload(EngineConnection var1, EngineConnectionState var2, ChannelBuf var3);

    protected abstract void handleLoginRequestPayload(EngineConnection var1, EngineConnectionState var2, int var3, ChannelBuf var4);

    protected abstract void handleTransactionResponse(EngineConnection var1, EngineConnectionState var2, Object var3, TransactionResult var4);

    public void handleException(EngineConnection connection, EngineConnectionState state, Throwable cause, @Nullable CompletableFuture<?> future) {
        try {
            this.exceptionHandler.handle(state, (Channel)this, ChannelExceptionUtil.of(cause), future);
        }
        catch (Throwable ex) {
            SpongeCommon.logger().error("The exception handler of the channel " + String.valueOf(this.key()) + " failed to handle an exception.", ex);
        }
    }

    public static <C extends EngineConnection> Class<C> getConnectionClass(EngineConnectionSide<C> side) {
        return side == EngineConnectionSide.CLIENT ? ClientSideConnection.class : ServerSideConnection.class;
    }

    public static <H> @Nullable H getRequestHandler(EngineConnectionState state, Map<Class<?>, H> handlersMap) {
        H handler = null;
        if (state instanceof ClientConnectionState) {
            if (state instanceof ClientConnectionState.Game) {
                handler = handlersMap.get(ClientConnectionState.Game.class);
            } else if (state instanceof ClientConnectionState.Configuration) {
                handler = handlersMap.get(ClientConnectionState.Configuration.class);
            } else if (state instanceof ClientConnectionState.Login) {
                handler = handlersMap.get(ClientConnectionState.Login.class);
            }
            if (handler == null && state instanceof ClientConnectionState.Authenticated) {
                handler = handlersMap.get(ClientConnectionState.Authenticated.class);
            }
            if (handler == null) {
                handler = handlersMap.get(ClientConnectionState.class);
            }
        } else if (state instanceof ServerConnectionState) {
            if (state instanceof ServerConnectionState.Game) {
                handler = handlersMap.get(ServerConnectionState.Game.class);
            } else if (state instanceof ServerConnectionState.Configuration) {
                handler = handlersMap.get(ServerConnectionState.Configuration.class);
            } else if (state instanceof ServerConnectionState.Login) {
                handler = handlersMap.get(ServerConnectionState.Login.class);
            }
            if (handler == null && state instanceof ServerConnectionState.Authenticated) {
                handler = handlersMap.get(ServerConnectionState.Authenticated.class);
            }
            if (handler == null) {
                handler = handlersMap.get(ServerConnectionState.class);
            }
        }
        if (handler == null) {
            if (state instanceof EngineConnectionState.Game) {
                handler = handlersMap.get(EngineConnectionState.Game.class);
            } else if (state instanceof EngineConnectionState.Configuration) {
                handler = handlersMap.get(EngineConnectionState.Configuration.class);
            } else if (state instanceof EngineConnectionState.Login) {
                handler = handlersMap.get(EngineConnectionState.Login.class);
            }
            if (handler == null && state instanceof EngineConnectionState.Authenticated) {
                handler = handlersMap.get(EngineConnectionState.Authenticated.class);
            }
        }
        if (handler == null) {
            handler = handlersMap.get(EngineConnectionState.class);
        }
        return handler;
    }

    public static <H> Collection<H> getResponseHandlers(EngineConnectionState state, Multimap<Class<?>, H> handlersMap) {
        ArrayList handlers = null;
        boolean modifiable = false;
        for (Map.Entry entry : handlersMap.asMap().entrySet()) {
            if (!((Class)entry.getKey()).isInstance(state)) continue;
            if (handlers == null) {
                handlers = (ArrayList)entry.getValue();
                continue;
            }
            if (!modifiable) {
                handlers = new ArrayList(handlers);
                modifiable = true;
                continue;
            }
            handlers.addAll((Collection)entry.getValue());
        }
        return handlers == null ? Collections.emptyList() : handlers;
    }
}

