/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Singleton;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_8595;
import net.minecraft.class_8710;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.Channel;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.ChannelManager;
import org.spongepowered.api.network.channel.NoResponseException;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.api.network.channel.packet.basic.BasicPacketChannel;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.ChannelBufferAllocator;
import org.spongepowered.common.network.channel.ChannelBuffers;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.RegisterChannelUtil;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.packet.SpongeBasicPacketChannel;
import org.spongepowered.common.network.channel.packet.SpongePacketChannel;
import org.spongepowered.common.network.channel.raw.SpongeRawDataChannel;
import org.spongepowered.common.util.Constants;

@Singleton
public final class SpongeChannelManager
implements ChannelManager {
    private final Map<ResourceKey, SpongeChannel> channels = new HashMap<ResourceKey, SpongeChannel>();
    private final Map<Class<?>, Tuple<Integer, CreateFunction<SpongeChannel>>> channelBuilders = new HashMap();
    private final ChannelBufferAllocator bufferAllocator;

    public SpongeChannelManager(ChannelBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
        this.registerChannelType(0, RawDataChannel.class, SpongeRawDataChannel::new);
        this.registerChannelType(1, PacketChannel.class, SpongePacketChannel::new);
        this.registerChannelType(2, BasicPacketChannel.class, SpongeBasicPacketChannel::new);
    }

    public ChannelBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    private <T extends Channel> void registerChannelType(int id, Class<T> channelType, CreateFunction<? extends T> builder) {
        this.channelBuilders.put(channelType, (Tuple<Integer, CreateFunction<SpongeChannel>>)Tuple.of((Object)id, builder));
    }

    public <C extends Channel> C createChannel(ResourceKey channelKey, Class<C> channelType) throws DuplicateRegistrationException {
        Objects.requireNonNull(channelKey, "channelKey");
        Objects.requireNonNull(channelType, "channelType");
        if (this.channels.containsKey(channelKey)) {
            throw new DuplicateRegistrationException("The channel key \"" + String.valueOf(channelKey) + "\" is already in use.");
        }
        Tuple<Integer, CreateFunction<SpongeChannel>> tuple = this.channelBuilders.get(channelType);
        if (tuple == null) {
            throw new IllegalArgumentException("Unsupported channel type: " + String.valueOf(channelType));
        }
        SpongeChannel channel = (SpongeChannel)((CreateFunction)tuple.second()).create((Integer)tuple.first(), channelKey, this);
        this.channels.put(channelKey, channel);
        return (C)channel;
    }

    public Optional<Channel> get(ResourceKey channelKey) {
        Objects.requireNonNull(channelKey, "channelKey");
        return Optional.ofNullable((Channel)this.channels.get(channelKey));
    }

    public <C extends Channel> C ofType(ResourceKey channelKey, Class<C> channelType) {
        Objects.requireNonNull(channelKey, "channelKey");
        Objects.requireNonNull(channelType, "channelType");
        Channel binding = this.channels.get(channelKey);
        if (binding != null) {
            if (!channelType.isInstance(binding)) {
                throw new IllegalStateException("There's already a channel registered for " + String.valueOf(channelKey) + ", but it is not of the requested type " + String.valueOf(channelType));
            }
            return (C)binding;
        }
        return this.createChannel(channelKey, channelType);
    }

    public Collection<Channel> channels() {
        return ImmutableList.copyOf(this.channels.values());
    }

    public CompletableFuture<Void> requestClientType(EngineConnection connection) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        int transactionId = store.nextId();
        store.put(transactionId, null, new ClientTypeSyncFuture(future));
        class_2596<?> mcPacket = PacketUtil.createLoginPayloadRequest(new class_8595(this){

            public class_2960 comp_1571() {
                return (class_2960)Constants.Channels.SPONGE_CLIENT_TYPE;
            }

            public void method_52296(class_2540 var1) {
            }
        }, transactionId);
        PacketSender.sendTo(connection, mcPacket, throwable -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    private void handleClientType(EngineConnection connection, ChannelBuf payload) {
        ClientType clientType = ClientType.from(payload.readString());
        if (clientType == null) {
            return;
        }
        ((ConnectionBridge)((SpongeEngineConnection)connection).connection()).bridge$setClientType(clientType);
    }

    public CompletableFuture<Void> sendLoginChannelRegistry(EngineConnection connection) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        int transactionId = store.nextId();
        store.put(transactionId, null, new ChannelRegistrySyncFuture(future));
        final Consumer<class_2540> consumer = this.encodeChannelRegistry();
        class_2596<?> mcPacket = PacketUtil.createLoginPayloadRequest(new class_8595(){

            public class_2960 comp_1571() {
                return (class_2960)Constants.Channels.SPONGE_CHANNEL_REGISTRY;
            }

            public void method_52296(class_2540 var1) {
                consumer.accept(var1);
            }
        }, transactionId);
        PacketSender.sendTo(connection, mcPacket, throwable -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    public void sendChannelRegistrations(EngineConnection connection) {
        class_2817 mcPacket;
        class_8710 payload = PlatformHooks.INSTANCE.getChannelHooks().createRegisterPayload(this.channels.keySet());
        if (connection.side() == EngineConnectionSide.CLIENT) {
            mcPacket = new class_2817(payload);
        } else if (connection.side() == EngineConnectionSide.SERVER) {
            mcPacket = new class_2658(payload);
        } else {
            throw new UnsupportedOperationException();
        }
        PacketSender.sendTo(connection, mcPacket);
    }

    private Consumer<class_2540> encodeChannelRegistry() {
        ImmutableList channels = ImmutableList.copyOf(this.channels.values());
        return arg_0 -> SpongeChannelManager.lambda$encodeChannelRegistry$2((List)channels, arg_0);
    }

    private void handleChannelRegistry(EngineConnection connection, ChannelBuf payload) {
        Set<ResourceKey> registered = ConnectionUtil.getRegisteredChannels(connection);
        registered.clear();
        if (payload.available() == 0) {
            SpongeCommon.logger().warn("Skipped empty payload");
            return;
        }
        int count = payload.readVarInt();
        for (int i = 0; i < count; ++i) {
            ResourceKey key = ResourceKey.resolve((String)payload.readString());
            payload.readByte();
            registered.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handlePlayPayload(EngineConnection connection, EngineConnectionState state, class_2960 channelKey, Consumer<class_2540> payload) {
        ChannelBuf buf = this.bufferAllocator.buffer();
        payload.accept((class_2540)buf);
        try {
            boolean bl = this.handlePlayPayload(connection, state, (ResourceKey)channelKey, buf);
            return bl;
        }
        finally {
            ChannelBuffers.release(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisterChannel(EngineConnection connection, ChannelBuf payload, BiConsumer<Set<ResourceKey>, List<ResourceKey>> consumer) {
        Set<ResourceKey> registered = ConnectionUtil.getRegisteredChannels(connection);
        int readerIndex = payload.readerIndex();
        try {
            List<ResourceKey> modified = RegisterChannelUtil.decodePayload(payload);
            consumer.accept(registered, modified);
        }
        finally {
            payload.readerIndex(readerIndex);
        }
    }

    private boolean handlePlayPayload(EngineConnection connection, EngineConnectionState state, ResourceKey channelKey, ChannelBuf payload) {
        if (channelKey.equals((Object)Constants.Channels.SPONGE_CLIENT_TYPE)) {
            this.handleClientType(connection, payload);
            return true;
        }
        if (channelKey.equals((Object)Constants.Channels.SPONGE_CHANNEL_REGISTRY)) {
            this.handleChannelRegistry(connection, payload);
            return true;
        }
        if (channelKey.equals((Object)Constants.Channels.REGISTER_KEY)) {
            this.handleRegisterChannel(connection, payload, Set::addAll);
            return true;
        }
        if (channelKey.equals((Object)Constants.Channels.UNREGISTER_KEY)) {
            this.handleRegisterChannel(connection, payload, Set::removeAll);
            return true;
        }
        SpongeChannel channel = this.channels.get(channelKey);
        if (channel != null) {
            channel.handlePlayPayload(connection, state, payload);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleLoginRequestPayload(EngineConnection connection, EngineConnectionState state, class_2960 channelKey, int transactionId, Consumer<class_2540> payload) {
        ChannelBuf buf = this.bufferAllocator.buffer();
        payload.accept((class_2540)buf);
        try {
            boolean bl = this.handleLoginRequestPayload(connection, state, (ResourceKey)channelKey, transactionId, buf);
            return bl;
        }
        finally {
            ChannelBuffers.release(buf);
        }
    }

    private boolean handleLoginRequestPayload(EngineConnection connection, EngineConnectionState state, ResourceKey channelKey, int transactionId, ChannelBuf payload) {
        SpongeChannel channel;
        if (channelKey.equals((Object)Constants.Channels.SPONGE_CLIENT_TYPE)) {
            ClientType clientType = ((MinecraftBridge)Sponge.client()).bridge$getClientType();
            class_2596<?> mcPacket = PacketUtil.createLoginPayloadResponse(var1 -> var1.method_10814(clientType.getName()), transactionId);
            PacketSender.sendTo(connection, mcPacket);
            return true;
        }
        if (channelKey.equals((Object)Constants.Channels.SPONGE_CHANNEL_REGISTRY)) {
            this.handleChannelRegistry(connection, payload);
            Consumer<class_2540> consumer = this.encodeChannelRegistry();
            class_2596<?> mcPacket = PacketUtil.createLoginPayloadResponse(consumer::accept, transactionId);
            PacketSender.sendTo(connection, mcPacket);
            return true;
        }
        ResourceKey actualChannelKey = channelKey;
        ChannelBuf actualPayload = payload;
        if (channelKey.equals((Object)Constants.Channels.FML_LOGIN_WRAPPER_CHANNEL)) {
            actualChannelKey = ResourceKey.resolve((String)payload.readString());
            int length = payload.readVarInt();
            actualPayload = payload.readSlice(length);
        }
        if ((channel = this.channels.get(actualChannelKey)) != null) {
            channel.handleLoginRequestPayload(connection, state, transactionId, actualPayload);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLoginResponsePayload(EngineConnection connection, EngineConnectionState state, int transactionId, @Nullable Consumer<class_2540> payload) {
        ChannelBuf buf;
        if (payload != null) {
            buf = this.bufferAllocator.buffer();
            payload.accept((class_2540)buf);
        } else {
            buf = null;
        }
        try {
            this.handleLoginResponsePayload(connection, state, transactionId, buf);
        }
        finally {
            if (buf != null) {
                ChannelBuffers.release(buf);
            }
        }
    }

    private void handleLoginResponsePayload(EngineConnection connection, EngineConnectionState state, int transactionId, @Nullable ChannelBuf payload) {
        if (transactionId == 0x7FFFFFFE) {
            return;
        }
        if (transactionId == Integer.MAX_VALUE) {
            if (payload != null) {
                ResourceKey channelKey = ResourceKey.resolve((String)payload.readString());
                this.handlePlayPayload(connection, state, channelKey, payload);
            }
            return;
        }
        TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
        TransactionStore.Entry entry = transactionStore.remove(transactionId);
        if (entry == null || entry.getData() == null) {
            return;
        }
        if (entry.getData() instanceof ClientTypeSyncFuture) {
            if (payload != null) {
                this.handleClientType(connection, payload);
            }
            ((ClientTypeSyncFuture)entry.getData()).future.complete(null);
            return;
        }
        if (entry.getData() instanceof ChannelRegistrySyncFuture) {
            if (payload != null) {
                this.handleChannelRegistry(connection, payload);
            }
            ((ChannelRegistrySyncFuture)entry.getData()).future.complete(null);
            return;
        }
        TransactionResult result = payload == null ? TransactionResult.failure((ChannelException)new NoResponseException()) : TransactionResult.success(payload);
        entry.getChannel().handleTransactionResponse(connection, state, entry.getData(), result);
    }

    private static /* synthetic */ void lambda$encodeChannelRegistry$2(List channels, class_2540 buf) {
        buf.method_10804(channels.size());
        for (SpongeChannel channel : channels) {
            buf.method_10814(channel.key().formatted());
            buf.method_52997((int)((byte)channel.getType()));
        }
    }

    static interface CreateFunction<C extends Channel> {
        public C create(int var1, ResourceKey var2, SpongeChannelManager var3);
    }

    private static final class ClientTypeSyncFuture {
        private final CompletableFuture<Void> future;

        private ClientTypeSyncFuture(CompletableFuture<Void> future) {
            this.future = future;
        }
    }

    private static final class ChannelRegistrySyncFuture {
        private final CompletableFuture<Void> future;

        private ChannelRegistrySyncFuture(CompletableFuture<Void> future) {
            this.future = future;
        }
    }
}

