/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;

public final class TransactionResult {
    private final @Nullable ChannelBuf payload;
    private final @Nullable ChannelException cause;

    public static TransactionResult success(ChannelBuf payload) {
        return new TransactionResult(payload, null);
    }

    public static TransactionResult failure(ChannelException cause) {
        return new TransactionResult(null, cause);
    }

    private TransactionResult(ChannelBuf payload, ChannelException cause) {
        this.payload = payload;
        this.cause = cause;
    }

    public boolean isSuccess() {
        return this.cause == null;
    }

    public @Nullable ChannelException getCause() {
        return this.cause;
    }

    public @Nullable ChannelBuf getPayload() {
        return this.payload;
    }
}

