/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.TimeoutException;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.TransactionResult;

public final class TransactionStore {
    private final EngineConnection connection;
    private final ConcurrentMap<Integer, Entry> lookup = Caffeine.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).removalListener((key, value, cause) -> {
        if (cause == RemovalCause.EXPIRED && value != null && value.getChannel() != null) {
            EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)this.connection()).connection().method_10744();
            value.getChannel().handleTransactionResponse(this.connection(), state, value.getData(), TransactionResult.failure((ChannelException)new TimeoutException()));
        }
    }).build().asMap();

    public TransactionStore(EngineConnection connection) {
        this.connection = connection;
    }

    public EngineConnection connection() {
        return this.connection;
    }

    public int nextId() {
        int id;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (this.lookup.containsKey(id = random.nextInt())) {
        }
        return id;
    }

    public void put(int transactionId, @Nullable SpongeChannel channel, @Nullable Object stored) {
        this.lookup.put(transactionId, new Entry(channel, stored));
    }

    public @Nullable Entry remove(int transactionId) {
        return (Entry)this.lookup.remove(transactionId);
    }

    public boolean contains(int transactionId) {
        return this.lookup.containsKey(transactionId);
    }

    public boolean isEmpty() {
        return this.lookup.isEmpty();
    }

    public static class Entry {
        private final @Nullable SpongeChannel channel;
        private final @Nullable Object data;

        public Entry(@Nullable SpongeChannel channel, @Nullable Object data) {
            this.channel = channel;
            this.data = data;
        }

        public @Nullable SpongeChannel getChannel() {
            return this.channel;
        }

        public @Nullable Object getData() {
            return this.data;
        }
    }
}

