/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import java.util.Collection;
import java.util.Objects;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.packet.HandlerPacketBinding;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketBinding;
import org.spongepowered.api.network.channel.packet.PacketHandler;
import org.spongepowered.common.network.channel.ConcurrentMultimap;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;

public final class SpongeHandlerPacketBinding<P extends Packet>
extends SpongePacketBinding<P>
implements HandlerPacketBinding<P> {
    private final ConcurrentMultimap<Class<?>, PacketHandler<? super P, ?>> handlers = new ConcurrentMultimap();

    SpongeHandlerPacketBinding(int opcode, Class<P> packetType) {
        super(opcode, packetType);
    }

    public <S extends EngineConnectionState> Collection<PacketHandler<? super P, ? super S>> getHandlers(S state) {
        return SpongeChannel.getResponseHandlers(state, this.handlers.get());
    }

    public <S extends EngineConnectionState> PacketBinding<P> addHandler(Class<S> connectionState, PacketHandler<? super P, ? super S> handler) {
        Objects.requireNonNull(connectionState, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.put((Object)connectionState, (Object)handler));
        return this;
    }

    public PacketBinding<P> addHandler(PacketHandler<? super P, EngineConnectionState> handler) {
        return this.addHandler(EngineConnectionState.class, handler);
    }

    public <S extends EngineConnectionState> PacketBinding<P> removeHandler(Class<S> connectionState, PacketHandler<? super P, ? super S> handler) {
        Objects.requireNonNull(connectionState, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> ((Class)entry.getKey()).isAssignableFrom(connectionState) && entry.getValue() == handler));
        return this;
    }

    public PacketBinding<P> removeHandler(PacketHandler<? super P, ?> handler) {
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> entry.getValue() == handler));
        return this;
    }
}

