/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8595;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.ChannelIOException;
import org.spongepowered.api.network.channel.NoResponseException;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.api.network.channel.packet.RequestPacket;
import org.spongepowered.api.network.channel.packet.RequestPacketHandler;
import org.spongepowered.api.network.channel.packet.RequestPacketResponse;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.packet.AbstractPacketChannel;
import org.spongepowered.common.network.channel.packet.SpongeFixedTransactionalPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeHandlerPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeRequestPacketResponse;
import org.spongepowered.common.network.channel.packet.SpongeTransactionalPacketBinding;

public class SpongePacketChannel
extends AbstractPacketChannel
implements PacketChannel {
    static final int TYPE_NORMAL = 0;
    static final int TYPE_REQUEST = 1;
    static final int TYPE_RESPONSE = 2;
    static final int TYPE_NO_RESPONSE = 3;
    static final int TYPE_DYNAMIC_RESPONSE = 4;
    static final int TYPE_BITS = 3;
    static final int TYPE_MASK = 7;
    static final int NO_DYNAMIC_OPCODE = -1;

    public SpongePacketChannel(int type, ResourceKey key, SpongeChannelManager manager) {
        super(type, key, manager);
    }

    private <P extends RequestPacket<R>, R extends Packet> void sendRequestPacketTo(EngineConnection connection, EngineConnectionState state, P packet, CompletableFuture<?> future, @Nullable Consumer<R> response, @Nullable Runnable sendSuccess) {
        Supplier<class_2596> mcPacketSupplier;
        SpongeTransactionalPacketBinding binding = (SpongeTransactionalPacketBinding)this.requireBinding(packet.getClass());
        TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
        int transactionId = transactionStore.nextId();
        boolean isLoginPhase = ConnectionUtil.isLoginPhase(connection);
        EngineConnectionSide side = connection.side();
        final ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        if (isLoginPhase) {
            if (side == EngineConnectionSide.CLIENT) {
                payload.writeString(this.key().formatted());
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(1, transactionId));
                payload.writeVarInt(binding.opcode());
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(var1 -> var1.method_52975((ByteBuf)((class_2540)payload)), Integer.MAX_VALUE);
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(1, binding.opcode()));
                final ResourceKey key = this.key();
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(new class_8595(){

                    public class_2960 comp_1571() {
                        return (class_2960)key;
                    }

                    public void method_52296(class_2540 var1) {
                        var1.method_52975((ByteBuf)((class_2540)payload));
                    }
                }, transactionId);
            }
        } else {
            payload.writeVarLong(SpongePacketChannel.packTypeAndValue(1, transactionId));
            payload.writeVarInt(binding.opcode());
            mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.payloadType(), payload, side);
        }
        try {
            this.encodePayload(payload, (Packet)packet);
        }
        catch (Throwable ex) {
            this.handleException(connection, state, ex, future);
            return;
        }
        if (response != null) {
            AbstractPacketChannel.TransactionData<P, R> transactionData = new AbstractPacketChannel.TransactionData<P, R>(packet, binding, response, future);
            transactionStore.put(transactionId, this, transactionData);
        }
        class_2596 mcPacket = mcPacketSupplier.get();
        PacketSender.sendTo(connection, mcPacket, throwable -> {
            if (throwable != null) {
                this.handleException(connection, state, (Throwable)throwable, future);
                if (response != null) {
                    transactionStore.remove(transactionId);
                }
            } else if (sendSuccess != null) {
                sendSuccess.run();
            }
        });
    }

    private <P extends RequestPacket<R>, R extends Packet> void sendResponsePacketTo(EngineConnection connection, EngineConnectionState state, @Nullable SpongeTransactionalPacketBinding<P, R> requestBinding, @Nullable R packet, int transactionId) {
        Supplier<class_2596> mcPacketSupplier;
        boolean isLoginPhase = ConnectionUtil.isLoginPhase(connection);
        EngineConnectionSide side = connection.side();
        final ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        if (packet == null || requestBinding instanceof SpongeFixedTransactionalPacketBinding) {
            int type;
            int n = type = packet == null ? 3 : 2;
            if (isLoginPhase) {
                if (side == EngineConnectionSide.CLIENT) {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(type, 0));
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(var1 -> var1.method_52975((ByteBuf)((class_2540)payload)), transactionId);
                } else {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(type, transactionId));
                    final ResourceKey key = this.key();
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(new class_8595(){

                        public class_2960 comp_1571() {
                            return (class_2960)key;
                        }

                        public void method_52296(class_2540 var1) {
                            var1.method_52975((ByteBuf)((class_2540)payload));
                        }
                    }, Integer.MAX_VALUE);
                }
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(type, transactionId));
                mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.payloadType(), payload, side);
            }
        } else {
            int opcode = this.requireBinding(packet.getClass()).opcode();
            if (isLoginPhase) {
                if (side == EngineConnectionSide.CLIENT) {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(4, opcode));
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(var1 -> var1.method_52975((ByteBuf)((class_2540)payload)), transactionId);
                } else {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(4, transactionId));
                    payload.writeVarInt(opcode);
                    final ResourceKey key = this.key();
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(new class_8595(){

                        public class_2960 comp_1571() {
                            return (class_2960)key;
                        }

                        public void method_52296(class_2540 var1) {
                            var1.method_52975((ByteBuf)((class_2540)payload));
                        }
                    }, Integer.MAX_VALUE);
                }
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(4, transactionId));
                payload.writeVarInt(opcode);
                mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.payloadType(), payload, side);
            }
        }
        if (packet != null) {
            try {
                this.encodePayload(payload, packet);
            }
            catch (Throwable ex) {
                this.handleException(connection, state, (Throwable)new ChannelIOException("Failed to encode request response", ex), null);
                return;
            }
        }
        class_2596 mcPacket = mcPacketSupplier.get();
        PacketSender.sendTo(connection, mcPacket);
    }

    private <P extends Packet> void sendNormalPacketTo(EngineConnection connection, P packet, CompletableFuture<Void> future) {
        Supplier<class_2596> mcPacketSupplier;
        SpongePacketBinding<Packet> binding = this.requireBinding(packet.getClass());
        boolean isLoginPhase = ConnectionUtil.isLoginPhase(connection);
        EngineConnectionSide side = connection.side();
        final ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        if (isLoginPhase) {
            if (side == EngineConnectionSide.CLIENT) {
                payload.writeString(this.key().formatted());
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(0, binding.opcode()));
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(var1 -> var1.method_52975((ByteBuf)((class_2540)payload)), Integer.MAX_VALUE);
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(0, binding.opcode()));
                int transactionId = ConnectionUtil.getTransactionStore(connection).nextId();
                final ResourceKey key = this.key();
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(new class_8595(){

                    public class_2960 comp_1571() {
                        return (class_2960)key;
                    }

                    public void method_52296(class_2540 var1) {
                        var1.method_52975((ByteBuf)((class_2540)payload));
                    }
                }, transactionId);
            }
        } else {
            payload.writeVarLong(SpongePacketChannel.packTypeAndValue(0, binding.opcode()));
            mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.payloadType(), payload, side);
        }
        try {
            this.encodePayload(payload, packet);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
            return;
        }
        class_2596 mcPacket = mcPacketSupplier.get();
        PacketSender.sendTo(connection, mcPacket, future);
    }

    public <R extends Packet> CompletableFuture<R> sendTo(EngineConnection connection, RequestPacket<R> packet) {
        CompletableFuture future;
        EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().method_10744();
        if (!this.checkSupported(connection, state, future = new CompletableFuture())) {
            return future;
        }
        this.sendRequestPacketTo(connection, state, packet, future, future::complete, null);
        return future;
    }

    public boolean isSupportedBy(EngineConnection connection) {
        Objects.requireNonNull(connection, "connection");
        return ConnectionUtil.getRegisteredChannels(connection).contains(this.key());
    }

    public CompletableFuture<Void> sendTo(EngineConnection connection, Packet packet) {
        CompletableFuture<Void> future;
        EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().method_10744();
        if (!this.checkSupported(connection, state, future = new CompletableFuture<Void>())) {
            return future;
        }
        if (packet instanceof RequestPacket) {
            this.sendRequestPacketTo(connection, state, (RequestPacket)packet, future, null, () -> future.complete(null));
        } else {
            this.sendNormalPacketTo(connection, packet, future);
        }
        return future;
    }

    private void handleResponsePacket(EngineConnection connection, EngineConnectionState state, int transactionId, @Nullable ChannelBuf payload, int dynamicOpcode) {
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        TransactionStore.Entry stored = store.remove(transactionId);
        if (stored == null || stored.getData() == null) {
            return;
        }
        AbstractPacketChannel.TransactionData transactionData = (AbstractPacketChannel.TransactionData)stored.getData();
        TransactionResult result = payload == null ? TransactionResult.failure((ChannelException)new NoResponseException()) : TransactionResult.success(payload);
        this.handleTransactionResponse(connection, state, transactionData, result, dynamicOpcode);
    }

    private void handleRequestPacket(final EngineConnection connection, final EngineConnectionState state, int opcode, final int transactionId, ChannelBuf payload) {
        RequestPacketHandler handler;
        Packet request;
        final SpongePacketBinding<Packet> binding = this.requireBinding(opcode);
        try {
            request = this.decodePayload(binding.getPacketConstructor(), payload);
        }
        catch (Throwable ex) {
            this.sendResponsePacketTo(connection, state, null, null, transactionId);
            this.handleException(connection, state, (Throwable)new ChannelIOException("Failed to decode request packet", ex), null);
            return;
        }
        boolean success = false;
        Throwable responseFailure = null;
        if (binding instanceof SpongeTransactionalPacketBinding && (handler = ((SpongeTransactionalPacketBinding)binding).getRequestHandler(state)) != null) {
            SpongeRequestPacketResponse<Packet> requestPacketResponse = new SpongeRequestPacketResponse<Packet>(){

                @Override
                protected void fail0(ChannelException exception) {
                    SpongePacketChannel.this.sendResponsePacketTo(connection, state, null, null, transactionId);
                }

                @Override
                protected void success0(Packet response) {
                    SpongePacketChannel.this.sendResponsePacketTo(connection, state, (SpongeTransactionalPacketBinding)binding, response, transactionId);
                }
            };
            try {
                handler.handleRequest((Packet)((RequestPacket)request), state, (RequestPacketResponse)requestPacketResponse);
                success = true;
            }
            catch (Throwable ex) {
                this.handleException(connection, state, (Throwable)new ChannelException("Failed to handle request packet", ex), null);
                responseFailure = ex;
            }
        }
        if (!success) {
            this.sendResponsePacketTo(connection, state, null, null, transactionId);
        }
    }

    private void handleNormalPacket(EngineConnection connection, EngineConnectionState state, int opcode, ChannelBuf payload) {
        SpongePacketBinding<Packet> binding = this.requireBinding(opcode);
        Packet packet = this.decodePayload(binding.getPacketConstructor(), payload);
        if (binding instanceof SpongeHandlerPacketBinding) {
            this.handle(connection, state, (SpongeHandlerPacketBinding)binding, packet);
        }
    }

    @Override
    protected void handlePlayPayload(EngineConnection connection, EngineConnectionState state, ChannelBuf payload) {
        long typeAndValue = payload.readVarLong();
        int type = SpongePacketChannel.extractType(typeAndValue);
        int value = SpongePacketChannel.extractValue(typeAndValue);
        if (type == 0) {
            this.handleNormalPacket(connection, state, value, payload);
        } else if (type == 1) {
            int opcode = payload.readVarInt();
            this.handleRequestPacket(connection, state, opcode, value, payload);
        } else if (type == 2) {
            this.handleResponsePacket(connection, state, value, payload, -1);
        } else if (type == 3) {
            this.handleResponsePacket(connection, state, value, null, -1);
        } else if (type == 4) {
            int opcode = payload.readVarInt();
            this.handleResponsePacket(connection, state, value, payload, opcode);
        } else {
            this.handleException(connection, state, (Throwable)new ChannelIOException("Unknown packet type: " + type), null);
        }
    }

    @Override
    protected void handleLoginRequestPayload(EngineConnection connection, EngineConnectionState state, int transactionId, ChannelBuf payload) {
        long typeAndValue = payload.readVarLong();
        int type = SpongePacketChannel.extractType(typeAndValue);
        int value = SpongePacketChannel.extractValue(typeAndValue);
        if (type == 0) {
            this.handleNormalPacket(connection, state, value, payload);
        } else if (type == 1) {
            this.handleRequestPacket(connection, state, value, transactionId, payload);
        } else if (type == 2) {
            this.handleResponsePacket(connection, state, transactionId, payload, -1);
        } else if (type == 3) {
            this.handleResponsePacket(connection, state, transactionId, null, -1);
        } else if (type == 4) {
            this.handleResponsePacket(connection, state, transactionId, payload, value);
        } else {
            this.handleException(connection, state, (Throwable)new ChannelIOException("Unknown packet type: " + type), null);
        }
    }

    @Override
    protected void handleTransactionResponse(EngineConnection connection, EngineConnectionState state, Object stored, TransactionResult result) {
        if (result.isSuccess()) {
            ChannelBuf payload = result.getPayload();
            long typeAndValue = payload.readVarLong();
            int type = SpongePacketChannel.extractType(typeAndValue);
            int value = SpongePacketChannel.extractValue(typeAndValue);
            if (type == 2 || type == 3 || type == 4) {
                AbstractPacketChannel.TransactionData transactionData = (AbstractPacketChannel.TransactionData)stored;
                if (type == 2) {
                    this.handleTransactionResponse(connection, state, transactionData, result, -1);
                } else if (type == 3) {
                    this.handleTransactionResponse(connection, state, transactionData, TransactionResult.failure((ChannelException)new NoResponseException()), -1);
                } else {
                    this.handleTransactionResponse(connection, state, transactionData, result, value);
                }
            } else {
                this.handleException(connection, state, (Throwable)new ChannelIOException("Unknown packet type: " + type), null);
            }
        }
    }

    private <P extends RequestPacket<R>, R extends Packet> void handleTransactionResponse(EngineConnection connection, EngineConnectionState state, AbstractPacketChannel.TransactionData<P, R> transactionData, TransactionResult result, int dynamicOpcode) {
        if (result.isSuccess()) {
            Packet packet;
            Supplier<Object> packetSupplier;
            ChannelBuf payload = result.getPayload();
            SpongePacketBinding<Packet> responseBinding = null;
            if (dynamicOpcode != -1) {
                responseBinding = this.requireBinding(dynamicOpcode);
                packetSupplier = responseBinding.getPacketConstructor();
            } else if (transactionData.binding instanceof SpongeFixedTransactionalPacketBinding) {
                packetSupplier = ((SpongeFixedTransactionalPacketBinding)transactionData.binding).getResponsePacketConstructor();
            } else {
                throw new ChannelException("A fixed response was send but no fixed response was bound to the request: " + String.valueOf(transactionData.request.getClass()));
            }
            try {
                packet = this.decodePayload(packetSupplier, payload);
            }
            catch (Throwable ex) {
                this.handleException(connection, state, (Throwable)new ChannelIOException("Failed to decode packet", ex), transactionData.future);
                return;
            }
            if (responseBinding != null) {
                this.handle(connection, state, (SpongeHandlerPacketBinding)responseBinding, packet);
            } else {
                this.handleResponse(connection, state, transactionData.binding, transactionData.request, packet);
            }
            if (transactionData.success != null) {
                transactionData.success.accept(packet);
            }
        } else {
            this.handleException(connection, state, (Throwable)result.getCause(), transactionData.future);
            this.handleResponseFailure(connection, state, transactionData.binding, transactionData.request, result.getCause());
        }
    }

    private static long packTypeAndValue(int type, int value) {
        return (long)type | Integer.toUnsignedLong(value) << 3;
    }

    private static int extractType(long typeAndValue) {
        return (int)(typeAndValue & 7L);
    }

    private static int extractValue(long typeAndValue) {
        return (int)(typeAndValue >>> 3);
    }
}

