/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketHandler;
import org.spongepowered.api.network.channel.packet.RequestPacket;
import org.spongepowered.api.network.channel.packet.RequestPacketHandler;
import org.spongepowered.api.network.channel.packet.ResponsePacketHandler;
import org.spongepowered.api.network.channel.packet.TransactionalPacketBinding;
import org.spongepowered.common.network.channel.ConcurrentMultimap;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.packet.PacketToResponseHandler;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;

public class SpongeTransactionalPacketBinding<P extends RequestPacket<R>, R extends Packet>
extends SpongePacketBinding<P>
implements TransactionalPacketBinding<P, R> {
    private final Map<Class<?>, RequestPacketHandler<? super P, ? extends R, ?>> requestHandlers = new HashMap();
    private final ConcurrentMultimap<Class<?>, ResponsePacketHandler<? super P, ? super R, ?>> responseHandlers = new ConcurrentMultimap();

    public SpongeTransactionalPacketBinding(int opcode, Class<P> requestPacketType) {
        super(opcode, requestPacketType);
    }

    public <S extends EngineConnectionState> @Nullable RequestPacketHandler<? super P, ? extends R, S> getRequestHandler(S state) {
        return SpongeChannel.getRequestHandler(state, this.requestHandlers);
    }

    public <S extends EngineConnectionState> TransactionalPacketBinding<P, R> setRequestHandler(Class<S> connectioState, RequestPacketHandler<? super P, ? extends R, ? super S> handler) {
        Objects.requireNonNull(connectioState, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.requestHandlers.put(connectioState, handler);
        return this;
    }

    public TransactionalPacketBinding<P, R> setRequestHandler(RequestPacketHandler<? super P, ? extends R, EngineConnectionState> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.setRequestHandler(EngineConnectionState.class, handler);
    }

    public <S extends EngineConnectionState> TransactionalPacketBinding<P, R> addResponseHandler(Class<S> connectionState, PacketHandler<? super R, ? super S> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.addResponseHandler(connectionState, new PacketToResponseHandler(handler));
    }

    public <S extends EngineConnectionState> TransactionalPacketBinding<P, R> addResponseHandler(Class<S> connectionState, ResponsePacketHandler<? super P, ? super R, ? super S> handler) {
        Objects.requireNonNull(connectionState, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.responseHandlers.modify(map -> map.put((Object)connectionState, (Object)handler));
        return this;
    }

    public TransactionalPacketBinding<P, R> addResponseHandler(PacketHandler<? super R, EngineConnectionState> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.addResponseHandler(new PacketToResponseHandler(handler));
    }

    public TransactionalPacketBinding<P, R> addResponseHandler(ResponsePacketHandler<? super P, ? super R, EngineConnectionState> handler) {
        return this.addResponseHandler(EngineConnectionState.class, handler);
    }

    public <S extends EngineConnectionState> Collection<ResponsePacketHandler<? super P, ? super R, ? super S>> getResponseHandlers(S state) {
        return SpongeChannel.getResponseHandlers(state, this.responseHandlers.get());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpongeTransactionalPacketBinding.class.getSimpleName() + "[", "]").add("opcode=" + this.opcode()).add("requestPacketType=" + String.valueOf(this.packetType())).toString();
    }
}

