/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.raw;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8595;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.handshake.RawHandshakeDataChannel;
import org.spongepowered.api.network.channel.raw.handshake.RawHandshakeDataRequestHandler;
import org.spongepowered.api.network.channel.raw.handshake.RawHandshakeDataRequestResponse;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.raw.SpongeRawDataChannel;

public class SpongeRawLoginDataChannel
implements RawHandshakeDataChannel {
    private final SpongeRawDataChannel parent;
    private final Map<Class<?>, RawHandshakeDataRequestHandler<?>> requestHandlers = new ConcurrentHashMap();

    public SpongeRawLoginDataChannel(SpongeRawDataChannel parent) {
        this.parent = parent;
    }

    private <S extends EngineConnectionState> RawHandshakeDataRequestHandler<? super S> getRequestHandler(S state) {
        return SpongeChannel.getRequestHandler(state, this.requestHandlers);
    }

    public RawDataChannel parent() {
        return this.parent;
    }

    public void setRequestHandler(RawHandshakeDataRequestHandler<EngineConnectionState> handler) {
        this.setRequestHandler(EngineConnectionState.class, handler);
    }

    public <S extends EngineConnectionState> void setRequestHandler(Class<S> state, RawHandshakeDataRequestHandler<? super S> handler) {
        Objects.requireNonNull(state, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.requestHandlers.put(state, handler);
    }

    <S extends EngineConnectionState> void handleRequestPayload(final EngineConnection connection, final S state, ChannelBuf payload, final int transactionId) {
        RawHandshakeDataRequestHandler<S> handler = this.getRequestHandler(state);
        RawHandshakeDataRequestResponse response = new RawHandshakeDataRequestResponse(){
            private boolean completed;

            private void checkCompleted() {
                if (this.completed) {
                    throw new ChannelException("The request response was already completed.");
                }
                this.completed = true;
            }

            public void fail(ChannelException exception) {
                Objects.requireNonNull(exception, "exception");
                this.checkCompleted();
                PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
            }

            public void success(Consumer<ChannelBuf> response) {
                ChannelBuf payload;
                Objects.requireNonNull(response, "response");
                this.checkCompleted();
                try {
                    payload = SpongeRawLoginDataChannel.this.parent.encodePayload(response);
                }
                catch (Throwable t) {
                    SpongeRawLoginDataChannel.this.parent.handleException(connection, state, (Throwable)new ChannelException("Failed to encode login data response", t), null);
                    PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
                    return;
                }
                PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(var1 -> var1.method_52975((ByteBuf)((class_2540)payload)), transactionId));
            }
        };
        boolean success = false;
        if (handler != null) {
            try {
                handler.handleRequest(payload, state, response);
                success = true;
            }
            catch (Throwable t) {
                this.parent.handleException(connection, state, (Throwable)new ChannelException("Failed to handle login data request", t), null);
            }
        }
        if (!success) {
            PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
        }
    }

    void handleTransactionResponse(EngineConnection connection, Object stored, TransactionResult result) {
        if (!(stored instanceof Consumer)) {
            return;
        }
        ((Consumer)stored).accept(result);
    }

    public CompletableFuture<ChannelBuf> sendTo(EngineConnection connection, Consumer<ChannelBuf> payload) {
        ChannelBuf buf;
        ConnectionUtil.checkHandshakeOrIntentPhase(connection);
        EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().method_10744();
        CompletableFuture<ChannelBuf> future = new CompletableFuture<ChannelBuf>();
        try {
            buf = this.parent.encodePayload(payload);
        }
        catch (Throwable t) {
            this.parent.handleException(connection, state, t, future);
            return future;
        }
        TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
        int transactionId = transactionStore.nextId();
        Consumer<TransactionResult> resultConsumer = result -> {
            if (result.isSuccess()) {
                future.complete(result.getPayload());
            } else {
                this.parent.handleException(connection, state, (Throwable)result.getCause(), future);
            }
        };
        final ResourceKey id = this.parent.key();
        class_2596<?> mcPacket = PacketUtil.createLoginPayloadRequest(new class_8595(){

            public class_2960 comp_1571() {
                return (class_2960)id;
            }

            public void method_52296(class_2540 var1) {
                var1.method_52975((ByteBuf)((class_2540)buf));
            }
        }, transactionId);
        transactionStore.put(transactionId, this.parent, resultConsumer);
        PacketSender.sendTo(connection, mcPacket, throwable -> {
            if (throwable != null && transactionStore.remove(transactionId) != null) {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }
}

