/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.packet;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5294;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.ClientConnectionState;
import org.spongepowered.api.network.EngineConnectionStates;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.client.multiplayer.ClientLevelAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;
import org.spongepowered.common.network.packet.RequestBlockTrackerDataPacket;
import org.spongepowered.common.network.packet.RequestEntityTrackerDataPacket;
import org.spongepowered.common.network.packet.TrackerDataResponsePacket;

public final class SpongePacketHandler {
    private static PacketChannel channel;

    public static void init(SpongeChannelManager registry) {
        channel = registry.createChannel(ResourceKey.sponge((String)"default"), PacketChannel.class);
        channel.registerTransactional(RequestBlockTrackerDataPacket.class, TrackerDataResponsePacket.class, 0).setRequestHandler(EngineConnectionStates.SERVER_GAME, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.player();
            if (!player.hasPermission("sponge.debug.block-tracking")) {
                return;
            }
            class_3222 sender = (class_3222)player;
            class_2338 pos = new class_2338(requestPacket.x, requestPacket.y, requestPacket.z);
            if (!sender.method_37908().method_22340(pos)) {
                return;
            }
            LevelChunkBridge levelChunkBridge = (LevelChunkBridge)sender.method_37908().method_8500(pos);
            Optional<UUID> owner = levelChunkBridge.bridge$getBlockCreatorUUID(pos);
            Optional<UUID> notifier = levelChunkBridge.bridge$getBlockNotifierUUID(pos);
            response.success((Packet)SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.registerTransactional(RequestEntityTrackerDataPacket.class, TrackerDataResponsePacket.class, 1).setRequestHandler(EngineConnectionStates.SERVER_GAME, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.player();
            if (!player.hasPermission("sponge.debug.entity-tracking")) {
                return;
            }
            class_3222 sender = (class_3222)player;
            class_1297 entity = sender.method_37908().method_8469(requestPacket.entityId);
            if (!(entity instanceof CreatorTrackedBridge)) {
                return;
            }
            CreatorTrackedBridge creatorTrackedBridge = (CreatorTrackedBridge)entity;
            Optional<UUID> owner = creatorTrackedBridge.tracker$getCreatorUUID();
            Optional<UUID> notifier = creatorTrackedBridge.tracker$getNotifierUUID();
            response.success((Packet)SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.register(ChangeViewerEnvironmentPacket.class, 3).addHandler(ClientConnectionState.class, (packet, connection) -> {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return;
            }
            class_2874 dimensionType = (class_2874)SpongeCommon.vanillaRegistry(class_7924.field_41241).method_63535(packet.dimensionLogic);
            ((ClientLevelAccessor)world).accessor$effects(class_5294.method_28111((class_2874)dimensionType));
        });
    }

    private static TrackerDataResponsePacket createTrackerDataResponse(Optional<UUID> owner, Optional<UUID> notifier) {
        String ownerName = owner.flatMap(x -> SpongeCommon.server().method_3793().method_14512(x)).map(GameProfile::getName).orElse("");
        String notifierName = notifier.flatMap(x -> SpongeCommon.server().method_3793().method_14512(x)).map(GameProfile::getName).orElse("");
        return new TrackerDataResponsePacket(ownerName, notifierName);
    }

    public static PacketChannel getChannel() {
        return Objects.requireNonNull(channel);
    }
}

