/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.network.status.StatusClient;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.network.status.SpongeLegacyStatusClient;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeStatusResponse
implements ClientPingServerEvent.Response {
    private final class_2926 originalStatus;
    private class_2561 description;
    private SpongeStatusPlayers players;
    private boolean hiddenPlayers;
    private SpongeStatusVersion version;
    private class_2926.class_8145 favicon;

    private SpongeStatusResponse(class_2926 status) {
        this.originalStatus = status;
        this.description = status.comp_1273();
        this.players = new SpongeStatusPlayers(status.comp_1274().orElse(null));
        this.hiddenPlayers = false;
        this.version = new SpongeStatusVersion(status.comp_1275().orElse(null));
        this.favicon = status.comp_1276().orElse(null);
    }

    public void setDescription(Component description) {
        this.description = SpongeAdventure.asVanilla(Objects.requireNonNull(description, "description"));
    }

    public Component description() {
        return SpongeAdventure.asAdventure(this.description);
    }

    public Optional<ClientPingServerEvent.Response.Players> players() {
        if (this.hiddenPlayers) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.players);
    }

    public void setHidePlayers(boolean hide) {
        this.hiddenPlayers = hide;
    }

    public void setFavicon(@Nullable Favicon favicon) {
        if (favicon == null) {
            this.favicon = null;
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)favicon.image(), "PNG", bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.favicon = new class_2926.class_8145(bytes.toByteArray());
    }

    public ClientPingServerEvent.Response.Version version() {
        return this.version;
    }

    public Optional<Favicon> favicon() {
        return Optional.ofNullable((Favicon)this.favicon);
    }

    private class_2926 toVanilla() {
        return PlatformHooks.INSTANCE.getGeneralHooks().createServerStatus(this.originalStatus, this.description, Optional.ofNullable(this.hiddenPlayers || this.players == null ? null : this.players.toVanilla()), Optional.of(this.version.toVanilla()), Optional.ofNullable(this.favicon));
    }

    public String motd() {
        return SpongeStatusResponse.getFirstLine(LegacyComponentSerializer.legacySection().serialize(SpongeAdventure.asAdventure(this.description)));
    }

    public String unformattedMotd() {
        return SpongeStatusResponse.getFirstLine(PlainTextComponentSerializer.plainText().serialize(SpongeAdventure.asAdventure(this.description)));
    }

    public int onlinePlayers() {
        return !this.hiddenPlayers && this.players != null ? this.players.online : 0;
    }

    public int maxPlayers() {
        return !this.hiddenPlayers && this.players != null ? this.players.max : -1;
    }

    public static @Nullable class_2926 post(class_2926 status, StatusClient client) {
        SpongeStatusResponse response = SpongeStatusResponse.call(status, client);
        return response != null ? response.toVanilla() : null;
    }

    public static @Nullable SpongeStatusResponse postLegacy(MinecraftServer server, InetSocketAddress address, MinecraftVersion version, InetSocketAddress virtualHost) {
        return SpongeStatusResponse.call(server.method_3765(), new SpongeLegacyStatusClient(address, version, virtualHost));
    }

    private static @Nullable SpongeStatusResponse call(class_2926 response, StatusClient client) {
        SpongeStatusResponse mutableResponse = new SpongeStatusResponse(response);
        if (!SpongeCommon.post((Event)SpongeEventFactory.createClientPingServerEvent((Cause)Cause.of((EventContext)EventContext.empty(), (Object)Sponge.server()), (StatusClient)client, (ClientPingServerEvent.Response)mutableResponse))) {
            return mutableResponse;
        }
        return null;
    }

    private static String getFirstLine(String s) {
        return NetworkUtil.substringBefore(s, '\n');
    }

    public static final class SpongeStatusPlayers
    implements ClientPingServerEvent.Response.Players {
        private int max;
        private int online;
        private final List<GameProfile> profiles = new ArrayList<GameProfile>();

        public SpongeStatusPlayers(class_2926.class_2927 players) {
            if (players == null) {
                this.max = -1;
                this.online = 0;
            } else {
                this.max = players.comp_1279();
                this.online = players.comp_1280();
                players.comp_1281().forEach(profile -> this.profiles.add(SpongeGameProfile.of(profile)));
            }
        }

        public int max() {
            return this.max;
        }

        public int online() {
            return this.online;
        }

        public List<GameProfile> profiles() {
            return this.profiles;
        }

        public void setOnline(int online) {
            this.online = online;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public class_2926.class_2927 toVanilla() {
            return new class_2926.class_2927(this.max, this.online, this.profiles.stream().map(SpongeGameProfile::toMcProfileNonNull).toList());
        }
    }

    public static final class SpongeStatusVersion
    implements ClientPingServerEvent.Response.Version {
        private String name;
        private int protocol;

        public SpongeStatusVersion(class_2926.class_2930 version) {
            if (version != null) {
                this.name = version.comp_1282();
                this.protocol = version.comp_1283();
            } else {
                this.name = "";
                this.protocol = 0;
            }
        }

        public String name() {
            return this.name;
        }

        public void setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
        }

        public boolean isLegacy() {
            return false;
        }

        public int protocolVersion() {
            return this.protocol;
        }

        public void setProtocolVersion(int protocolVersion) {
            this.protocol = protocolVersion;
        }

        public OptionalInt dataVersion() {
            return OptionalInt.empty();
        }

        public class_2926.class_2930 toVanilla() {
            return new class_2926.class_2930(this.name, this.protocol);
        }
    }
}

