/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.placeholder;

import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.SystemSubject;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.placeholder.PlaceholderContext;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.placeholder.SpongePlaceholderContext;

public class SpongePlaceholderContextBuilder
implements PlaceholderContext.Builder {
    private @Nullable Supplier<Object> associatedObjectSupplier;
    private @Nullable String argument = null;

    public PlaceholderContext.Builder associatedObject(@Nullable Object associatedObject) {
        if (associatedObject == null) {
            this.associatedObjectSupplier = null;
        } else {
            if (associatedObject instanceof Supplier) {
                return this.associatedObject((Supplier)associatedObject);
            }
            if (associatedObject instanceof SystemSubject) {
                this.associatedObjectSupplier = Sponge::systemSubject;
            } else if (associatedObject instanceof Server) {
                this.associatedObjectSupplier = Sponge::server;
            } else {
                if (associatedObject instanceof Player) {
                    return this.associatedObject((Player)associatedObject);
                }
                if (associatedObject instanceof ServerWorld) {
                    ResourceKey key = ((ServerWorld)associatedObject).key();
                    this.associatedObjectSupplier = () -> SpongeCommon.game().server().worldManager().world(key).orElse(null);
                } else if (associatedObject instanceof Entity) {
                    Entity entity = (Entity)associatedObject;
                    ResourceKey key = ((ServerWorld)entity.serverLocation().world()).key();
                    UUID entityUuid = ((Entity)associatedObject).uniqueId();
                    this.associatedObjectSupplier = () -> SpongeCommon.game().server().worldManager().world(key).flatMap(x -> x.entity(entityUuid)).orElse(null);
                } else {
                    WeakReference<Object> objectWeakReference = new WeakReference<Object>(associatedObject);
                    this.associatedObjectSupplier = objectWeakReference::get;
                }
            }
        }
        return this;
    }

    public PlaceholderContext.Builder associatedObject(@Nullable Supplier<Object> associatedObjectSupplier) {
        this.associatedObjectSupplier = associatedObjectSupplier;
        return this;
    }

    public PlaceholderContext.Builder argumentString(@Nullable String argument) {
        this.argument = argument == null || argument.isEmpty() ? null : argument;
        return this;
    }

    public PlaceholderContext build() throws IllegalStateException {
        return new SpongePlaceholderContext(this.associatedObjectSupplier, this.argument);
    }

    public PlaceholderContext.Builder reset() {
        this.associatedObjectSupplier = null;
        this.argument = null;
        return this;
    }
}

