/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.util.Constants;

public final class SpongeGameProfileDataBuilder
extends AbstractDataBuilder<GameProfile> {
    public SpongeGameProfileDataBuilder() {
        super(GameProfile.class, 1);
    }

    protected Optional<GameProfile> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Entity.Player.UUID)) {
            return Optional.empty();
        }
        UUID uuid = this.getUUIDByString((String)container.getString(Constants.Entity.Player.UUID).get());
        if (!container.contains(Constants.Entity.Player.NAME)) {
            return Optional.of(GameProfile.of((UUID)uuid));
        }
        return Optional.of(GameProfile.of((UUID)uuid, (String)((String)container.getString(Constants.Entity.Player.NAME).get())));
    }

    private UUID getUUIDByString(String uuidString) throws InvalidDataException {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException("Invalid UUID string: " + uuidString);
        }
    }
}

