/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.mojang.authlib.properties.Property;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.profile.property.ProfileProperty;

public final class SpongeProfileProperty
implements ProfileProperty {
    private final String name;
    private final String value;
    private final @Nullable String signature;

    public SpongeProfileProperty(Property property) {
        this(property.name(), property.value(), property.signature());
    }

    public SpongeProfileProperty(String name, String value, @Nullable String signature) {
        this.name = name;
        this.value = value;
        this.signature = signature;
    }

    public int contentVersion() {
        return 1;
    }

    public @NonNull DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Queries.PROPERTY_NAME, (Object)this.name).set(Queries.PROPERTY_VALUE, (Object)this.value);
        if (this.signature != null) {
            container.set(Queries.PROPERTY_SIGNATURE, (Object)this.signature);
        }
        return container;
    }

    public @NonNull String name() {
        return this.name;
    }

    public @NonNull String value() {
        return this.value;
    }

    public @NonNull Optional<String> signature() {
        return Optional.ofNullable(this.signature);
    }

    public Property asProperty() {
        return new Property(this.name, this.value, this.signature);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.signature);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpongeProfileProperty)) {
            return false;
        }
        SpongeProfileProperty other = (SpongeProfileProperty)obj;
        return other.name().equals(this.name) && other.value().equals(this.value) && Objects.equals(other.signature, this.signature);
    }

    public String toString() {
        return new StringJoiner(", ", Property.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("value='" + this.value + "'").add("signature='" + this.signature + "'").toString();
    }
}

