/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.raid;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.living.monster.raider.Raider;
import org.spongepowered.api.raid.Raid;
import org.spongepowered.api.raid.RaidWave;
import org.spongepowered.common.accessor.world.entity.raid.RaidAccessor;

public final class SpongeRaidWave
implements RaidWave {
    private final class_3765 raid;
    private final int waveId;

    public SpongeRaidWave(class_3765 raid, int waveId) {
        this.raid = raid;
        this.waveId = waveId;
    }

    public Raid raid() {
        return (Raid)this.raid;
    }

    public boolean isBonus() {
        return !this.isFinal() && this.waveId >= ((RaidAccessor)this.raid).accessor$numGroups();
    }

    public boolean isFinal() {
        return this.waveId == ((RaidAccessor)this.raid).accessor$numGroups();
    }

    public Optional<Raider> leader() {
        return Optional.ofNullable((Raider)this.raid.method_16496(this.waveId));
    }

    public boolean addRaider(Raider raider, boolean addToRaidHealth) {
        Objects.requireNonNull(raider, "Raider cannot be null.");
        return this.raid.method_16487(this.waveId, (class_3763)raider, addToRaidHealth);
    }

    public boolean removeRaider(Raider raider) {
        Objects.requireNonNull(raider, "Raider cannot be null.");
        if (raider.raidWave().isPresent() && this.equals(((Value)raider.raidWave().get()).get())) {
            this.raid.method_16510((class_3763)raider, true);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpongeRaidWave) {
            SpongeRaidWave other = (SpongeRaidWave)obj;
            if (this.waveId == other.waveId && this.raid.method_16831() == other.raid.method_16831() && this.raid.method_16494() == other.raid.method_16494()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", SpongeRaidWave.class.getSimpleName() + "[", "]").add("raid=" + String.valueOf(this.raid)).add("wave=" + this.waveId).toString();
    }
}

