/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_9248;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryRoots;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.common.accessor.core.MappedRegistryAccessor;
import org.spongepowered.common.accessor.resources.ResourceKeyAccessor;
import org.spongepowered.common.bridge.core.MappedRegistryBridge;
import org.spongepowered.common.bridge.core.WritableRegistryBridge;
import org.spongepowered.common.registry.CallbackRegistry;
import org.spongepowered.common.registry.InitialRegistryData;

public final class RegistryHolderLogic
implements RegistryHolder {
    private final Map<ResourceKey, class_2378<class_2378<?>>> roots = new Object2ObjectOpenHashMap();

    public RegistryHolderLogic() {
        this.roots.put((ResourceKey)class_2960.method_60656((String)"root"), (class_2378<class_2378<?>>)new class_2370(class_5321.method_29180((class_2960)((class_2960)RegistryRoots.MINECRAFT)), Lifecycle.experimental()));
        class_2960 sponge = class_2960.method_60655((String)"sponge", (String)"root");
        this.roots.put((ResourceKey)sponge, (class_2378<class_2378<?>>)new class_2370(ResourceKeyAccessor.invoker$create(sponge, sponge), Lifecycle.stable()));
    }

    public RegistryHolderLogic(class_5455 dynamicAccess) {
        this();
        class_2385 root = (class_2385)this.roots.get(class_2960.method_60656((String)"root"));
        dynamicAccess.method_40311().forEach(entry -> root.method_10272(entry.comp_350(), (Object)entry.comp_351(), class_9248.field_49136));
        root.method_40276();
    }

    public void setRootMinecraftRegistry(class_2378<class_2378<?>> rootRegistry) {
        this.roots.put(RegistryRoots.MINECRAFT, rootRegistry);
    }

    public <T> Registry<T> registry(RegistryType<T> type) {
        class_2378<class_2378<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        class_2378 registry = (class_2378)root.method_17966((class_2960)type.location()).orElseThrow(() -> new ValueNotFoundException(String.format("No '%s' registry has been defined in root '%s'", type.location(), type.root())));
        return (Registry)registry;
    }

    public <T> Optional<Registry<T>> findRegistry(RegistryType<T> type) {
        class_2378<class_2378<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            return Optional.empty();
        }
        return root.method_17966((class_2960)type.location());
    }

    public Stream<Registry<?>> streamRegistries(ResourceKey root) {
        class_2378<class_2378<?>> rootRegistry = this.roots.get(Objects.requireNonNull(root, "root"));
        if (rootRegistry == null) {
            return Stream.empty();
        }
        return rootRegistry.method_10220();
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Map<ResourceKey, T> defaultValues) {
        return this.createRegistry(type, defaultValues != null ? () -> defaultValues : null, false);
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues) {
        return this.createRegistry(type, defaultValues, false);
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues, boolean isDynamic) {
        return this.createRegistry(type, InitialRegistryData.noIds(defaultValues), this.registrySupplier(isDynamic, null), false);
    }

    public <T> Function<class_5321<class_2378<T>>, class_2378<T>> registrySupplier(boolean isDynamic, @Nullable BiConsumer<class_5321<T>, T> callback) {
        if (callback == null) {
            return key -> {
                class_2370 reg = new class_2370(key, Lifecycle.stable());
                ((WritableRegistryBridge)reg).bridge$setDynamic(isDynamic);
                return reg;
            };
        }
        return key -> {
            CallbackRegistry reg = new CallbackRegistry(key, Lifecycle.stable(), callback);
            ((WritableRegistryBridge)((Object)reg)).bridge$setDynamic(isDynamic);
            return reg;
        };
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable InitialRegistryData<T> defaultValues, Function<class_5321<class_2378<T>>, class_2378<T>> registrySupplier, boolean replace) {
        boolean exists;
        class_2378<class_2378<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        class_2378<T> registry = (class_2378<T>)root.method_63535((class_2960)type.location());
        boolean bl = exists = registry != null;
        if (!replace && exists) {
            throw new DuplicateRegistrationException(String.format("Registry '%s' in root '%s' has already been defined", type.location(), type.root()));
        }
        class_5321 key = class_7924.field_47497.equals((Object)type.root()) ? class_5321.method_29180((class_2960)((class_2960)type.location())) : ResourceKeyAccessor.invoker$create((class_2960)RegistryRoots.SPONGE, (class_2960)type.location());
        registry = registrySupplier.apply(key);
        if (defaultValues != null) {
            class_2370 mr = (class_2370)registry;
            defaultValues.forEach((vk, vi, vv) -> {
                mr.method_10272(class_5321.method_29179((class_5321)key, (class_2960)((class_2960)vk)), vv, class_9248.field_49136);
                vi.ifPresent(id -> {
                    if (mr.method_10206(vv) != id) {
                        throw new IllegalStateException("Registry entry " + String.valueOf(vk) + " was expected to have id of " + id + " but was instead " + mr.method_10206(vv));
                    }
                });
            });
        }
        boolean frozen = ((MappedRegistryAccessor)root).accessor$frozen();
        if (replace && exists) {
            ((MappedRegistryAccessor)root).accessor$frozen(false);
            ((MappedRegistryBridge)root).bridge$forceRemoveValue(key);
        }
        ((class_2385)root).method_10272(key, registry, class_9248.field_49136);
        if (registry instanceof CallbackRegistry) {
            ((CallbackRegistry)registry).setCallbackEnabled(true);
        }
        ((MappedRegistryAccessor)root).accessor$frozen(frozen);
        return (Registry)registry;
    }

    public void freezeSpongeRootRegistry() {
        this.roots.get(RegistryRoots.SPONGE).method_40276();
    }

    public void freezeSpongeDynamicRegistries() {
        this.roots.get(RegistryRoots.SPONGE).forEach(class_2378::method_40276);
    }
}

