/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.common.registry.InitialRegistryData;

public final class RegistryLoader<T>
extends InitialRegistryData<T> {
    private final Map<ResourceKey, T> values = new LinkedHashMap<ResourceKey, T>();
    private @MonotonicNonNull Map<ResourceKey, Integer> ids;

    private RegistryLoader() {
    }

    public static <T> RegistryLoader<T> of(Consumer<RegistryLoader<T>> consumer) {
        RegistryLoader<T> loader = new RegistryLoader<T>();
        consumer.accept(loader);
        return loader;
    }

    public RegistryLoader<T> add(RegistryKey<? extends T> key, Supplier<? extends T> function) {
        this.values.put(key.location(), function.get());
        return this;
    }

    public RegistryLoader<T> add(RegistryKey<? extends T> key, Function<ResourceKey, ? extends T> function) {
        this.values.put(key.location(), function.apply(key.location()));
        return this;
    }

    public RegistryLoader<T> add(ResourceKey key, T value) {
        this.values.put(key, value);
        return this;
    }

    public RegistryLoader<T> addWithId(int id, RegistryKey<? extends T> key, Supplier<? extends T> supplier) {
        return this.addWithId0(id, key, supplier.get());
    }

    public RegistryLoader<T> addWithId(int id, RegistryKey<? extends T> key, Function<ResourceKey, ? extends T> function) {
        return this.addWithId0(id, key, function.apply(key.location()));
    }

    public <MC> RegistryLoader<T> addWithId(MC mcType, RegistryKey<? extends T> key, Function<MC, ? extends T> function, Function<MC, Integer> idFunction) {
        return this.addWithId0(idFunction.apply(mcType), key, function.apply(mcType));
    }

    private RegistryLoader<T> addWithId0(int id, RegistryKey<? extends T> key, T value) {
        this.values.put(key.location(), value);
        if (this.ids == null) {
            this.ids = new HashMap<ResourceKey, Integer>();
        }
        this.ids.put(key.location(), id);
        return this;
    }

    public RegistryLoader<T> mapping(final Supplier<? extends T> supplier, Consumer<Mapping<T>> consumer) {
        consumer.accept(new Mapping<T>(){

            @Override
            public Mapping<T> add(RegistryKey<? extends T> ... keys) {
                for (RegistryKey key : keys) {
                    RegistryLoader.this.add(key, supplier);
                }
                return this;
            }
        });
        return this;
    }

    public RegistryLoader<T> mapping(final Function<ResourceKey, ? extends T> function, Consumer<Mapping<T>> consumer) {
        consumer.accept(new Mapping<T>(){

            @Override
            public Mapping<T> add(RegistryKey<? extends T> ... keys) {
                for (RegistryKey key : keys) {
                    RegistryLoader.this.add(key, function);
                }
                return this;
            }
        });
        return this;
    }

    public Map<ResourceKey, T> values() {
        return this.values;
    }

    @Override
    Map<ResourceKey, T> keyToValue() {
        return this.values;
    }

    @Override
    @Nullable Map<ResourceKey, Integer> keyToId() {
        return this.ids;
    }

    public static interface Mapping<T> {
        public Mapping<T> add(RegistryKey<? extends T> ... var1);
    }
}

