/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.common.registry.SpongeRegistryReference;

public final class SpongeDefaultedRegistryReference<T>
extends SpongeRegistryReference<T>
implements DefaultedRegistryReference<T> {
    private final Supplier<RegistryHolder> defaultHolder;

    public SpongeDefaultedRegistryReference(RegistryKey<T> key, Supplier<RegistryHolder> defaultHolder) {
        super(key);
        this.defaultHolder = Objects.requireNonNull(defaultHolder, "defaultHolder");
    }

    public T get() {
        return (T)this.defaultHolder.get().registry(this.registry()).value(this.location());
    }

    public Optional<T> find() {
        Optional registry = this.defaultHolder.get().findRegistry(this.registry());
        return registry.flatMap(r -> r.findValue(this.location()));
    }

    public Supplier<RegistryHolder> defaultHolder() {
        return this.defaultHolder;
    }
}

