/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.registry.InitialRegistryData;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.RegistryLoader;

public interface SpongeRegistryHolder
extends RegistryHolder {
    public RegistryHolderLogic registryHolder();

    default public void setRootMinecraftRegistry(class_2378<class_2378<?>> registry) {
        this.registryHolder().setRootMinecraftRegistry(registry);
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable InitialRegistryData<T> defaultValues, boolean isDynamic, @Nullable BiConsumer<class_5321<T>, T> callback, boolean replace) {
        return this.registryHolder().createRegistry(type, defaultValues, this.registryHolder().registrySupplier(isDynamic, callback), replace);
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues, boolean isDynamic) {
        return this.createRegistry(type, InitialRegistryData.noIds(defaultValues), isDynamic, null, false);
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader) {
        return this.createRegistry(type, loader, false);
    }

    default public <T> Registry<T> createFrozenRegistry(RegistryType<T> type, RegistryLoader<T> loader) {
        Registry<T> registry = this.createRegistry(type, loader, false);
        if (registry instanceof class_2370) {
            class_2370 toFreeze = (class_2370)registry;
            toFreeze.method_40276();
        }
        return registry;
    }

    default public <T> Registry<T> createOrReplaceFrozenRegistry(RegistryType<T> type, RegistryLoader<T> loader) {
        Registry<T> registry = this.createRegistry(type, loader, false, null, true);
        if (registry instanceof class_2370) {
            class_2370 toFreeze = (class_2370)registry;
            toFreeze.method_40276();
        }
        return registry;
    }

    default public <T> Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader, boolean isDynamic) {
        return this.createRegistry(type, loader, isDynamic, null, false);
    }

    default public Stream<Registry<?>> streamRegistries(ResourceKey root) {
        return this.registryHolder().streamRegistries(Objects.requireNonNull(root, "root"));
    }

    default public <T> Optional<Registry<T>> findRegistry(RegistryType<T> type) {
        return this.registryHolder().findRegistry(Objects.requireNonNull(type, "type"));
    }

    default public <T> Registry<T> registry(RegistryType<T> type) {
        return this.registryHolder().registry(Objects.requireNonNull(type, "type"));
    }
}

