/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.registry.SpongeDefaultedRegistryReference;
import org.spongepowered.common.registry.SpongeRegistryReference;

public class SpongeRegistryKey<T>
implements RegistryKey<T> {
    private final RegistryType<T> registry;
    private final ResourceKey location;

    public SpongeRegistryKey(RegistryType<T> registry, ResourceKey location) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.location = Objects.requireNonNull(location, "location");
    }

    public final RegistryType<T> registry() {
        return this.registry;
    }

    public final ResourceKey location() {
        return this.location;
    }

    public final RegistryReference<T> asReference() {
        return new SpongeRegistryReference(this);
    }

    public final <V extends T> DefaultedRegistryReference<V> asDefaultedReference(Supplier<RegistryHolder> defaultHolder) {
        return new SpongeDefaultedRegistryReference(this, defaultHolder);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.location);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeRegistryKey other = (SpongeRegistryKey)o;
        return this.registry.equals(other.registry) && this.location.equals((Object)other.location);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("registry='" + String.valueOf(this.registry) + "'").add("location='" + String.valueOf(this.location) + "'").toString();
    }

    public static final class FactoryImpl
    implements RegistryKey.Factory {
        public <T> RegistryKey<T> of(RegistryType<T> registry, ResourceKey location) {
            return new SpongeRegistryKey<T>(Objects.requireNonNull(registry, "registry"), Objects.requireNonNull(location, "location"));
        }
    }
}

