/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.common.registry.SpongeRegistryKey;

public class SpongeRegistryReference<T>
extends SpongeRegistryKey<T>
implements RegistryReference<T> {
    public SpongeRegistryReference(RegistryKey<T> key) {
        super(Objects.requireNonNull(key, "key").registry(), key.location());
    }

    public T get(RegistryHolder ... holders) {
        for (RegistryHolder holder : Objects.requireNonNull(holders, "holders")) {
            Registry registry = holder.findRegistry(this.registry()).orElse(null);
            if (registry == null) continue;
            return (T)registry.value(this.location());
        }
        throw new ValueNotFoundException(String.format("No value found for key '%s'", this.location()));
    }

    public Optional<T> find(RegistryHolder ... holders) {
        for (RegistryHolder holder : Objects.requireNonNull(holders, "holders")) {
            Registry registry = holder.findRegistry(this.registry()).orElse(null);
            if (registry == null) continue;
            return registry.findValue(this.location());
        }
        return Optional.empty();
    }

    public static final class FactoryImpl
    implements RegistryReference.Factory {
        public <T> RegistryReference<T> referenced(RegistryHolder holder, RegistryType<T> registry, T value) {
            ResourceKey key = Objects.requireNonNull(holder, "holder").registry(Objects.requireNonNull(registry, "registry")).valueKey(Objects.requireNonNull(value, "value"));
            return new SpongeRegistryReference<T>(new SpongeRegistryKey<T>(registry, key));
        }
    }
}

