/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.registry.SpongeDefaultedRegistryType;

public class SpongeRegistryType<T>
implements RegistryType<T> {
    private final ResourceKey root;
    private final ResourceKey location;

    public SpongeRegistryType(ResourceKey root, ResourceKey location) {
        this.root = Objects.requireNonNull(root, "root");
        this.location = Objects.requireNonNull(location, "location");
    }

    public final ResourceKey root() {
        return this.root;
    }

    public final ResourceKey location() {
        return this.location;
    }

    public final <V extends T> DefaultedRegistryType<V> asDefaultedType(Supplier<RegistryHolder> defaultHolder) {
        return new SpongeDefaultedRegistryType(this.root, this.location, Objects.requireNonNull(defaultHolder, "defaultHolder"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpongeRegistryType)) {
            return false;
        }
        SpongeRegistryType other = (SpongeRegistryType)o;
        return Objects.equals(this.root, other.root) && Objects.equals(this.location, other.location);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.location);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("root=" + String.valueOf(this.root)).add("location='" + String.valueOf(this.location) + "'").toString();
    }

    public static final class FactoryImpl
    implements RegistryType.Factory {
        public <T> RegistryType<T> create(ResourceKey root, ResourceKey location) {
            Objects.requireNonNull(root, "root");
            Objects.requireNonNull(location, "location");
            return new SpongeRegistryType(root, location);
        }
    }
}

