/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.loader;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_2168;
import net.minecraft.class_2178;
import net.minecraft.class_2179;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2232;
import net.minecraft.class_2233;
import net.minecraft.class_2245;
import net.minecraft.class_2257;
import net.minecraft.class_2270;
import net.minecraft.class_2274;
import net.minecraft.class_2277;
import net.minecraft.class_2287;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2321;
import net.minecraft.class_2326;
import net.minecraft.class_2327;
import net.minecraft.class_2330;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4461;
import net.minecraft.class_5242;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionType;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionTypes;
import org.spongepowered.api.command.parameter.managed.operator.Operator;
import org.spongepowered.api.command.parameter.managed.operator.Operators;
import org.spongepowered.api.command.parameter.managed.standard.ResourceKeyedValueParameters;
import org.spongepowered.api.command.registrar.CommandRegistrarType;
import org.spongepowered.api.command.registrar.tree.CommandCompletionProvider;
import org.spongepowered.api.command.registrar.tree.CommandCompletionProviders;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorSortAlgorithms;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.command.selector.SelectorTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.commands.arguments.DimensionArgumentAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.command.brigadier.argument.ClientNativeArgumentParser;
import org.spongepowered.common.command.parameter.managed.clientcompletion.SpongeClientCompletionType;
import org.spongepowered.common.command.parameter.managed.operator.SpongeAdditionOperator;
import org.spongepowered.common.command.parameter.managed.operator.SpongeDivisionOperator;
import org.spongepowered.common.command.parameter.managed.operator.SpongeMaxOperator;
import org.spongepowered.common.command.parameter.managed.operator.SpongeMinOperator;
import org.spongepowered.common.command.parameter.managed.operator.SpongeModulusOperator;
import org.spongepowered.common.command.parameter.managed.operator.SpongeMultiplicationOperator;
import org.spongepowered.common.command.parameter.managed.operator.SpongeOperator;
import org.spongepowered.common.command.parameter.managed.operator.SpongeSubtractionOperator;
import org.spongepowered.common.command.parameter.managed.standard.SpongeBigDecimalValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeBigIntegerValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeColorValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeDataContainerValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeDateTimeValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeDurationValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeGameProfileValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeIPAddressValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeNoneValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeOperatorValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongePluginContainerValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeServerLocationValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeTargetBlockValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeTargetEntityValueParameter;
import org.spongepowered.common.command.parameter.managed.standard.SpongeUserValueParameter;
import org.spongepowered.common.command.registrar.BrigadierCommandRegistrar;
import org.spongepowered.common.command.registrar.SpongeCommandRegistrarTypes;
import org.spongepowered.common.command.registrar.SpongeParameterizedCommandRegistrar;
import org.spongepowered.common.command.registrar.SpongeRawCommandRegistrar;
import org.spongepowered.common.command.registrar.tree.key.SpongeAmountCommandTreeNodeType;
import org.spongepowered.common.command.registrar.tree.key.SpongeBasicCommandTreeNodeType;
import org.spongepowered.common.command.registrar.tree.key.SpongeEntityCommandTreeNodeType;
import org.spongepowered.common.command.registrar.tree.key.SpongeRangeCommandTreeNodeType;
import org.spongepowered.common.command.registrar.tree.key.SpongeStringCommandTreeNodeType;
import org.spongepowered.common.command.selector.SpongeSelectorSortAlgorithm;
import org.spongepowered.common.command.selector.SpongeSelectorType;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.registry.RegistryLoader;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector2d;
import org.spongepowered.math.vector.Vector3d;

public final class CommandRegistryLoader {
    public static RegistryLoader<ValueParameter<?>> valueParameter(class_7157 cbCtx) {
        return RegistryLoader.of(l -> {
            l.add(ResourceKeyedValueParameters.BIG_DECIMAL, SpongeBigDecimalValueParameter::new);
            l.add(ResourceKeyedValueParameters.BIG_INTEGER, SpongeBigIntegerValueParameter::new);
            l.add(ResourceKeyedValueParameters.BLOCK_STATE, k -> ClientNativeArgumentParser.createConverter(k, class_2257.method_9653((class_7157)cbCtx), (reader, cause, state) -> (BlockState)state.method_9494()));
            l.add(ResourceKeyedValueParameters.BOOLEAN, k -> ClientNativeArgumentParser.createIdentity(k, BoolArgumentType.bool()));
            l.add(ResourceKeyedValueParameters.COLOR, SpongeColorValueParameter::new);
            l.add(ResourceKeyedValueParameters.DATA_CONTAINER, SpongeDataContainerValueParameter::new);
            l.add(ResourceKeyedValueParameters.DATE_TIME, SpongeDateTimeValueParameter::new);
            l.add(ResourceKeyedValueParameters.DOUBLE, k -> ClientNativeArgumentParser.createIdentity(k, DoubleArgumentType.doubleArg()));
            l.add(ResourceKeyedValueParameters.DURATION, SpongeDurationValueParameter::new);
            l.add(ResourceKeyedValueParameters.ENTITY, k -> ClientNativeArgumentParser.createConverter(k, class_2186.method_9309(), (reader, cause, selector) -> (Entity)selector.method_9809((class_2168)cause)));
            l.add(ResourceKeyedValueParameters.GAME_PROFILE, SpongeGameProfileValueParameter::new);
            l.add(ResourceKeyedValueParameters.INTEGER, k -> ClientNativeArgumentParser.createIdentity(k, IntegerArgumentType.integer()));
            l.add(ResourceKeyedValueParameters.IP, SpongeIPAddressValueParameter::new);
            l.add(ResourceKeyedValueParameters.ITEM_STACK_SNAPSHOT, k -> ClientNativeArgumentParser.createConverter(k, class_2287.method_9776((class_7157)cbCtx), (reader, cause, converter) -> new SpongeItemStackSnapshot((ItemStack)converter.method_9781(1, true))));
            l.add(ResourceKeyedValueParameters.LOCATION, SpongeServerLocationValueParameter::new);
            l.add(ResourceKeyedValueParameters.LONG, k -> ClientNativeArgumentParser.createIdentity(k, LongArgumentType.longArg()));
            l.add(ResourceKeyedValueParameters.MANY_ENTITIES, k -> ClientNativeArgumentParser.createConverter(k, class_2186.method_9306(), (reader, cause, selector) -> selector.method_9816((class_2168)cause).stream().map(x -> (Entity)x).collect(Collectors.toList())));
            l.add(ResourceKeyedValueParameters.MANY_GAME_PROFILES, k -> ClientNativeArgumentParser.createConverter(k, class_2191.method_9329(), (reader, cause, converter) -> converter.getNames((class_2168)cause)));
            l.add(ResourceKeyedValueParameters.MANY_PLAYERS, k -> ClientNativeArgumentParser.createConverter(k, class_2186.method_9308(), (reader, cause, selector) -> selector.method_9813((class_2168)cause)));
            l.add(ResourceKeyedValueParameters.NONE, SpongeNoneValueParameter::new);
            l.add(ResourceKeyedValueParameters.OPERATOR, SpongeOperatorValueParameter::new);
            l.add(ResourceKeyedValueParameters.PLAYER, k -> ClientNativeArgumentParser.createConverter(k, class_2186.method_9305(), (reader, cause, selector) -> (Player)selector.method_9811((class_2168)cause)));
            l.add(ResourceKeyedValueParameters.PLUGIN, SpongePluginContainerValueParameter::new);
            l.add(ResourceKeyedValueParameters.REMAINING_JOINED_STRINGS, k -> ClientNativeArgumentParser.createIdentity(k, StringArgumentType.greedyString()));
            l.add(ResourceKeyedValueParameters.RESOURCE_KEY, k -> ClientNativeArgumentParser.createConverter(k, class_2232.method_9441(), (reader, cause, resourceLocation) -> (ResourceKey)resourceLocation));
            l.add(ResourceKeyedValueParameters.ROTATION, k -> ClientNativeArgumentParser.createConverter(k, class_2270.method_9717(), (reader, cause, coords) -> {
                class_241 rotation = coords.method_9709((class_2168)cause);
                return new Vector3d(rotation.field_1343, rotation.field_1342, 0.0f);
            }));
            l.add(ResourceKeyedValueParameters.STRING, k -> ClientNativeArgumentParser.createIdentity(k, StringArgumentType.string()));
            l.add(ResourceKeyedValueParameters.TARGET_BLOCK, SpongeTargetBlockValueParameter::new);
            l.add(ResourceKeyedValueParameters.TARGET_ENTITY, k -> new SpongeTargetEntityValueParameter((ResourceKey)k, false));
            l.add(ResourceKeyedValueParameters.TARGET_PLAYER, k -> new SpongeTargetEntityValueParameter((ResourceKey)k, true));
            l.add(ResourceKeyedValueParameters.TEXT_FORMATTING_CODE, k -> ClientNativeArgumentParser.createConverter(k, StringArgumentType.string(), (reader, cause, result) -> LegacyComponentSerializer.legacyAmpersand().deserialize(result)));
            l.add(ResourceKeyedValueParameters.TEXT_FORMATTING_CODE_ALL, k -> ClientNativeArgumentParser.createConverter(k, StringArgumentType.greedyString(), (reader, cause, result) -> LegacyComponentSerializer.legacyAmpersand().deserialize(result)));
            l.add(ResourceKeyedValueParameters.TEXT_JSON, k -> ClientNativeArgumentParser.createConverter(k, class_2178.method_9281((class_7157)cbCtx), (reader, cause, result) -> SpongeAdventure.asAdventure(result)));
            l.add(ResourceKeyedValueParameters.TEXT_JSON_ALL, k -> ClientNativeArgumentParser.createConverter(k, StringArgumentType.greedyString(), (reader, cause, result) -> GsonComponentSerializer.gson().deserialize(result)));
            l.add(ResourceKeyedValueParameters.URL, k -> ClientNativeArgumentParser.createConverter(k, StringArgumentType.string(), (reader, cause, input) -> {
                try {
                    return new URL((String)input);
                }
                catch (MalformedURLException ex) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Could not parse " + input + " as a URL"))).createWithContext((ImmutableStringReader)reader);
                }
            }));
            l.add(ResourceKeyedValueParameters.USER, SpongeUserValueParameter::new);
            l.add(ResourceKeyedValueParameters.UUID, k -> ClientNativeArgumentParser.createIdentity(k, class_5242.method_27643()));
            l.add(ResourceKeyedValueParameters.VECTOR2D, k -> ClientNativeArgumentParser.createConverter(k, class_2274.method_9723(), (reader, cause, result) -> {
                class_243 r = result.method_9708((class_2168)cause);
                return new Vector2d(r.field_1352, r.field_1350);
            }));
            l.add(ResourceKeyedValueParameters.VECTOR3D, k -> ClientNativeArgumentParser.createConverter(k, class_2277.method_9735((boolean)false), (reader, cause, result) -> VecHelper.toVector3d(result.method_9708((class_2168)cause))));
            l.add(ResourceKeyedValueParameters.WORLD, k -> ClientNativeArgumentParser.createConverter(k, class_2181.method_9288(), (reader, cause, result) -> (ServerWorld)Sponge.server().worldManager().world((ResourceKey)result).orElseThrow(() -> DimensionArgumentAccessor.accessor$ERROR_INVALID_VALUE().createWithContext((ImmutableStringReader)reader, result))));
        });
    }

    public static RegistryLoader<ClientCompletionType> clientCompletionType() {
        return RegistryLoader.of(l -> {
            l.add(ClientCompletionTypes.DECIMAL_NUMBER, k -> new SpongeClientCompletionType((ArgumentType<?>)DoubleArgumentType.doubleArg()));
            l.add(ClientCompletionTypes.SNBT, k -> new SpongeClientCompletionType((ArgumentType<?>)class_2179.method_9284()));
            l.add(ClientCompletionTypes.NONE, k -> SpongeClientCompletionType.NONE);
            l.add(ClientCompletionTypes.RESOURCE_KEY, k -> new SpongeClientCompletionType((ArgumentType<?>)class_2232.method_9441()));
            l.add(ClientCompletionTypes.STRING, k -> new SpongeClientCompletionType((ArgumentType<?>)StringArgumentType.string()));
            l.add(ClientCompletionTypes.WHOLE_NUMBER, k -> new SpongeClientCompletionType((ArgumentType<?>)LongArgumentType.longArg()));
        });
    }

    public static RegistryLoader<CommandCompletionProvider> clientSuggestionProvider() {
        return RegistryLoader.of(l -> {
            l.add(CommandCompletionProviders.AVAILABLE_SOUNDS, k -> (CommandCompletionProvider)class_2321.field_10934);
            l.add(CommandCompletionProviders.SUMMONABLE_ENTITIES, k -> (CommandCompletionProvider)class_2321.field_10935);
        });
    }

    public static RegistryLoader<CommandTreeNodeType<?>> clientCompletionKey(class_7157 cbCtx) {
        Function<ResourceKey, ArgumentType> fn = key -> CommandRegistryLoader.argumentTypeFromKey(key, cbCtx);
        return RegistryLoader.of(l -> {
            l.add(CommandTreeNodeTypes.BOOL, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.FLOAT, k -> SpongeRangeCommandTreeNodeType.createFrom(k, new class_2327()));
            l.add(CommandTreeNodeTypes.DOUBLE, k -> SpongeRangeCommandTreeNodeType.createFrom(k, new class_2326()));
            l.add(CommandTreeNodeTypes.INTEGER, k -> SpongeRangeCommandTreeNodeType.createFrom(k, new class_2330()));
            l.add(CommandTreeNodeTypes.LONG, k -> SpongeRangeCommandTreeNodeType.createFrom(k, new class_4461()));
            l.add(CommandTreeNodeTypes.STRING, SpongeStringCommandTreeNodeType::new);
            l.add(CommandTreeNodeTypes.ENTITY, SpongeEntityCommandTreeNodeType::new);
            l.add(CommandTreeNodeTypes.GAME_PROFILE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.BLOCK_POS, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.COLUMN_POS, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.VEC3, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.VEC2, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.BLOCK_STATE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.BLOCK_PREDICATE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.ITEM_STACK, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.ITEM_PREDICATE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.COLOR, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.COMPONENT, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.MESSAGE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.NBT_COMPOUND_TAG, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.NBT_TAG, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.NBT_PATH, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.OBJECTIVE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.OBJECTIVE_CRITERIA, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.OPERATION, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.PARTICLE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.ANGLE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.ROTATION, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.SCOREBOARD_SLOT, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.SCORE_HOLDER, k -> new SpongeAmountCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)class_2233.method_9447(), (ArgumentType<?>)class_2233.method_9451()));
            l.add(CommandTreeNodeTypes.SWIZZLE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.TEAM, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.ITEM_SLOT, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.RESOURCE_LOCATION, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.FUNCTION, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.ENTITY_ANCHOR, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.INT_RANGE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.FLOAT_RANGE, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.DIMENSION, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
            l.add(CommandTreeNodeTypes.TIME, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)class_2245.method_9489()));
            l.add(CommandTreeNodeTypes.UUID, k -> new SpongeBasicCommandTreeNodeType((ResourceKey)k, (ArgumentType<?>)((ArgumentType)fn.apply((ResourceKey)k))));
        });
    }

    public static RegistryLoader<CommandRegistrarType<?>> commandRegistrarType() {
        return RegistryLoader.of(l -> {
            l.add(SpongeCommandRegistrarTypes.BRIGADIER, () -> BrigadierCommandRegistrar.TYPE);
            l.add(SpongeCommandRegistrarTypes.MANAGED, () -> SpongeParameterizedCommandRegistrar.TYPE);
            l.add(SpongeCommandRegistrarTypes.RAW, () -> SpongeRawCommandRegistrar.TYPE);
        });
    }

    static ArgumentType<?> argumentTypeFromKey(ResourceKey key, class_7157 ctx) {
        class_2314 argumentTypeInfo = (class_2314)class_7923.field_41192.method_63535((class_2960)key);
        if (argumentTypeInfo instanceof class_2319) {
            class_2319 s = (class_2319)argumentTypeInfo;
            return s.method_42002(null).method_41730(ctx);
        }
        throw new IllegalArgumentException(key.asString());
    }

    public static RegistryLoader<Operator> operator() {
        return RegistryLoader.of(l -> {
            l.add(Operators.ADDITION, SpongeAdditionOperator::new);
            l.add(Operators.ASSIGN, () -> new SpongeOperator("="));
            l.add(Operators.DIVISION, SpongeDivisionOperator::new);
            l.add(Operators.MAX, SpongeMinOperator::new);
            l.add(Operators.MIN, SpongeMaxOperator::new);
            l.add(Operators.MODULUS, SpongeModulusOperator::new);
            l.add(Operators.MULTIPLICATION, SpongeMultiplicationOperator::new);
            l.add(Operators.SUBTRACTION, SpongeSubtractionOperator::new);
            l.add(Operators.SWAP, () -> new SpongeOperator("><"));
        });
    }

    public static RegistryLoader<SelectorSortAlgorithm> selectorSortAlgorithm() {
        return RegistryLoader.of(l -> {
            l.add(SelectorSortAlgorithms.ORDER_ARBITRARY, k -> new SpongeSelectorSortAlgorithm(class_2300.field_41524));
            l.add(SelectorSortAlgorithms.ORDER_FURTHEST, k -> new SpongeSelectorSortAlgorithm(class_2303.field_10882));
            l.add(SelectorSortAlgorithms.ORDER_NEAREST, k -> new SpongeSelectorSortAlgorithm(class_2303.field_10869));
            l.add(SelectorSortAlgorithms.ORDER_RANDOM, k -> new SpongeSelectorSortAlgorithm(class_2303.field_10850));
        });
    }

    public static RegistryLoader<SelectorType> selectorType() {
        return RegistryLoader.of(l -> {
            l.add(SelectorTypes.ALL_ENTITIES, k -> new SpongeSelectorType("@e"));
            l.add(SelectorTypes.ALL_PLAYERS, k -> new SpongeSelectorType("@a"));
            l.add(SelectorTypes.NEAREST_PLAYER, k -> new SpongeSelectorType("@p"));
            l.add(SelectorTypes.RANDOM_PLAYER, k -> new SpongeSelectorType("@r"));
            l.add(SelectorTypes.SOURCE, k -> new SpongeSelectorType("@s"));
        });
    }
}

