/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.loader;

import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1311;
import net.minecraft.class_1322;
import net.minecraft.class_1438;
import net.minecraft.class_1440;
import net.minecraft.class_1453;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1474;
import net.minecraft.class_1501;
import net.minecraft.class_1527;
import net.minecraft.class_1593;
import net.minecraft.class_1617;
import net.minecraft.class_1659;
import net.minecraft.class_1665;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1767;
import net.minecraft.class_1814;
import net.minecraft.class_189;
import net.minecraft.class_1927;
import net.minecraft.class_1934;
import net.minecraft.class_1944;
import net.minecraft.class_1953;
import net.minecraft.class_1959;
import net.minecraft.class_2370;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_270;
import net.minecraft.class_2737;
import net.minecraft.class_2738;
import net.minecraft.class_274;
import net.minecraft.class_2745;
import net.minecraft.class_2747;
import net.minecraft.class_2750;
import net.minecraft.class_2760;
import net.minecraft.class_2764;
import net.minecraft.class_2766;
import net.minecraft.class_2768;
import net.minecraft.class_2771;
import net.minecraft.class_2773;
import net.minecraft.class_2776;
import net.minecraft.class_2778;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3765;
import net.minecraft.class_3867;
import net.minecraft.class_4019;
import net.minecraft.class_4763;
import net.minecraft.class_4778;
import net.minecraft.class_5000;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5691;
import net.minecraft.class_5705;
import net.minecraft.class_5816;
import net.minecraft.class_8107;
import net.minecraft.class_8108;
import net.minecraft.class_811;
import net.minecraft.class_8113;
import net.minecraft.class_8646;
import net.minecraft.class_8967;
import net.minecraft.class_9206;
import net.minecraft.class_9283;
import net.minecraft.class_9886;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.type.ItemTier;
import org.spongepowered.api.data.type.ItemTiers;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.criteria.Criteria;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.common.accessor.world.entity.boss.enderdragon.phases.EnderDragonPhaseAccessor;
import org.spongepowered.common.accessor.world.level.GameRulesAccessor;
import org.spongepowered.common.registry.RegistryLoader;
import org.spongepowered.common.registry.SpongeRegistryHolder;

public final class VanillaRegistryLoader {
    private final SpongeRegistryHolder holder;

    public static void load(SpongeRegistryHolder holder) {
        VanillaRegistryLoader loader = new VanillaRegistryLoader(holder);
        loader.loadEnumRegistries();
        loader.loadInstanceRegistries();
    }

    private VanillaRegistryLoader(SpongeRegistryHolder holder) {
        this.holder = holder;
    }

    private void loadInstanceRegistries() {
        this.holder.createRegistry(RegistryTypes.CRITERION, VanillaRegistryLoader.criterion());
        this.manualOrAutomaticName((RegistryType)RegistryTypes.DRAGON_PHASE_TYPE, (I[])EnderDragonPhaseAccessor.accessor$PHASES(), map -> {
            map.put(class_1527.field_7069, "holding_pattern");
            map.put(class_1527.field_7076, "strafe_player");
            map.put(class_1527.field_7071, "landing_approach");
            map.put(class_1527.field_7067, "landing");
            map.put(class_1527.field_7077, "takeoff");
            map.put(class_1527.field_7072, "sitting_flaming");
            map.put(class_1527.field_7081, "sitting_scanning");
            map.put(class_1527.field_7073, "sitting_attacking");
            map.put(class_1527.field_7078, "charging_player");
            map.put(class_1527.field_7068, "dying");
            map.put(class_1527.field_7075, "hover");
        }, (Function)phase -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ((EnderDragonPhaseAccessor)phase).accessor$name()));
        this.holder.createRegistry(RegistryTypes.FIREWORK_SHAPE, VanillaRegistryLoader.fireworkShape());
        HashMap<class_1741, String> materials = new HashMap<class_1741, String>();
        materials.put(class_1740.field_7897, class_1740.field_7897.comp_3168().toString());
        materials.put(class_1740.field_7887, class_1740.field_7887.comp_3168().toString());
        materials.put(class_1740.field_7892, class_1740.field_7892.comp_3168().toString());
        materials.put(class_1740.field_7895, class_1740.field_7895.comp_3168().toString());
        materials.put(class_1740.field_7889, class_1740.field_7889.comp_3168().toString());
        materials.put(class_1740.field_7890, ResourceKey.minecraft((String)"turtle").toString());
        materials.put(class_1740.field_21977, class_1740.field_21977.comp_3168().toString());
        materials.put(class_1740.field_48846, class_1740.field_48846.comp_3168().toString().replace("_scute", ""));
        this.naming((RegistryType)RegistryTypes.ARMOR_MATERIAL, (I[])materials.keySet().toArray(new class_1741[0]), (Map)materials);
        this.knownName((RegistryType)RegistryTypes.GAME_RULE, (Collection)GameRulesAccessor.accessor$GAME_RULE_TYPES().keySet(), (Function)rule -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, rule.method_20771()));
        this.holder.createRegistry(RegistryTypes.ITEM_TIER, VanillaRegistryLoader.itemTier());
    }

    private void loadEnumRegistries() {
        this.automaticName((RegistryType)RegistryTypes.ATTACHMENT_SURFACE, (Enum[])class_2738.values());
        this.automaticName((RegistryType)RegistryTypes.BAMBOO_LEAVES_TYPE, (Enum[])class_2737.values());
        this.automaticName((RegistryType)RegistryTypes.BELL_ATTACHMENT_TYPE, (Enum[])class_3867.values());
        this.manualName((RegistryType)RegistryTypes.ATTRIBUTE_OPERATION, (Enum[])class_1322.class_1323.values(), map -> {
            map.put(class_1322.class_1323.field_6328, "addition");
            map.put(class_1322.class_1323.field_6330, "multiply_base");
            map.put(class_1322.class_1323.field_6331, "multiply_total");
        });
        this.automaticName((RegistryType)RegistryTypes.CHEST_ATTACHMENT_TYPE, (Enum[])class_2745.values());
        this.automaticName((RegistryType)RegistryTypes.COLLISION_RULE, (Enum[])class_270.class_271.values());
        this.automaticName((RegistryType)RegistryTypes.COMPARATOR_MODE, (Enum[])class_2747.values());
        this.automaticName((RegistryType)RegistryTypes.DIFFICULTY, (Enum[])class_1267.values());
        this.automaticName((RegistryType)RegistryTypes.DYE_COLOR, (Enum[])class_1767.values());
        this.automaticName((RegistryType)RegistryTypes.DOOR_HINGE, (Enum[])class_2750.values());
        this.automaticName((RegistryType)RegistryTypes.DRIPSTONE_SEGMENT, (Enum[])class_5691.values());
        this.automaticName((RegistryType)RegistryTypes.EQUIPMENT_GROUP, (Enum[])class_1304.class_1305.values());
        this.automaticName((RegistryType)RegistryTypes.EQUIPMENT_TYPE, (Enum[])class_1304.values());
        this.automaticName((RegistryType)RegistryTypes.FOX_TYPE, (Enum[])class_4019.class_4039.values());
        this.automaticName((RegistryType)RegistryTypes.GAME_MODE, (Enum[])class_1934.values());
        this.automaticName((RegistryType)RegistryTypes.HAND_PREFERENCE, (Enum[])class_1306.values());
        this.automaticName((RegistryType)RegistryTypes.HAND_TYPE, (Enum[])class_1268.values());
        this.automaticName((RegistryType)RegistryTypes.INSTRUMENT_TYPE, (Enum[])class_2766.values());
        this.automaticName((RegistryType)RegistryTypes.ITEM_RARITY, (Enum[])class_1814.values());
        this.automaticName((RegistryType)RegistryTypes.JIGSAW_BLOCK_ORIENTATION, (Enum[])class_5000.values());
        this.automaticName((RegistryType)RegistryTypes.MOOSHROOM_TYPE, (Enum[])class_1438.class_4053.values());
        this.automaticName((RegistryType)RegistryTypes.OBJECTIVE_DISPLAY_MODE, (Enum[])class_274.class_275.values());
        this.automaticName((RegistryType)RegistryTypes.PANDA_GENE, (Enum[])class_1440.class_1443.values());
        this.automaticName((RegistryType)RegistryTypes.PHANTOM_PHASE, (Enum[])class_1593.class_1594.values());
        this.automaticName((RegistryType)RegistryTypes.PICKUP_RULE, (Enum[])class_1665.class_1666.values());
        this.automaticName((RegistryType)RegistryTypes.MIRROR, (Enum[])class_2415.values());
        this.automaticName((RegistryType)RegistryTypes.CHAT_VISIBILITY, (Enum[])class_1659.values());
        this.automaticName((RegistryType)RegistryTypes.PISTON_TYPE, (Enum[])class_2764.values());
        this.automaticName((RegistryType)RegistryTypes.PORTION_TYPE, (Enum[])class_2760.values());
        this.automaticName((RegistryType)RegistryTypes.RAID_STATUS, (Enum[])class_3765.class_4259.values());
        this.automaticName((RegistryType)RegistryTypes.ROTATION, (Enum[])class_2470.values());
        this.automaticName((RegistryType)RegistryTypes.RAIL_DIRECTION, (Enum[])class_2768.values());
        this.automaticName((RegistryType)RegistryTypes.SCULK_SENSOR_STATE, (Enum[])class_5705.values());
        this.automaticName((RegistryType)RegistryTypes.SLAB_PORTION, (Enum[])class_2771.values());
        this.automaticName((RegistryType)RegistryTypes.SPELL_TYPE, (Enum[])class_1617.class_1618.values());
        this.automaticName((RegistryType)RegistryTypes.STAIR_SHAPE, (Enum[])class_2778.values());
        this.automaticName((RegistryType)RegistryTypes.STRUCTURE_MODE, (Enum[])class_2776.values());
        this.automaticName((RegistryType)RegistryTypes.TILT, (Enum[])class_5816.values());
        this.automaticName((RegistryType)RegistryTypes.TASK_PRIORITY, (Enum[])class_1953.values());
        this.automaticName((RegistryType)RegistryTypes.VISIBILITY, (Enum[])class_270.class_272.values());
        this.automaticName((RegistryType)RegistryTypes.WIRE_ATTACHMENT_TYPE, (Enum[])class_2773.values());
        this.automaticName((RegistryType)RegistryTypes.ADVANCEMENT_TYPE, (Enum[])class_189.values());
        this.automaticName((RegistryType)RegistryTypes.TROPICAL_FISH_SHAPE, (Enum[])class_1474.class_1475.values());
        this.automaticName((RegistryType)RegistryTypes.SALMON_SIZE, (Enum[])class_1462.class_9869.values());
        this.automaticName((RegistryType)RegistryTypes.HEIGHT_TYPE, (Enum[])class_2902.class_2903.values());
        this.automaticName((RegistryType)RegistryTypes.ENTITY_CATEGORY, (Enum[])class_1311.values());
        this.automaticName((RegistryType)RegistryTypes.WALL_CONNECTION_STATE, (Enum[])class_4778.values());
        this.automaticName((RegistryType)RegistryTypes.GRASS_COLOR_MODIFIER, (Enum[])class_4763.class_5486.values());
        this.automaticName((RegistryType)RegistryTypes.PRECIPITATION, (Enum[])class_1959.class_1963.values());
        this.automaticName((RegistryType)RegistryTypes.TEMPERATURE_MODIFIER, (Enum[])class_1959.class_5484.values());
        this.automaticName((RegistryType)RegistryTypes.DECORATION_STEP, (Enum[])class_2893.class_2895.values());
        this.automaticName((RegistryType)RegistryTypes.PARROT_TYPE, (Enum[])class_1453.class_7989.values());
        this.automaticName((RegistryType)RegistryTypes.RABBIT_TYPE, (Enum[])class_1463.class_7990.values());
        this.automaticName((RegistryType)RegistryTypes.LLAMA_TYPE, (Enum[])class_1501.class_7993.values());
        this.automaticName((RegistryType)RegistryTypes.HORSE_COLOR, (Enum[])class_5149.values());
        this.automaticName((RegistryType)RegistryTypes.HORSE_STYLE, (Enum[])class_5148.values());
        this.automaticName((RegistryType)RegistryTypes.DAMAGE_SCALING, (Enum[])class_8108.values());
        this.automaticName((RegistryType)RegistryTypes.DAMAGE_EFFECT, (Enum[])class_8107.values());
        this.automaticName((RegistryType)RegistryTypes.ITEM_DISPLAY_TYPE, (Enum[])class_811.values());
        this.automaticName((RegistryType)RegistryTypes.BILLBOARD_TYPE, (Enum[])class_8113.class_8114.values());
        this.automaticName((RegistryType)RegistryTypes.TEXT_ALIGNMENT, (Enum[])class_8113.class_8123.class_8124.values());
        this.automaticName((RegistryType)RegistryTypes.LIGHT_TYPE, (Enum[])class_1944.values());
        this.automaticName((RegistryType)RegistryTypes.DISPLAY_SLOT, (Enum[])class_8646.values());
        this.automaticName((RegistryType)RegistryTypes.PUSH_REACTION, (Enum[])class_3619.values());
        this.automaticName((RegistryType)RegistryTypes.TRIAL_SPAWNER_STATE, (Enum[])class_8967.values());
        this.automaticName(RegistryTypes.VAULT_STATE, (Enum[])class_9206.values());
        this.automaticName(RegistryTypes.EXPLOSION_BLOCK_INTERACTION, (Enum[])class_1927.class_4179.values());
    }

    private static RegistryLoader<Criterion> criterion() {
        return RegistryLoader.of(l -> {
            l.add(Criteria.AIR, k -> (Criterion)class_274.field_1459);
            l.add(Criteria.ARMOR, k -> (Criterion)class_274.field_1452);
            l.add(Criteria.DEATH_COUNT, k -> (Criterion)class_274.field_1456);
            l.add(Criteria.DUMMY, k -> (Criterion)class_274.field_1468);
            l.add(Criteria.EXPERIENCE, k -> (Criterion)class_274.field_1460);
            l.add(Criteria.FOOD, k -> (Criterion)class_274.field_1464);
            l.add(Criteria.HEALTH, k -> (Criterion)class_274.field_1453);
            l.add(Criteria.LEVEL, k -> (Criterion)class_274.field_1465);
            l.add(Criteria.PLAYER_KILL_COUNT, k -> (Criterion)class_274.field_1463);
            l.add(Criteria.TOTAL_KILL_COUNT, k -> (Criterion)class_274.field_1457);
            l.add(Criteria.TRIGGER, k -> (Criterion)class_274.field_1462);
        });
    }

    private static RegistryLoader<FireworkShape> fireworkShape() {
        return RegistryLoader.of(l -> {
            l.addWithId(class_9283.class_1782.field_7976.method_7816(), FireworkShapes.SMALL_BALL, () -> (FireworkShape)class_9283.class_1782.field_7976);
            l.addWithId(class_9283.class_1782.field_7977.method_7816(), FireworkShapes.LARGE_BALL, () -> (FireworkShape)class_9283.class_1782.field_7977);
            l.addWithId(class_9283.class_1782.field_7973.method_7816(), FireworkShapes.STAR, () -> (FireworkShape)class_9283.class_1782.field_7973);
            l.addWithId(class_9283.class_1782.field_7974.method_7816(), FireworkShapes.CREEPER, () -> (FireworkShape)class_9283.class_1782.field_7974);
            l.addWithId(class_9283.class_1782.field_7970.method_7816(), FireworkShapes.BURST, () -> (FireworkShape)class_9283.class_1782.field_7970);
        });
    }

    private static RegistryLoader<ItemTier> itemTier() {
        return RegistryLoader.of(l -> {
            l.add(ItemTiers.DIAMOND, k -> (ItemTier)class_9886.field_52588);
            l.add(ItemTiers.GOLD, k -> (ItemTier)class_9886.field_52589);
            l.add(ItemTiers.IRON, k -> (ItemTier)class_9886.field_52587);
            l.add(ItemTiers.NETHERITE, k -> (ItemTier)class_9886.field_52590);
            l.add(ItemTiers.STONE, k -> (ItemTier)class_9886.field_52586);
            l.add(ItemTiers.WOOD, k -> (ItemTier)class_9886.field_52585);
        });
    }

    private <A, I extends Enum<I>> Registry<A> automaticName(RegistryType<A> type, I[] values) {
        Function<Enum, String> keyFunction = i -> {
            String string;
            if (i instanceof class_3542) {
                class_3542 s = (class_3542)i;
                string = s.method_15434();
            } else {
                string = i.name();
            }
            return string;
        };
        return this.naming((RegistryType)type, (Enum[])values, keyFunction.andThen(i -> i.toLowerCase(Locale.ROOT)));
    }

    private <A, I> Registry<A> knownName(RegistryType<A> type, Collection<I> values, Function<I, String> name) {
        HashMap<I, String> map = new HashMap<I, String>();
        for (I value : values) {
            map.put(value, name.apply(value));
        }
        return this.naming(type, values.size(), map);
    }

    private <A, I extends Enum<I>> Registry<A> manualName(RegistryType<A> type, I[] values, Consumer<Manual<A, I>> byName) {
        HashMap map = new HashMap(values.length);
        byName.accept(map::put);
        return this.naming(type, values, map);
    }

    private <A, I> Registry<A> manualOrAutomaticName(RegistryType<A> type, I[] values, Consumer<Manual<A, I>> byName, Function<I, String> autoName) {
        HashMap<I, String> map = new HashMap<I, String>(values.length);
        byName.accept(map::put);
        for (I value : values) {
            map.computeIfAbsent(value, autoName);
        }
        return this.naming(type, values, map);
    }

    private <A, I extends Enum<I>> Registry<A> naming(RegistryType<A> type, I[] values, Function<I, String> name) {
        HashMap<I, String> map = new HashMap<I, String>();
        for (I value : values) {
            map.put(value, name.apply(value));
        }
        return this.naming(type, values, map);
    }

    private <A, I> Registry<A> naming(RegistryType<A> type, I[] values, Map<I, String> byName) {
        return this.naming(type, values.length, byName);
    }

    private <A, I> Registry<A> naming(RegistryType<A> type, int values, Map<I, String> byName) {
        if (values != byName.size()) {
            throw new IllegalStateException(String.valueOf(type.location()) + " in " + String.valueOf(type.root()) + " is has value mismatch: " + values + " / " + byName.size());
        }
        Registry<A> registry = this.holder.createRegistry(type, () -> {
            HashMap map = new HashMap();
            for (Map.Entry value : byName.entrySet()) {
                String rawId = (String)value.getValue();
                if (rawId.contains(":")) {
                    map.put((ResourceKey)class_2960.method_60654((String)rawId), value.getKey());
                    continue;
                }
                map.put(ResourceKey.sponge((String)rawId), value.getKey());
            }
            return map;
        }, false);
        if (registry instanceof class_2370) {
            class_2370 toFreeze = (class_2370)registry;
            toFreeze.method_40276();
        }
        return registry;
    }

    private static interface Manual<A, I> {
        public void put(I var1, String var2);
    }
}

