/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_7134;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.common.world.SpongeWorldTypeEffect;

public final class DimensionEffectProvider {
    public static DimensionEffectProvider INSTANCE = new DimensionEffectProvider();
    private static final SpongeWorldTypeEffect OVERWORLD = new SpongeWorldTypeEffect((ResourceKey)class_7134.field_37670);
    private static final SpongeWorldTypeEffect NETHER = new SpongeWorldTypeEffect((ResourceKey)class_7134.field_37671);
    private static final SpongeWorldTypeEffect END = new SpongeWorldTypeEffect((ResourceKey)class_7134.field_37672);
    private final Map<ResourceKey, WorldTypeEffect> mappings = new Object2ObjectOpenHashMap();

    private DimensionEffectProvider() {
    }

    public @Nullable WorldTypeEffect get(ResourceKey key) {
        return this.mappings.get(key);
    }

    public void register(ResourceKey key, WorldTypeEffect effect) {
        this.mappings.put(key, effect);
    }

    static {
        INSTANCE.register(OVERWORLD.key(), OVERWORLD);
        INSTANCE.register(NETHER.key(), NETHER);
        INSTANCE.register(END.key(), END);
    }
}

