/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.resource;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.Strings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.resource.ResourcePath;

public final class SpongeResourcePath
implements ResourcePath {
    private final ResourceKey key;
    private final @Nullable ResourcePath parent;

    public SpongeResourcePath(ResourceKey key) {
        this.key = key;
        LinkedList<String> parts = this.pathParts(this.path());
        parts.removeLast();
        this.parent = parts.isEmpty() ? null : this.withPath(parts);
    }

    public ResourceKey key() {
        return this.key;
    }

    public Optional<ResourcePath> parent() {
        return Optional.ofNullable(this.parent);
    }

    public ResourcePath resolve(String first, String ... children) {
        LinkedList<String> parts = new LinkedList<String>(this.pathParts(this.path()));
        parts.add(first);
        parts.addAll(Arrays.asList(children));
        return this.withPath(parts);
    }

    public ResourcePath resolveSibling(String sibling, String ... children) {
        LinkedList<String> parts = this.pathParts(this.path());
        parts.removeLast();
        parts.add(sibling);
        parts.addAll(Arrays.asList(children));
        return this.withPath(parts);
    }

    public String name() {
        return FilenameUtils.getName((String)this.path());
    }

    public String baseName() {
        return FilenameUtils.getBaseName((String)this.path());
    }

    public String extension() {
        return FilenameUtils.getExtension((String)this.path());
    }

    public int compareTo(@NonNull ResourcePath o) {
        return this.key.compareTo((Key)o.key());
    }

    public String toString() {
        return this.key.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpongeResourcePath)) {
            return false;
        }
        SpongeResourcePath that = (SpongeResourcePath)o;
        return this.key.equals((Object)that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    private ResourcePath withPath(List<String> parts) {
        String path = parts.stream().map(FilenameUtils::separatorsToUnix).flatMap(s -> this.pathParts((String)s).stream()).filter(Strings::isNotEmpty).collect(Collectors.joining("/"));
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path is empty!");
        }
        try {
            return ResourcePath.of((String)this.namespace(), (String)path);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private LinkedList<String> pathParts(String path) {
        return new LinkedList<String>(Arrays.asList(path.split("/")));
    }

    public static final class FactoryImpl
    implements ResourcePath.Factory {
        public ResourcePath of(ResourceKey key) {
            return new SpongeResourcePath(Objects.requireNonNull(key, "key"));
        }
    }
}

