/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeScore;

public final class SpongeObjective
implements Objective {
    private final String name;
    private final Criterion criterion;
    private final Map<String, Score> scores = new HashMap<String, Score>();
    private final Set<class_269> scoreboards = new HashSet<class_269>();
    private Component displayName;
    private ObjectiveDisplayMode displayMode;
    private boolean displayAutoUpdate;
    private class_9022 numberFormat;

    public SpongeObjective(String name, Criterion criterion) {
        this.name = name;
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(name);
        this.displayMode = (ObjectiveDisplayMode)ObjectiveDisplayModes.INTEGER.get();
        this.criterion = criterion;
    }

    public static SpongeObjective fromVanilla(class_266 mcObjective) {
        SpongeObjective objective = new SpongeObjective(mcObjective.method_1113(), (Criterion)mcObjective.method_1116());
        objective.setDisplayMode((ObjectiveDisplayMode)mcObjective.method_1118());
        objective.setDisplayName(SpongeAdventure.asAdventure(mcObjective.method_1114()));
        objective.setDisplayAutoUpdate(mcObjective.method_55383());
        objective.setNumberFormat(mcObjective.method_55384());
        ((ObjectiveBridge)mcObjective).bridge$setSpongeObjective(objective);
        return objective;
    }

    public String name() {
        return this.name;
    }

    public Component displayName() {
        return this.displayName;
    }

    public void setDisplayName(Component displayName) throws IllegalArgumentException {
        this.displayName = displayName;
        this.updateDisplayName();
    }

    public void storeDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    public Criterion criterion() {
        return this.criterion;
    }

    public ObjectiveDisplayMode displayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
        this.updateDisplayMode();
    }

    public void storeDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public Map<String, Score> scores() {
        return new HashMap<String, Score>(this.scores);
    }

    public boolean hasScore(String name) {
        return this.scores.containsKey(name);
    }

    public void addScore(Score score) throws IllegalArgumentException {
        if (this.scores.containsKey(score.name())) {
            throw new IllegalArgumentException(String.format("A score with the name %s already exists!", score.name()));
        }
        this.scores.put(score.name(), score);
        SpongeScore spongeScore = (SpongeScore)score;
        for (class_269 scoreboard : this.scoreboards) {
            class_266 mcObjective = scoreboard.method_1170(this.name);
            class_9014 accessor = scoreboard.method_1180(spongeScore.holder, mcObjective);
            spongeScore.registerAndUpdate(mcObjective, accessor);
        }
    }

    public Optional<Score> findScore(String name) {
        return Optional.ofNullable(this.scores.get(name));
    }

    public Score findOrCreateScore(String name) {
        if (this.scores.containsKey(name)) {
            return this.scores.get(name);
        }
        SpongeScore score = new SpongeScore(name);
        this.addScore(score);
        return score;
    }

    public boolean hasScore(Entity entity) {
        return this.scores.containsKey(((class_9015)entity).method_5820());
    }

    public boolean hasScore(GameProfile profile) {
        return this.scores.containsKey(profile.name().get());
    }

    public Score findOrCreateScore(Entity entity) {
        if (this.scores.containsKey(((class_9015)entity).method_5820())) {
            return this.scores.get(((class_9015)entity).method_5820());
        }
        SpongeScore score = new SpongeScore(entity);
        this.addScore(score);
        return score;
    }

    public boolean removeScore(Entity entity) {
        Optional<Score> score = this.findScore(((class_9015)entity).method_5820());
        return score.filter(this::removeScore).isPresent();
    }

    public Score findOrCreateScore(GameProfile profile) {
        if (this.scores.containsKey(profile.name().get())) {
            return this.scores.get(profile.name().get());
        }
        SpongeScore score = new SpongeScore(profile);
        this.addScore(score);
        return score;
    }

    public boolean removeScore(GameProfile profile) {
        Optional<Score> score = this.findScore((String)profile.name().get());
        return score.filter(this::removeScore).isPresent();
    }

    public boolean removeScore(Score spongeScore) {
        if (!this.scores.containsKey(spongeScore.name())) {
            return false;
        }
        for (class_269 scoreboard : this.scoreboards) {
            ((ServerScoreboardBridge)scoreboard).bridge$removeAPIScore(this, spongeScore);
        }
        this.scores.remove(spongeScore.name());
        return true;
    }

    public boolean removeScore(String name) {
        Optional<Score> score = this.findScore(name);
        return score.filter(this::removeScore).isPresent();
    }

    public Set<Scoreboard> scoreboards() {
        return new HashSet<class_269>(this.scoreboards);
    }

    private void updateDisplayMode() {
        for (class_269 scoreboard : this.scoreboards) {
            class_266 objective = scoreboard.method_1170(this.name);
            objective.method_1115((class_274.class_275)this.displayMode);
        }
    }

    private void updateDisplayName() {
        for (class_269 scoreboard : this.scoreboards) {
            class_266 objective = scoreboard.method_1170(this.name);
            objective.method_1121(SpongeAdventure.asVanilla(this.displayName));
        }
    }

    public boolean displayAutoUpdate() {
        return this.displayAutoUpdate;
    }

    public class_9022 numberFormat() {
        return this.numberFormat;
    }

    public void setDisplayAutoUpdate(boolean displayAutoUpdate) {
        this.displayAutoUpdate = displayAutoUpdate;
    }

    public void setNumberFormat(class_9022 numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void register(class_269 scoreboard) {
        this.scoreboards.add(scoreboard);
    }

    public void unregister(class_269 scoreboard) {
        this.scoreboards.remove(scoreboard);
    }

    public static final class Builder
    implements Objective.Builder {
        private @Nullable String name;
        private @Nullable Component displayName;
        private @Nullable Criterion criterion;
        private @Nullable ObjectiveDisplayMode objectiveDisplayMode;

        public Objective.Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Objective.Builder displayName(Component displayName) {
            this.displayName = Objects.requireNonNull(displayName);
            return this;
        }

        public Objective.Builder criterion(Criterion criterion) {
            this.criterion = Objects.requireNonNull(criterion);
            return this;
        }

        public Objective.Builder objectiveDisplayMode(ObjectiveDisplayMode objectiveDisplayMode) {
            this.objectiveDisplayMode = Objects.requireNonNull(objectiveDisplayMode);
            return this;
        }

        public Objective.Builder from(Objective value) {
            Objects.requireNonNull(value);
            this.name = value.name();
            this.displayName = value.displayName();
            this.criterion = value.criterion();
            this.objectiveDisplayMode = value.displayMode();
            return this;
        }

        public Builder reset() {
            this.name = null;
            this.displayName = null;
            this.criterion = null;
            this.objectiveDisplayMode = null;
            return this;
        }

        public Objective build() {
            if (this.name == null) {
                throw new IllegalStateException("Name cannot be null!");
            }
            if (this.criterion == null) {
                throw new IllegalStateException("Criterion cannot be null!");
            }
            SpongeObjective objective = new SpongeObjective(this.name, this.criterion);
            if (this.displayName != null) {
                objective.setDisplayName(this.displayName);
            }
            if (this.objectiveDisplayMode != null) {
                objective.setDisplayMode(this.objectiveDisplayMode);
            } else if (this.criterion instanceof class_274) {
                objective.setDisplayMode((ObjectiveDisplayMode)((class_274)this.criterion).method_1227());
            }
            return objective;
        }
    }
}

